/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.filter;

import jakarta.servlet.Filter;
import jakarta.servlet.FilterChain;
import jakarta.servlet.FilterConfig;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import java.io.IOException;
import org.cpsolver.ifs.util.JProf;
import org.unitime.commons.Debug;
import org.unitime.commons.hibernate.util.HibernateUtil;

public class HibSessionFilter
implements Filter {
    private FilterConfig filterConfig = null;

    public void init(FilterConfig arg0) throws ServletException {
        this.filterConfig = arg0;
        Debug.debug("Initializing filter, obtaining Hibernate SessionFactory from HibernateUtil");
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        if (this.filterConfig == null) {
            return;
        }
        if (request.getAttribute("TimeStamp") == null) {
            request.setAttribute("TimeStamp", (Object)JProf.currentTimeSec());
        }
        try {
            chain.doFilter(request, response);
            HibernateUtil.closeCurrentThreadSessions();
        }
        catch (Throwable ex) {
            HibernateUtil.rollbackCurrentThreadSessions();
            if (ex instanceof ServletException) {
                throw (ServletException)ex;
            }
            if (ex instanceof IOException) {
                throw (IOException)ex;
            }
            if (ex instanceof RuntimeException) {
                throw (RuntimeException)ex;
            }
            throw new ServletException(ex);
        }
    }

    public void destroy() {
        this.filterConfig = null;
    }
}

