/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.export.events;

import java.io.IOException;
import java.util.Date;
import java.util.List;
import org.springframework.stereotype.Service;
import org.unitime.timetable.defaults.ApplicationProperty;
import org.unitime.timetable.export.CSVPrinter;
import org.unitime.timetable.export.ExportHelper;
import org.unitime.timetable.export.Exporter;
import org.unitime.timetable.export.events.EventsExporter;
import org.unitime.timetable.gwt.client.events.EventComparator;
import org.unitime.timetable.gwt.shared.EventInterface;
import org.unitime.timetable.util.Formats;

@Service(value="org.unitime.timetable.export.Exporter:events.csv")
public class EventsExportEventsToCSV
extends EventsExporter {
    @Override
    public String reference() {
        return "events.csv";
    }

    @Override
    protected void print(ExportHelper helper, EventInterface.EventLookupRpcRequest request, List<EventInterface> events, int eventCookieFlags, EventComparator.EventMeetingSortBy sort, boolean asc) throws IOException {
        this.sort(events, sort, asc);
        CSVPrinter printer = new CSVPrinter(helper, false);
        helper.setup(printer.getContentType(), this.reference(), false);
        this.hideColumns(printer, events, eventCookieFlags);
        this.print(printer, events, EventInterface.EventFlag.SHOW_MEETING_CONTACTS.in(eventCookieFlags));
    }

    @Override
    protected void hideColumn(Exporter.Printer out, List<EventInterface> events, EventInterface.EventFlag flag) {
        switch (flag) {
            case SHOW_SECTION: {
                out.hideColumn(1);
                break;
            }
            case SHOW_TITLE: {
                out.hideColumn(3);
                break;
            }
            case SHOW_NOTE: {
                out.hideColumn(4);
                break;
            }
            case SHOW_PUBLISHED_TIME: {
                out.hideColumn(8);
                out.hideColumn(9);
                break;
            }
            case SHOW_ALLOCATED_TIME: {
                out.hideColumn(10);
                out.hideColumn(11);
                break;
            }
            case SHOW_SETUP_TIME: {
                out.hideColumn(12);
                break;
            }
            case SHOW_TEARDOWN_TIME: {
                out.hideColumn(13);
                break;
            }
            case SHOW_CAPACITY: {
                out.hideColumn(15);
                break;
            }
            case SHOW_MEETING_CONTACTS: {
                out.hideColumn(16);
                break;
            }
            case SHOW_ENROLLMENT: {
                out.hideColumn(17);
                break;
            }
            case SHOW_LIMIT: {
                out.hideColumn(18);
                break;
            }
            case SHOW_SPONSOR: {
                out.hideColumn(19);
                out.hideColumn(20);
                break;
            }
            case SHOW_REQUESTED_SERVICES: {
                out.hideColumn(21);
                break;
            }
            case SHOW_MAIN_CONTACT: {
                out.hideColumn(22);
                out.hideColumn(23);
                break;
            }
            case SHOW_APPROVAL: {
                out.hideColumn(24);
                break;
            }
            case SHOW_LAST_CHANGE: {
                out.hideColumn(25);
            }
        }
    }

    protected void print(Exporter.Printer out, List<EventInterface> events, boolean showMeetingContacts) throws IOException {
        out.printHeader(MESSAGES.colName(), MESSAGES.colSection(), MESSAGES.colType(), MESSAGES.colTitle(), MESSAGES.colNote(), MESSAGES.colDayOfWeek(), MESSAGES.colFirstDate(), MESSAGES.colLastDate(), MESSAGES.colPublishedStartTime(), MESSAGES.colPublishedEndTime(), MESSAGES.colAllocatedStartTime(), MESSAGES.colAllocatedEndTime(), MESSAGES.colSetupTimeShort(), MESSAGES.colTeardownTimeShort(), MESSAGES.colLocation(), MESSAGES.colCapacity(), MESSAGES.colMeetingContacts(), MESSAGES.colEnrollment(), MESSAGES.colLimit(), MESSAGES.colSponsorOrInstructor(), MESSAGES.colEmail(), MESSAGES.colRequestedServices(), MESSAGES.colMainContact(), MESSAGES.colEmail(), MESSAGES.colApproval(), MESSAGES.colLastChange());
        Formats.Format<Date> df = Formats.getDateFormat(Formats.Pattern.DATE_EVENT);
        int firstDayOfWeek = ApplicationProperty.EventGridStartDay.intValue();
        for (EventInterface event : events) {
            for (EventInterface.MultiMeetingInterface multi : EventInterface.getMultiMeetings(event.getMeetings(), false, showMeetingContacts)) {
                EventInterface.MeetingInterface meeting = multi.getMeetings().first();
                String[] stringArray = new String[26];
                stringArray[0] = this.getName(event);
                stringArray[1] = this.getSection(event);
                stringArray[2] = event.hasInstruction() ? event.getInstruction() : event.getType().getAbbreviation(CONSTANTS);
                stringArray[3] = this.getTitle(event);
                stringArray[4] = event.hasEventNote() ? event.getEventNote("\n").replace("<br>", "\n") : "";
                stringArray[5] = multi.getDays(firstDayOfWeek, CONSTANTS.shortDays(), CONSTANTS.shortDays(), CONSTANTS.daily());
                String string = stringArray[6] = multi.getFirstMeetingDate() == null ? "" : df.format(multi.getFirstMeetingDate());
                stringArray[7] = multi.getLastMeetingDate() == null ? "" : (multi.getNrMeetings() == 1 ? null : df.format(multi.getLastMeetingDate()));
                stringArray[8] = meeting.isArrangeHours() ? "" : meeting.getStartTime(CONSTANTS, true);
                stringArray[9] = meeting.isArrangeHours() ? "" : meeting.getEndTime(CONSTANTS, true);
                stringArray[10] = meeting.isArrangeHours() ? "" : meeting.getStartTime(CONSTANTS, false);
                stringArray[11] = meeting.isArrangeHours() ? "" : meeting.getEndTime(CONSTANTS, false);
                stringArray[12] = meeting.isArrangeHours() ? "" : String.valueOf(meeting.getStartOffset());
                stringArray[13] = meeting.isArrangeHours() ? "" : String.valueOf(-meeting.getEndOffset());
                stringArray[14] = meeting.getLocationName(MESSAGES);
                stringArray[15] = meeting.hasLocation() && meeting.getLocation().hasSize() ? meeting.getLocation().getSize().toString() : null;
                stringArray[16] = meeting.getMeetingContacts(CONSTANTS.meetingContactsSeparator(), MESSAGES);
                stringArray[17] = event.hasEnrollment() ? event.getEnrollment().toString() : null;
                String string2 = stringArray[18] = event.hasMaxCapacity() ? event.getMaxCapacity().toString() : null;
                String string3 = event.hasInstructors() ? event.getInstructorNames("\n", MESSAGES) : (stringArray[19] = event.hasSponsor() ? event.getSponsor().getName() : null);
                stringArray[20] = event.hasInstructors() ? event.getInstructorEmails("\n") : (event.hasSponsor() ? event.getSponsor().getEmail() : null);
                stringArray[21] = event.hasRequestedServices() ? event.getRequestedServices("\n") : null;
                stringArray[22] = event.hasContact() ? event.getContact().getName(MESSAGES) : null;
                String string4 = stringArray[23] = event.hasContact() ? event.getContact().getEmail() : null;
                stringArray[24] = event.getType() == EventInterface.EventType.Unavailabile ? "" : (multi.getApprovalStatus() == EventInterface.ApprovalStatus.Approved ? df.format(multi.getApprovalDate()) : (multi.getApprovalStatus() == EventInterface.ApprovalStatus.Cancelled ? MESSAGES.approvalCancelled() : (multi.getApprovalStatus() == EventInterface.ApprovalStatus.Rejected ? MESSAGES.approvalRejected() : (multi.getApprovalStatus() == EventInterface.ApprovalStatus.Deleted ? MESSAGES.approvalDeleted() : (multi.isPast() ? MESSAGES.approvalNotApprovedPast() : (event.getExpirationDate() != null ? MESSAGES.approvalExpire(df.format(event.getExpirationDate())) : MESSAGES.approvalNotApproved()))))));
                stringArray[25] = event.getLastNote() != null ? df.format(event.getLastNote().getDate()) + " " + event.getLastNote().getType().getName() : null;
                out.printLine(stringArray);
            }
            out.flush();
        }
        out.close();
    }
}

