/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.export.events;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.TreeSet;
import org.springframework.stereotype.Service;
import org.unitime.localization.impl.Localization;
import org.unitime.timetable.events.EventAction;
import org.unitime.timetable.events.EventEnrollmentsBackend;
import org.unitime.timetable.export.CSVPrinter;
import org.unitime.timetable.export.ExportHelper;
import org.unitime.timetable.export.Exporter;
import org.unitime.timetable.gwt.client.sectioning.EnrollmentTable;
import org.unitime.timetable.gwt.command.client.GwtRpcResponseList;
import org.unitime.timetable.gwt.resources.GwtMessages;
import org.unitime.timetable.gwt.resources.StudentSectioningMessages;
import org.unitime.timetable.gwt.shared.ClassAssignmentInterface;
import org.unitime.timetable.gwt.shared.EventInterface;
import org.unitime.timetable.gwt.shared.OnlineSectioningInterface;
import org.unitime.timetable.model.ClassEvent;
import org.unitime.timetable.model.Class_;
import org.unitime.timetable.model.CourseEvent;
import org.unitime.timetable.model.Event;
import org.unitime.timetable.model.ExamEvent;
import org.unitime.timetable.model.Session;
import org.unitime.timetable.model.dao.ClassEventDAO;
import org.unitime.timetable.model.dao.Class_DAO;
import org.unitime.timetable.model.dao.CourseEventDAO;
import org.unitime.timetable.model.dao.EventDAO;
import org.unitime.timetable.model.dao.ExamEventDAO;
import org.unitime.timetable.util.Formats;

@Service(value="org.unitime.timetable.export.Exporter:event-enrollments.csv")
public class EventEnrollmentExport
implements Exporter {
    public static final StudentSectioningMessages MESSAGES = Localization.create(StudentSectioningMessages.class);
    public static final GwtMessages GWT_MSG = Localization.create(GwtMessages.class);
    protected static Formats.Format<Date> sDF = Formats.getDateFormat(Formats.Pattern.DATE_REQUEST);
    protected static Formats.Format<Date> sTSF = Formats.getDateFormat(Formats.Pattern.DATE_TIME_STAMP);

    @Override
    public String reference() {
        return "event-enrollments.csv";
    }

    @Override
    public void export(ExportHelper helper) throws IOException {
        String eventId = helper.getParameter("event");
        if (eventId == null) {
            throw new IllegalArgumentException("Event parameter not provided.");
        }
        Class_ clazz = null;
        Event event = null;
        if (Long.valueOf(eventId) < 0L) {
            clazz = (Class_)Class_DAO.getInstance().get(-Long.valueOf(eventId).longValue());
        } else {
            event = (Event)EventDAO.getInstance().get(Long.valueOf(eventId));
            if (event != null && event instanceof CourseEvent) {
                event = (Event)CourseEventDAO.getInstance().get(event.getUniqueId());
            } else if (event != null && event instanceof ExamEvent) {
                event = (Event)ExamEventDAO.getInstance().get(event.getUniqueId());
            } else if (event != null && event instanceof ClassEvent) {
                event = (Event)ClassEventDAO.getInstance().get(event.getUniqueId());
            }
        }
        if (clazz == null && event == null) {
            throw new IllegalArgumentException("Given event does not exist.");
        }
        EventInterface.EventEnrollmentsRpcRequest request = new EventInterface.EventEnrollmentsRpcRequest();
        request.setEventId(event != null ? event.getUniqueId() : -clazz.getUniqueId().longValue());
        Session session = event != null ? event.getSession() : clazz.getControllingDept().getSession();
        EventAction.EventContext context = new EventAction.EventContext(helper.getSessionContext(), helper.getSessionContext().getUser(), session != null ? session.getUniqueId() : null);
        int sort = 0;
        if (helper.getParameter("sort") != null) {
            sort = Integer.parseInt(helper.getParameter("sort"));
        }
        GwtRpcResponseList<ClassAssignmentInterface.Enrollment> enrollments = new EventEnrollmentsBackend().execute(request, context);
        this.export(enrollments, helper, "1".equalsIgnoreCase(helper.getParameter("suffix")), sort, helper.getParameter("subpart"));
    }

    protected Exporter.Printer createPrinter(ExportHelper helper) throws IOException {
        CSVPrinter out = new CSVPrinter(helper, false);
        helper.setup(out.getContentType(), this.reference(), false);
        return out;
    }

    protected void export(List<ClassAssignmentInterface.Enrollment> enrollments, ExportHelper helper, boolean suffix, int sort, String sortBySubpart) throws IOException {
        Exporter.Printer out = this.createPrinter(helper);
        if (enrollments == null) {
            enrollments = new ArrayList<ClassAssignmentInterface.Enrollment>();
        }
        if (sort != 0) {
            asc = sort > 0;
            EnrollmentTable.EnrollmentComparator.SortBy sortBy = EnrollmentTable.EnrollmentComparator.SortBy.values()[Math.abs(sort) - 1];
            Collections.sort(enrollments, new EnrollmentTable.EnrollmentComparator(sortBy, helper.getParameter("group")));
            if (!asc) {
                Collections.reverse(enrollments);
            }
        } else if (sortBySubpart != null && !sortBySubpart.isEmpty()) {
            asc = !sortBySubpart.startsWith("-");
            Collections.sort(enrollments, new EnrollmentTable.EnrollmentComparator(asc ? sortBySubpart : sortBySubpart.substring(1), suffix));
            if (!asc) {
                Collections.reverse(enrollments);
            }
        } else {
            Collections.sort(enrollments, new Comparator<ClassAssignmentInterface.Enrollment>(){

                @Override
                public int compare(ClassAssignmentInterface.Enrollment e1, ClassAssignmentInterface.Enrollment e2) {
                    int cmp = e1.getStudent().getName().compareTo(e2.getStudent().getName());
                    if (cmp != 0) {
                        return cmp;
                    }
                    return e1.getStudent().getId() < e2.getStudent().getId() ? -1 : 1;
                }
            });
        }
        boolean hasExtId = false;
        for (ClassAssignmentInterface.Enrollment e : enrollments) {
            if (!e.getStudent().isCanShowExternalId()) continue;
            hasExtId = true;
            break;
        }
        ArrayList<String> header = new ArrayList<String>();
        if (hasExtId) {
            header.add(MESSAGES.colStudentExternalId());
        }
        header.add(MESSAGES.colStudent());
        header.add(GWT_MSG.colEmail());
        boolean crosslist = false;
        Long courseId = null;
        for (ClassAssignmentInterface.Enrollment e : enrollments) {
            if (courseId == null) {
                courseId = e.getCourseId();
            } else if (e.getCourseId() != courseId) {
                crosslist = true;
                break;
            }
            if (e.getCourse() == null || !e.getCourse().hasCrossList()) continue;
            crosslist = true;
            break;
        }
        if (crosslist) {
            header.add(MESSAGES.colCourse());
        }
        boolean hasPriority = false;
        boolean hasArea = false;
        boolean hasMajor = false;
        boolean hasGroup = false;
        boolean hasAcmd = false;
        boolean hasAlternative = false;
        boolean hasReservation = false;
        boolean hasRequestedDate = false;
        boolean hasEnrolledDate = false;
        boolean hasConflict = false;
        boolean hasMessage = false;
        boolean hasAdvisor = false;
        boolean hasMinor = false;
        boolean hasConc = false;
        boolean hasDeg = false;
        boolean hasProg = false;
        boolean hasCamp = false;
        boolean hasWaitlistedDate = false;
        boolean hasWaitListedPosition = false;
        boolean hasWaitListReplacement = false;
        boolean hasCritical = false;
        TreeSet<String> groupTypes = new TreeSet<String>();
        for (ClassAssignmentInterface.Enrollment e : enrollments) {
            if (e.getPriority() > 0) {
                hasPriority = true;
            }
            if (e.isAlternative()) {
                hasAlternative = true;
            }
            if (e.getStudent().hasArea()) {
                hasArea = true;
            }
            if (e.getStudent().hasMajor()) {
                hasMajor = true;
            }
            if (e.getStudent().hasGroup()) {
                hasGroup = true;
            }
            if (e.getStudent().hasAccommodation()) {
                hasAcmd = true;
            }
            if (e.getReservation() != null) {
                hasReservation = true;
            }
            if (e.getRequestedDate() != null) {
                hasRequestedDate = true;
            }
            if (e.getEnrolledDate() != null) {
                hasEnrolledDate = true;
            }
            if (e.hasConflict()) {
                hasConflict = true;
            }
            if (e.hasEnrollmentMessage()) {
                hasMessage = true;
            }
            if (e.getStudent().hasGroups()) {
                groupTypes.addAll(e.getStudent().getGroupTypes());
            }
            if (e.getStudent().hasAdvisor()) {
                hasAdvisor = true;
            }
            if (e.getStudent().hasMinor()) {
                hasMinor = true;
            }
            if (e.getStudent().hasConcentration()) {
                hasConc = true;
            }
            if (e.getStudent().hasDegree()) {
                hasDeg = true;
            }
            if (e.getStudent().hasProgram()) {
                hasProg = true;
            }
            if (e.getStudent().hasCampus()) {
                hasCamp = true;
            }
            if (e.hasWaitListedDate()) {
                hasWaitlistedDate = true;
            }
            if (e.hasWaitListedPosition()) {
                hasWaitListedPosition = true;
            }
            if (e.hasWaitListedReplacement()) {
                hasWaitListReplacement = true;
            }
            if (e.getCritical() == null || e.getCritical() <= 0) continue;
            hasCritical = true;
        }
        if (hasPriority) {
            header.add(MESSAGES.colPriority());
        }
        if (hasAlternative) {
            header.add(MESSAGES.colAlternative());
        }
        if (hasCamp) {
            header.add(MESSAGES.colCampus());
        }
        if (hasArea) {
            header.add(MESSAGES.colArea());
            header.add(MESSAGES.colClassification());
        }
        if (hasDeg) {
            header.add(MESSAGES.colDegree());
        }
        if (hasProg) {
            header.add(MESSAGES.colProgram());
        }
        if (hasMajor) {
            header.add(MESSAGES.colMajor());
        }
        if (hasConc) {
            header.add(MESSAGES.colConcentration());
        }
        if (hasMinor) {
            header.add(MESSAGES.colMinor());
        }
        if (hasGroup) {
            header.add(MESSAGES.colGroup());
        }
        for (String g : groupTypes) {
            header.add(g);
        }
        if (hasAcmd) {
            header.add(MESSAGES.colAccommodation());
        }
        if (hasReservation) {
            header.add(MESSAGES.colReservation());
        }
        TreeSet<String> subparts = new TreeSet<String>();
        for (ClassAssignmentInterface.Enrollment e : enrollments) {
            if (!e.hasClasses()) continue;
            for (ClassAssignmentInterface.ClassAssignment c : e.getClasses()) {
                subparts.add(c.getSubpart());
            }
        }
        for (String subpart : subparts) {
            header.add(subpart);
        }
        if (hasCritical) {
            header.add(MESSAGES.colCritical());
        }
        if (hasRequestedDate) {
            header.add(MESSAGES.colRequestTimeStamp());
        }
        if (hasEnrolledDate) {
            header.add(MESSAGES.colEnrollmentTimeStamp());
        }
        if (hasWaitlistedDate) {
            header.add(MESSAGES.colWaitListedTimeStamp());
        }
        if (hasWaitListReplacement) {
            header.add(MESSAGES.colWaitListSwapWithCourseOffering());
        }
        if (hasWaitListedPosition) {
            header.add(MESSAGES.colWaitListPosition());
        }
        if (hasAdvisor) {
            header.add(MESSAGES.colAdvisor());
        }
        if (hasMessage) {
            header.add(MESSAGES.colMessage());
        }
        if (hasConflict) {
            header.add(MESSAGES.colConflictType());
            header.add(MESSAGES.colConflictName());
            header.add(MESSAGES.colConflictDate());
            header.add(MESSAGES.colConflictTime());
            header.add(MESSAGES.colConflictRoom());
        }
        out.printHeader(header.toArray(new String[header.size()]));
        out.flush();
        for (ClassAssignmentInterface.Enrollment enrollment : enrollments) {
            ArrayList<String> line = new ArrayList<String>();
            if (hasExtId) {
                line.add(enrollment.getStudent().isCanShowExternalId() ? enrollment.getStudent().getExternalId() : "");
            }
            line.add(enrollment.getStudent().getName());
            line.add(enrollment.getStudent().getEmail());
            if (crosslist) {
                line.add(enrollment.getCourseName());
            }
            if (hasPriority) {
                line.add(enrollment.getPriority() <= 0 ? "" : MESSAGES.priority(enrollment.getPriority()));
            }
            if (hasAlternative) {
                line.add(enrollment.getAlternative());
            }
            if (hasCamp) {
                line.add(enrollment.getStudent().getCampus("\n"));
            }
            if (hasArea) {
                line.add(enrollment.getStudent().getArea("\n"));
                line.add(enrollment.getStudent().getClassification("\n"));
            }
            if (hasDeg) {
                line.add(enrollment.getStudent().getDegree("\n"));
            }
            if (hasProg) {
                line.add(enrollment.getStudent().getProgram("\n"));
            }
            if (hasMajor) {
                line.add(enrollment.getStudent().getMajor("\n"));
            }
            if (hasConc) {
                line.add(enrollment.getStudent().getConcentration("\n"));
            }
            if (hasMinor) {
                line.add(enrollment.getStudent().getMinor("\n"));
            }
            if (hasGroup) {
                line.add(enrollment.getStudent().getGroup("\n"));
            }
            for (String g : groupTypes) {
                line.add(enrollment.getStudent().getGroup(g, "\n"));
            }
            if (hasAcmd) {
                line.add(enrollment.getStudent().getAccommodation("\n"));
            }
            if (hasReservation) {
                line.add(enrollment.getReservation() == null ? "" : enrollment.getReservation());
            }
            if (!subparts.isEmpty()) {
                if (!enrollment.hasClasses()) {
                    line.add(enrollment.isWaitList() && enrollment.getStudent().getWaitListMode() == OnlineSectioningInterface.WaitListMode.WaitList ? MESSAGES.courseWaitListed() : MESSAGES.courseNotEnrolled());
                    for (int i = 1; i < subparts.size(); ++i) {
                        line.add("");
                    }
                } else {
                    for (String subpart : subparts) {
                        line.add(enrollment.getClasses(subpart, ", ", suffix));
                    }
                }
            }
            if (hasCritical) {
                line.add(enrollment.isCritical() ? MESSAGES.opSetCritical() : (enrollment.isImportant() ? MESSAGES.opSetImportant() : (enrollment.isVital() ? MESSAGES.opSetVital() : (enrollment.isLC() ? MESSAGES.opSetLC() : (enrollment.isVisitingLC() ? MESSAGES.opSetVisitingF2F() : MESSAGES.opSetNotCritical())))));
            }
            if (hasRequestedDate) {
                line.add(enrollment.getRequestedDate() == null ? "" : sDF.format(enrollment.getRequestedDate()));
            }
            if (hasEnrolledDate) {
                line.add(enrollment.getEnrolledDate() == null ? "" : sDF.format(enrollment.getEnrolledDate()));
            }
            if (hasWaitlistedDate) {
                line.add(enrollment.hasWaitListedDate() ? sTSF.format(enrollment.getWaitListedDate()) : "");
            }
            if (hasWaitListReplacement) {
                line.add(enrollment.hasWaitListedReplacement() ? enrollment.getWaitListReplacement() : "");
            }
            if (hasWaitListedPosition) {
                line.add(enrollment.hasWaitListedPosition() ? enrollment.getWaitListedPosition() : "");
            }
            if (hasAdvisor) {
                line.add(enrollment.getStudent().getAdvisor("\n"));
            }
            if (hasMessage) {
                line.add(enrollment.hasEnrollmentMessage() ? enrollment.getEnrollmentMessage() : "");
            }
            if (hasConflict) {
                if (enrollment.hasConflict()) {
                    Object name = "";
                    Object type = "";
                    Object date = "";
                    Object time = "";
                    Object room = "";
                    for (ClassAssignmentInterface.Conflict conflict : enrollment.getConflicts()) {
                        if (!((String)name).isEmpty()) {
                            name = (String)name + "\n";
                            type = (String)type + "\n";
                            date = (String)date + "\n";
                            time = (String)time + "\n";
                            room = (String)room + "\n";
                        }
                        name = (String)name + conflict.getName().replace("<br>", "\n");
                        type = (String)type + conflict.getType().replace("<br>", "\n");
                        date = (String)date + conflict.getDate().replace("<br>", "\n");
                        time = (String)time + conflict.getTime().replace("<br>", "\n");
                        room = (String)room + conflict.getRoom().replace("<br>", "\n");
                    }
                    line.add((String)type);
                    line.add((String)name);
                    line.add((String)date);
                    line.add((String)time);
                    line.add((String)room);
                } else {
                    line.add("");
                    line.add("");
                    line.add("");
                    line.add("");
                    line.add("");
                }
            }
            out.printLine(line.toArray(new String[line.size()]));
        }
        out.flush();
        out.close();
    }
}

