/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.export.courses;

import java.io.IOException;
import java.util.List;
import org.springframework.stereotype.Service;
import org.unitime.timetable.export.CSVPrinter;
import org.unitime.timetable.export.ExportHelper;
import org.unitime.timetable.export.courses.OfferingsCSV;
import org.unitime.timetable.gwt.client.tables.TableInterface;
import org.unitime.timetable.security.rights.Right;

@Service(value="org.unitime.timetable.export.Exporter:classes.csv")
public class ClassesCSV
extends OfferingsCSV {
    @Override
    public String reference() {
        return "classes.csv";
    }

    @Override
    public void export(ExportHelper helper) throws IOException {
        this.checkPermission(helper, Right.ClassesExportPDF);
        this.exportDataCsv(this.getClasses(helper), helper);
    }

    @Override
    protected void exportDataCsv(List<TableInterface> response, ExportHelper helper) throws IOException {
        CSVPrinter printer = new CSVPrinter(helper, false);
        helper.setup(printer.getContentType(), this.reference(), false);
        boolean firstTable = true;
        for (TableInterface table : response) {
            if (table.getHeader() != null) {
                if (firstTable) {
                    for (TableInterface.LineInterface line : table.getHeader()) {
                        printer.printHeader(this.toLine(line));
                    }
                }
                firstTable = false;
            }
            if (table.getLines() == null) continue;
            for (TableInterface.LineInterface line : table.getLines()) {
                printer.printLine(this.toLine(line));
            }
        }
        printer.flush();
        printer.close();
    }
}

