/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.events;

import java.math.BigInteger;
import java.security.Key;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.spec.InvalidKeySpecException;
import java.util.Base64;
import java.util.Date;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.SecretKeySpec;
import org.unitime.timetable.defaults.ApplicationProperty;
import org.unitime.timetable.gwt.command.client.GwtRpcException;
import org.unitime.timetable.gwt.command.server.GwtRpcImplementation;
import org.unitime.timetable.gwt.command.server.GwtRpcImplements;
import org.unitime.timetable.gwt.shared.EventInterface;
import org.unitime.timetable.model.HashedQuery;
import org.unitime.timetable.model.dao.HashedQueryDAO;
import org.unitime.timetable.security.SessionContext;

@GwtRpcImplements(value=EventInterface.EncodeQueryRpcRequest.class)
public class QueryEncoderBackend
implements GwtRpcImplementation<EventInterface.EncodeQueryRpcRequest, EventInterface.EncodeQueryRpcResponse> {
    @Override
    public EventInterface.EncodeQueryRpcResponse execute(EventInterface.EncodeQueryRpcRequest request, SessionContext context) {
        String query = request.getQuery() + (String)(context.getUser() == null ? "" : "&user=" + context.getUser().getExternalUserId() + (String)(context.getUser() == null || context.getUser().getCurrentAuthority() == null ? "" : "&role=" + context.getUser().getCurrentAuthority().getRole()));
        if (request.isHash() && ApplicationProperty.UrlEncoderHashQueryWhenAsked.isTrue()) {
            return new EventInterface.EncodeQueryRpcResponse(QueryEncoderBackend.encode(query), QueryEncoderBackend.hash(query));
        }
        return new EventInterface.EncodeQueryRpcResponse(QueryEncoderBackend.encode(query));
    }

    private static SecretKey secret() throws NoSuchAlgorithmException, InvalidKeySpecException {
        byte[] salt = new byte[]{51, 123, 9, 14, -49, 90, 88, -39};
        SecretKeyFactory factory = SecretKeyFactory.getInstance(ApplicationProperty.UrlEncoderSecretAlgorithm.value());
        PBEKeySpec spec = new PBEKeySpec(ApplicationProperty.UrlEncoderSecret.value().toCharArray(), salt, ApplicationProperty.UrlEncoderSecretIterationCount.intValue(), ApplicationProperty.UrlEncoderSecretKeyLength.intValue());
        SecretKey key = factory.generateSecret(spec);
        return new SecretKeySpec(key.getEncoded(), "AES");
    }

    public static String encode(String text) {
        try {
            if (ApplicationProperty.UrlEncoderCipher.value().contains("/ECB/")) {
                Cipher cipher = Cipher.getInstance(ApplicationProperty.UrlEncoderCipher.value());
                cipher.init(1, QueryEncoderBackend.secret());
                return Base64.getUrlEncoder().withoutPadding().encodeToString(cipher.doFinal(text.getBytes()));
            }
            byte[] iv = new byte[16];
            SecureRandom random = new SecureRandom();
            random.nextBytes(iv);
            IvParameterSpec ivSpec = new IvParameterSpec(iv);
            Cipher cipher = Cipher.getInstance(ApplicationProperty.UrlEncoderCipher.value());
            cipher.init(1, (Key)QueryEncoderBackend.secret(), ivSpec);
            byte[] encrypted = cipher.doFinal(text.getBytes());
            byte[] encryptedIVAndText = new byte[iv.length + encrypted.length];
            System.arraycopy(iv, 0, encryptedIVAndText, 0, iv.length);
            System.arraycopy(encrypted, 0, encryptedIVAndText, iv.length, encrypted.length);
            return Base64.getUrlEncoder().withoutPadding().encodeToString(encryptedIVAndText);
        }
        catch (Exception e) {
            throw new GwtRpcException("Encoding failed: " + e.getMessage(), e);
        }
    }

    public static String hash(String text) {
        try {
            if (text.length() > 2048) {
                return null;
            }
            MessageDigest md5 = MessageDigest.getInstance("MD5");
            Date ts = new Date();
            String hash = new BigInteger(md5.digest(text.getBytes())).toString(36) + Long.toString(ts.getTime(), 36);
            HashedQuery hq = new HashedQuery();
            hq.setQueryHash(hash);
            hq.setQueryText(text);
            hq.setCreated(ts);
            hq.setNbrUsed(0L);
            hq.setLastUsed(ts);
            HashedQueryDAO.getInstance().getSession().persist((Object)hq);
            HashedQueryDAO.getInstance().getSession().flush();
            return hash;
        }
        catch (Exception e) {
            throw new GwtRpcException("Hashing failed: " + e.getMessage(), e);
        }
    }

    public static String decode(String text) {
        return QueryEncoderBackend.decode(text, false);
    }

    public static String decode(String text, boolean hash) {
        try {
            if (text == null || text.isEmpty()) {
                return null;
            }
            if (hash) {
                HashedQuery hq = (HashedQuery)HashedQueryDAO.getInstance().get(text);
                if (hq == null) {
                    throw new GwtRpcException("The query hash " + text + " no longer exists. Please create a new URL.");
                }
                hq.setNbrUsed(1L + hq.getNbrUsed());
                hq.setLastUsed(new Date());
                HashedQueryDAO.getInstance().getSession().merge((Object)hq);
                HashedQueryDAO.getInstance().getSession().flush();
                return hq.getQueryText();
            }
            if (ApplicationProperty.UrlEncoderCipher.value().contains("/ECB/")) {
                Cipher cipher = Cipher.getInstance(ApplicationProperty.UrlEncoderCipher.value());
                cipher.init(2, QueryEncoderBackend.secret());
                try {
                    return new String(cipher.doFinal(Base64.getUrlDecoder().decode(text)));
                }
                catch (Exception e) {
                    try {
                        return new String(cipher.doFinal(new BigInteger(text, 36).toByteArray()));
                    }
                    catch (IllegalBlockSizeException x) {
                        byte[] bytes = new BigInteger(text, 36).toByteArray();
                        byte[] fixed = new byte[(1 + bytes.length / cipher.getBlockSize()) * cipher.getBlockSize()];
                        for (int i = 0; i < fixed.length - bytes.length; ++i) {
                            fixed[i] = -1;
                        }
                        System.arraycopy(bytes, 0, fixed, fixed.length - bytes.length, bytes.length);
                        return new String(cipher.doFinal(fixed));
                    }
                }
            }
            byte[] iv = new byte[16];
            byte[] encryptedIvTextBytes = Base64.getUrlDecoder().decode(text);
            System.arraycopy(encryptedIvTextBytes, 0, iv, 0, iv.length);
            IvParameterSpec ivSpec = new IvParameterSpec(iv);
            Cipher cipher = Cipher.getInstance(ApplicationProperty.UrlEncoderCipher.value());
            cipher.init(2, (Key)QueryEncoderBackend.secret(), ivSpec);
            int encryptedSize = encryptedIvTextBytes.length - iv.length;
            byte[] encryptedBytes = new byte[encryptedSize];
            System.arraycopy(encryptedIvTextBytes, iv.length, encryptedBytes, 0, encryptedSize);
            return new String(cipher.doFinal(encryptedBytes));
        }
        catch (Exception e) {
            throw new GwtRpcException("Decoding failed: " + e.getMessage(), e);
        }
    }

    public static void main(String[] args) {
        System.out.println(QueryEncoderBackend.encode("output=events.csv&type=PERSON&ext=1001&token=1xhp5vo3zfxrpbzjzhtanmcipolx03fv42ohz4xa507x5acydh&user=1001"));
    }
}

