/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.dataexchange;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.Iterator;
import org.cpsolver.ifs.util.DataProperties;
import org.dom4j.Element;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.XMLWriter;
import org.unitime.timetable.dataexchange.BaseImport;
import org.unitime.timetable.model.Session;
import org.unitime.timetable.model.dao.SessionDAO;
import org.unitime.timetable.solver.SolverProxy;
import org.unitime.timetable.solver.exam.ExamSolverProxy;
import org.unitime.timetable.solver.instructor.InstructorSchedulingProxy;
import org.unitime.timetable.solver.service.SolverServerService;
import org.unitime.timetable.solver.studentsct.StudentSolverProxy;
import org.unitime.timetable.spring.SpringApplicationContextHolder;

public class SolverImport
extends BaseImport {
    @Override
    public void loadXml(Element root) throws Exception {
        try {
            this.beginTransaction();
            SolverServerService solverService = (SolverServerService)SpringApplicationContextHolder.getBean("solverServerService");
            if (root.getName().equalsIgnoreCase("timetable") || root.getName().equalsIgnoreCase("coursett")) {
                root.setName("timetable");
                SolverProxy solver = solverService.getCourseSolverContainer().createSolver(this.getManager().getExternalUniqueId(), this.getConfig(root));
                solver.importXml(this.toData(root));
            } else if (root.getName().equalsIgnoreCase("examtt")) {
                ExamSolverProxy solver = solverService.getExamSolverContainer().createSolver(this.getManager().getExternalUniqueId(), this.getConfig(root));
                solver.importXml(this.toData(root));
            } else if (root.getName().equalsIgnoreCase("sectioning")) {
                StudentSolverProxy solver = solverService.getStudentSolverContainer().createSolver(this.getManager().getExternalUniqueId(), this.getConfig(root));
                solver.importXml(this.toData(root));
            } else if (root.getName().equalsIgnoreCase("instructor-schedule")) {
                InstructorSchedulingProxy solver = solverService.getInstructorSchedulingContainer().createSolver(this.getManager().getExternalUniqueId(), this.getConfig(root));
                solver.importXml(this.toData(root));
            } else {
                throw new Exception("Given XML file is not a solver file.");
            }
            this.commitTransaction();
        }
        catch (Exception e) {
            this.fatal("Exception: " + e.getMessage(), e);
            this.rollbackTransaction();
            throw e;
        }
    }

    protected DataProperties getConfig(Element root) {
        DataProperties config = new DataProperties();
        if (root.element("configuration") != null) {
            Iterator i = root.element("configuration").elementIterator("property");
            while (i.hasNext()) {
                Element e = (Element)i.next();
                config.setProperty(e.attributeValue("name"), e.getText());
            }
        }
        config.setProperty("General.OwnerPuid", this.getManager().getExternalUniqueId());
        Session session = Session.getSessionUsingInitiativeYearTerm(root.attributeValue("initiative", root.attributeValue("campus")), root.attributeValue("year"), root.attributeValue("term"));
        if (session != null) {
            config.setProperty("General.SessionId", session.getUniqueId().toString());
        } else {
            Long sessionId = config.getPropertyLong("General.SessionId", null);
            if (sessionId == null) {
                throw new RuntimeException("Academic session id not provided.");
            }
            session = (Session)SessionDAO.getInstance().get(sessionId, this.getHibSession());
            if (session == null) {
                throw new RuntimeException("Academic session " + sessionId + " does not exist.");
            }
        }
        config.setProperty("General.Save", "false");
        config.setProperty("General.CreateNewSolution", "false");
        config.setProperty("General.Unload", "false");
        return config;
    }

    protected byte[] toData(Element root) throws UnsupportedEncodingException, IOException {
        Element configEl = root.element("configuration");
        if (configEl != null) {
            root.remove(configEl);
        }
        ByteArrayOutputStream ret = new ByteArrayOutputStream();
        new XMLWriter((OutputStream)ret, OutputFormat.createCompactFormat()).write(root.getDocument());
        ret.flush();
        ret.close();
        return ret.toByteArray();
    }
}

