/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.dataexchange;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.Vector;
import org.unitime.commons.Email;
import org.unitime.timetable.dataexchange.BaseImport;
import org.unitime.timetable.defaults.ApplicationProperty;
import org.unitime.timetable.model.Meeting;
import org.unitime.timetable.model.NonUniversityLocation;
import org.unitime.timetable.model.Session;
import org.unitime.timetable.util.CalendarUtils;
import org.unitime.timetable.util.Constants;

public abstract class EventRelatedImports
extends BaseImport {
    protected String timeFormat = null;
    protected Vector<String> changeList = new Vector();
    protected TreeSet<String> missingLocations = new TreeSet();
    protected Vector<String> notes = new Vector();
    protected String dateFormat = null;
    protected boolean trimLeadingZerosFromExternalId = false;
    protected Session session = null;

    protected abstract String getEmailSubject();

    protected void addNote(String note) {
        this.notes.add(note);
    }

    protected void clearNotes() {
        this.notes = new Vector();
    }

    protected void updateChangeList(boolean changed) {
        if (changed && this.notes != null) {
            this.changeList.addAll(this.notes);
            String note2 = null;
            for (String note2 : this.notes) {
                this.info(note2);
            }
        }
        this.clearNotes();
    }

    protected void addMissingLocation(String location) {
        this.missingLocations.add(location);
    }

    protected void reportMissingLocations() {
        if (!this.missingLocations.isEmpty()) {
            this.changeList.add("\nMissing Locations\n");
            this.info("\nMissing Locations\n");
            for (String location : this.missingLocations) {
                this.changeList.add("\t" + location);
                this.info("\t" + location);
            }
        }
    }

    protected void mailLoadResults() {
        try {
            Email email = Email.createEmail();
            email.setSubject("UniTime (Data Import): " + this.getEmailSubject());
            Object mail = "";
            Iterator<String> it = this.changeList.iterator();
            while (it.hasNext()) {
                mail = (String)mail + it.next() + "\n";
            }
            email.setText((String)mail);
            email.addRecipient(this.getManager().getEmailAddress(), this.getManager().getName());
            if (ApplicationProperty.EmailNotificationDataExchange.isTrue()) {
                email.addNotifyCC();
            }
            email.send();
        }
        catch (Exception e) {
            sLog.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    protected Session findSession(String academicInitiative, String academicYear, String academicTerm) {
        return (Session)this.getHibSession().createQuery("from Session as s where s.academicInitiative = :academicInititive and s.academicYear = :academicYear  and s.academicTerm = :academicTerm", Session.class).setParameter("academicInititive", (Object)academicInitiative).setParameter("academicYear", (Object)academicYear).setParameter("academicTerm", (Object)academicTerm).setCacheable(true).uniqueResult();
    }

    protected List<NonUniversityLocation> findNonUniversityLocationsWithIdOrName(String id, String name) {
        if (id != null) {
            return this.getHibSession().createQuery("select distinct l from NonUniversityLocation as l where l.externalUniqueId=:id and l.session.uniqueId=:sessionId", NonUniversityLocation.class).setParameter("sessionId", (Object)this.session.getUniqueId()).setParameter("id", (Object)id).setCacheable(true).list();
        }
        if (name != null) {
            return this.getHibSession().createQuery("select distinct l from NonUniversityLocation as l where l.name=:name and l.session.uniqueId=:sessionId", NonUniversityLocation.class).setParameter("sessionId", (Object)this.session.getUniqueId()).setParameter("name", (Object)name).setCacheable(true).list();
        }
        return new ArrayList<NonUniversityLocation>();
    }

    protected List<NonUniversityLocation> findNonUniversityLocationsWithName(String name) {
        if (name != null) {
            return this.getHibSession().createQuery("select distinct l from NonUniversityLocation as l where l.name=:name and l.session.uniqueId=:sessionId", NonUniversityLocation.class).setParameter("sessionId", (Object)this.session.getUniqueId()).setParameter("name", (Object)name).setCacheable(true).list();
        }
        return new ArrayList<NonUniversityLocation>();
    }

    protected class TimeObject {
        private Integer startPeriod;
        private Integer endPeriod;
        private Set<Integer> days;
        private String patternName = null;

        TimeObject(String startTime, String endTime, String daysOfWeek) throws Exception {
            this(startTime, endTime, daysOfWeek, null);
        }

        TimeObject(String startTime, String endTime, String daysOfWeek, String name) throws Exception {
            this.startPeriod = this.str2Slot(startTime);
            this.endPeriod = this.str2Slot(endTime);
            this.patternName = name;
            if (this.endPeriod == 0) {
                this.endPeriod = 288;
            }
            if (this.startPeriod >= this.endPeriod) {
                throw new Exception("Invalid time '" + startTime + "' must be before (" + endTime + ").");
            }
            if (daysOfWeek == null || daysOfWeek.length() == 0) {
                return;
            }
            this.setDaysOfWeek(daysOfWeek);
        }

        private void setDaysOfWeek(String daysOfWeek) {
            this.days = new TreeSet<Integer>();
            String tmpDays = daysOfWeek;
            if (tmpDays.contains("Th")) {
                this.days.add(5);
                tmpDays = tmpDays.replace("Th", "..");
            }
            if (tmpDays.contains("R")) {
                this.days.add(5);
                tmpDays = tmpDays.replace("R", "..");
            }
            if (tmpDays.contains("Su")) {
                this.days.add(1);
                tmpDays = tmpDays.replace("Su", "..");
            }
            if (tmpDays.contains("U")) {
                this.days.add(1);
                tmpDays = tmpDays.replace("U", "..");
            }
            if (tmpDays.contains("M")) {
                this.days.add(2);
                tmpDays = tmpDays.replace("M", ".");
            }
            if (tmpDays.contains("T")) {
                this.days.add(3);
                tmpDays = tmpDays.replace("T", ".");
            }
            if (tmpDays.contains("W")) {
                this.days.add(4);
                tmpDays = tmpDays.replace("W", ".");
            }
            if (tmpDays.contains("F")) {
                this.days.add(6);
                tmpDays = tmpDays.replace("F", ".");
            }
            if (tmpDays.contains("S")) {
                this.days.add(7);
                tmpDays = tmpDays.replace("S", ".");
            }
        }

        public int getDayCode() {
            if (this.days == null || this.days.isEmpty()) {
                return 0;
            }
            int dayCode = 0;
            if (this.days.contains(2)) {
                dayCode += Constants.DAY_CODES[0];
            }
            if (this.days.contains(3)) {
                dayCode += Constants.DAY_CODES[1];
            }
            if (this.days.contains(4)) {
                dayCode += Constants.DAY_CODES[2];
            }
            if (this.days.contains(5)) {
                dayCode += Constants.DAY_CODES[3];
            }
            if (this.days.contains(6)) {
                dayCode += Constants.DAY_CODES[4];
            }
            if (this.days.contains(7)) {
                dayCode += Constants.DAY_CODES[5];
            }
            if (this.days.contains(1)) {
                dayCode += Constants.DAY_CODES[6];
            }
            return dayCode;
        }

        public Integer getStartPeriod() {
            return this.startPeriod;
        }

        public void setStartPeriod(Integer startPeriod) {
            this.startPeriod = startPeriod;
        }

        public Integer getEndPeriod() {
            return this.endPeriod;
        }

        public void setEndPeriod(Integer endPeriod) {
            this.endPeriod = endPeriod;
        }

        public Set<Integer> getDays() {
            return this.days;
        }

        public void setDays(Set<Integer> days) {
            this.days = days;
        }

        public Meeting asMeeting() {
            Meeting meeting = new Meeting();
            meeting.setClassCanOverride(true);
            meeting.setStartOffset(0);
            meeting.setStartPeriod(this.getStartPeriod());
            meeting.setStopOffset(0);
            meeting.setStopPeriod(this.getEndPeriod());
            meeting.setStatus(Meeting.Status.PENDING);
            return meeting;
        }

        public Integer str2Slot(String timeString) throws Exception {
            int slot = -1;
            try {
                Date date = CalendarUtils.getDate(timeString, EventRelatedImports.this.timeFormat);
                SimpleDateFormat df = new SimpleDateFormat("HHmm");
                int time = Integer.parseInt(df.format(date));
                int hour = time / 100;
                int min = time % 100;
                if (hour >= 24) {
                    throw new Exception("Invalid time '" + timeString + "' -- hour (" + hour + ") must be between 0 and 23.");
                }
                if (min >= 60) {
                    throw new Exception("Invalid time '" + timeString + "' -- minute (" + min + ") must be between 0 and 59.");
                }
                if (min % Constants.SLOT_LENGTH_MIN != 0) {
                    min -= min % Constants.SLOT_LENGTH_MIN;
                }
                slot = (hour * 60 + min - Constants.FIRST_SLOT_TIME_MIN) / Constants.SLOT_LENGTH_MIN;
            }
            catch (NumberFormatException ex) {
                throw new Exception("Invalid time '" + timeString + "' -- not a number.");
            }
            if (slot < 0) {
                throw new Exception("Invalid time '" + timeString + "', did not meet format: " + EventRelatedImports.this.timeFormat);
            }
            return slot;
        }

        public String getPatternName() {
            return this.patternName;
        }

        public void setPatternName(String patternName) {
            this.patternName = patternName;
        }
    }
}

