/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.dataexchange;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.TreeSet;
import org.cpsolver.coursett.model.TimeLocation;
import org.cpsolver.ifs.util.ToolBox;
import org.dom4j.Document;
import org.dom4j.Element;
import org.unitime.commons.hibernate.util.HibernateUtil;
import org.unitime.timetable.ApplicationProperties;
import org.unitime.timetable.dataexchange.BaseExport;
import org.unitime.timetable.defaults.ApplicationProperty;
import org.unitime.timetable.model.ArrangeCreditUnitConfig;
import org.unitime.timetable.model.Assignment;
import org.unitime.timetable.model.ClassEvent;
import org.unitime.timetable.model.ClassInstructor;
import org.unitime.timetable.model.Class_;
import org.unitime.timetable.model.ConstraintInfo;
import org.unitime.timetable.model.CourseCreditUnitConfig;
import org.unitime.timetable.model.CourseOffering;
import org.unitime.timetable.model.CurriculumClassification;
import org.unitime.timetable.model.DatePattern;
import org.unitime.timetable.model.DepartmentalInstructor;
import org.unitime.timetable.model.Event;
import org.unitime.timetable.model.Exam;
import org.unitime.timetable.model.ExamOwner;
import org.unitime.timetable.model.FixedCreditUnitConfig;
import org.unitime.timetable.model.InstrOfferingConfig;
import org.unitime.timetable.model.InstructionalOffering;
import org.unitime.timetable.model.Location;
import org.unitime.timetable.model.Meeting;
import org.unitime.timetable.model.PreferenceLevel;
import org.unitime.timetable.model.Room;
import org.unitime.timetable.model.RoomPref;
import org.unitime.timetable.model.SchedulingSubpart;
import org.unitime.timetable.model.Session;
import org.unitime.timetable.model.SolverParameterDef;
import org.unitime.timetable.model.SolverParameterGroup;
import org.unitime.timetable.model.StudentGroup;
import org.unitime.timetable.model.VariableFixedCreditUnitConfig;
import org.unitime.timetable.model.VariableRangeCreditUnitConfig;
import org.unitime.timetable.model.base.BaseSchedulingSubpart;
import org.unitime.timetable.model.comparators.SchedulingSubpartComparator;
import org.unitime.timetable.model.dao.CurriculumClassificationDAO;
import org.unitime.timetable.model.dao.StudentGroupDAO;
import org.unitime.timetable.solver.ui.StudentGroupInfo;
import org.unitime.timetable.util.Constants;
import org.unitime.timetable.util.DateUtils;
import org.unitime.timetable.util.Formats;

public class CourseOfferingExport
extends BaseExport {
    protected static Formats.Format<Number> sTwoNumbersDF = Formats.getNumberFormat("00");
    protected static Formats.Format<Number> sRoomRatioDF = Formats.getNumberFormat("0.00");
    protected static Formats.Format<Date> sDateFormat = Formats.getDateFormat("yyyy/M/d");
    protected static Formats.Format<Date> sTimeFormat = Formats.getDateFormat("HHmm");
    protected Hashtable<Long, TreeSet<Exam>> iExams = null;
    protected Map<Long, ClassEvent> iClassEvents = null;
    protected Map<Long, Location> iMeetingLocations = null;
    protected boolean iExportAssignments = true;
    protected boolean iExportGroupInfos = false;
    protected Integer iDefaultMaxNbrRooms = null;

    @Override
    public void saveXml(Document document, Session session, Properties parameters) throws Exception {
        try {
            this.beginTransaction();
            this.iExportGroupInfos = ApplicationProperty.DataExchangeIncludeStudentGroups.isTrue();
            this.iExportAssignments = "true".equals(parameters.getProperty("tmtbl.export.timetable", "true"));
            boolean examsOnly = "true".equals(parameters.getProperty("tmtbl.export.exam"));
            Element root = document.addElement(examsOnly ? "exams" : "offerings");
            root.addAttribute("campus", session.getAcademicInitiative());
            root.addAttribute("year", session.getAcademicYear());
            root.addAttribute("term", session.getAcademicTerm());
            root.addAttribute("dateFormat", sDateFormat.toPattern());
            root.addAttribute("timeFormat", sTimeFormat.toPattern());
            root.addAttribute("created", new Date().toString());
            if (examsOnly) {
                root.addAttribute("type", parameters.getProperty("tmtbl.export.exam.type", "all"));
            }
            root.addAttribute("includeExams", parameters.getProperty("tmtbl.export.exam.type", "all"));
            document.addDocType(examsOnly ? "exams" : "offerings", "-//UniTime//DTD University Course Timetabling/EN", "http://www.unitime.org/interface/CourseOfferingExport.dtd");
            SolverParameterDef maxRoomsParam = SolverParameterDef.findByNameType(this.getHibSession(), "Exams.MaxRooms", SolverParameterGroup.SolverType.EXAM);
            if (maxRoomsParam != null && maxRoomsParam.getDefault() != null) {
                this.iDefaultMaxNbrRooms = Integer.valueOf(maxRoomsParam.getDefault());
            }
            if (this.iExportAssignments && ApplicationProperty.DataExchangeIncludeMeetings.isTrue()) {
                this.iClassEvents = new HashMap<Long, ClassEvent>();
                for (ClassEvent e : this.getHibSession().createQuery("from ClassEvent e where e.clazz.schedulingSubpart.instrOfferingConfig.instructionalOffering.session.uniqueId = :sessionId", ClassEvent.class).setParameter("sessionId", (Object)session.getUniqueId()).list()) {
                    this.iClassEvents.put(e.getClazz().getUniqueId(), e);
                }
                this.iMeetingLocations = new HashMap<Long, Location>();
                for (Location l : this.getHibSession().createQuery("from Location l where l.session.uniqueId = :sessionId", Location.class).setParameter("sessionId", (Object)session.getUniqueId()).list()) {
                    this.iMeetingLocations.put(l.getPermanentId(), l);
                }
            }
            if (examsOnly) {
                if ("all".equals(parameters.getProperty("tmtbl.export.exam.type", "all")) || "final".equals(parameters.getProperty("tmtbl.export.exam.type", "all"))) {
                    for (Exam exam : new TreeSet<Exam>(Exam.findAllFinal(session.getUniqueId()))) {
                        this.exportExam(root, null, exam, session);
                    }
                }
                if ("all".equals(parameters.getProperty("tmtbl.export.exam.type", "all")) || "midterm".equals(parameters.getProperty("tmtbl.export.exam.type", "all"))) {
                    for (Exam exam : new TreeSet<Exam>(Exam.findAllMidterm(session.getUniqueId()))) {
                        this.exportExam(root, null, exam, session);
                    }
                }
            } else {
                this.info("Loading offerings...");
                String subjects = parameters.getProperty("tmtbl.export.subjects");
                List offerings = null;
                if (subjects == null || subjects.isEmpty()) {
                    offerings = this.getHibSession().createQuery("select distinct io from InstructionalOffering io inner join fetch io.courseOfferings as co inner join fetch co.subjectArea sa left join fetch io.instrOfferingConfigs as ioc left join fetch ioc.schedulingSubparts as ss left join fetch ss.classes as c where io.session.uniqueId=:sessionId order by sa.subjectAreaAbbreviation, co.courseNbr", InstructionalOffering.class).setParameter("sessionId", (Object)session.getUniqueId()).setFetchSize(1000).list();
                } else {
                    ArrayList<Long> subjectIds = new ArrayList<Long>();
                    for (String id : subjects.split(",")) {
                        subjectIds.add(Long.valueOf(id));
                    }
                    offerings = this.getHibSession().createQuery("select distinct io from InstructionalOffering io inner join fetch io.courseOfferings as co inner join fetch co.subjectArea sa left join fetch io.instrOfferingConfigs as ioc left join fetch ioc.schedulingSubparts as ss left join fetch ss.classes as c where io.session.uniqueId=:sessionId and io.uniqueId in (select x.instructionalOffering.uniqueId from CourseOffering x where x.isControl = true and x.subjectArea.uniqueId in (:subjects)) order by sa.subjectAreaAbbreviation, co.courseNbr", InstructionalOffering.class).setParameter("sessionId", (Object)session.getUniqueId()).setParameterList("subjects", subjectIds, Long.class).setFetchSize(1000).list();
                }
                if (!"none".equals(parameters.getProperty("tmtbl.export.exam.type", "all"))) {
                    this.info("Loading exams...");
                    List allExams = this.getHibSession().createQuery("select x from Exam x left join fetch x.owners o where x.session.uniqueId=:sessionId" + ("midterm".equals(parameters.getProperty("tmtbl.export.exam.type", "all")) ? " and x.examType.type=1" : "") + ("final".equals(parameters.getProperty("tmtbl.export.exam.type", "all")) ? " and x.examType.type=0" : ""), Exam.class).setParameter("sessionId", (Object)session.getUniqueId()).setFetchSize(1000).list();
                    this.iExams = new Hashtable();
                    this.info("Checking exams...");
                    for (Exam exam : allExams) {
                        for (ExamOwner owner : exam.getOwners()) {
                            Long offeringId = owner.getCourse().getInstructionalOffering().getUniqueId();
                            TreeSet<Exam> exams = this.iExams.get(offeringId);
                            if (exams == null) {
                                exams = new TreeSet();
                                this.iExams.put(offeringId, exams);
                            }
                            exams.add(exam);
                        }
                    }
                }
                this.info("Exporting " + offerings.size() + " offerings ...");
                for (InstructionalOffering io : offerings) {
                    this.exportInstructionalOffering(root, io, session);
                }
            }
            this.commitTransaction();
        }
        catch (Exception e) {
            this.fatal("Exception: " + e.getMessage(), e);
            this.rollbackTransaction();
        }
    }

    protected void exportInstructionalOffering(Element offeringsElement, InstructionalOffering offering, Session session) {
        TreeSet<Exam> exams;
        Element offeringElement = offeringsElement.addElement("offering");
        offeringElement.addAttribute("id", offering.getExternalUniqueId() != null ? offering.getExternalUniqueId() : offering.getUniqueId().toString());
        offeringElement.addAttribute("offered", offering.isNotOffered() != false ? "false" : "true");
        offeringElement.addAttribute("action", "insert");
        for (CourseOffering course : offering.getCourseOfferings()) {
            this.exportCourse(offeringElement.addElement("course"), course, session);
        }
        if (!offering.isNotOffered().booleanValue()) {
            for (InstrOfferingConfig config : offering.getInstrOfferingConfigs()) {
                this.exportConfig(offeringElement.addElement("config"), config, session);
            }
        }
        if (this.iExams != null && (exams = this.iExams.get(offering.getUniqueId())) != null) {
            for (Exam exam : exams) {
                this.exportExam(offeringElement, offering, exam, session);
            }
        }
    }

    protected void exportCredit(Element creditElement, CourseCreditUnitConfig credit, Session session) {
        if (credit.getCreditType() != null) {
            creditElement.addAttribute("creditType", credit.getCreditType().getReference());
        }
        if (credit.getCreditUnitType() != null) {
            creditElement.addAttribute("creditUnitType", credit.getCreditUnitType().getReference());
        }
        if (credit.getCreditFormat() != null) {
            creditElement.addAttribute("creditFormat", credit.getCreditFormat());
        }
        if (!(credit instanceof ArrangeCreditUnitConfig)) {
            if (credit instanceof FixedCreditUnitConfig) {
                FixedCreditUnitConfig fixedCredit = (FixedCreditUnitConfig)credit;
                creditElement.addAttribute("fixedCredit", fixedCredit.getFixedUnits().toString());
            } else if (credit instanceof VariableRangeCreditUnitConfig) {
                VariableRangeCreditUnitConfig variableCredit = (VariableRangeCreditUnitConfig)credit;
                creditElement.addAttribute("minimumCredit", variableCredit.getMinUnits().toString());
                creditElement.addAttribute("maximumCredit", variableCredit.getMaxUnits().toString());
                if (variableCredit.isFractionalIncrementsAllowed() != null) {
                    creditElement.addAttribute("fractionalCreditAllowed", variableCredit.isFractionalIncrementsAllowed() != false ? "true" : "false");
                }
            } else if (credit instanceof VariableFixedCreditUnitConfig) {
                VariableFixedCreditUnitConfig variableCredit = (VariableFixedCreditUnitConfig)credit;
                creditElement.addAttribute("minimumCredit", variableCredit.getMinUnits().toString());
                creditElement.addAttribute("maximumCredit", variableCredit.getMaxUnits().toString());
            }
        }
    }

    protected void exportCourse(Element courseElement, CourseOffering course, Session session) {
        courseElement.addAttribute("id", course.getExternalUniqueId() != null ? course.getExternalUniqueId() : course.getUniqueId().toString());
        courseElement.addAttribute("subject", course.getSubjectArea().getSubjectAreaAbbreviation());
        courseElement.addAttribute("courseNbr", course.getCourseNbr());
        if (course.getReservation() != null) {
            courseElement.addAttribute("reserved", course.getReservation().toString());
        }
        courseElement.addAttribute("controlling", course.isIsControl() != false ? "true" : "false");
        if (course.getConsentType() != null) {
            courseElement.addElement("consent").addAttribute("type", course.getConsentType().getReference());
        }
        if (course.getTitle() != null) {
            courseElement.addAttribute("title", course.getTitle());
        }
        if (ApplicationProperty.CoursesFundingDepartmentsEnabled.isTrue() && course.getFundingDept() != null) {
            courseElement.addAttribute("fundingDepartment", course.getFundingDept().getDeptCode());
        }
        if (course.getScheduleBookNote() != null) {
            courseElement.addAttribute("scheduleBookNote", course.getScheduleBookNote());
        }
        for (CourseCreditUnitConfig credit : course.getCreditConfigs()) {
            this.exportCredit(courseElement.addElement("courseCredit"), credit, session);
        }
    }

    protected void exportConfig(Element configElement, InstrOfferingConfig config, Session session) {
        configElement.addAttribute("name", config.getName());
        configElement.addAttribute("limit", config.isUnlimitedEnrollment() != false ? "inf" : config.getLimit().toString());
        if (config.getClassDurationType() != null) {
            configElement.addAttribute("durationType", config.getClassDurationType().getReference());
        }
        if (config.getInstructionalMethod() != null) {
            configElement.addAttribute("instructionalMethod", config.getInstructionalMethod().getReference());
        }
        for (SchedulingSubpart subpart : config.getSchedulingSubparts()) {
            if (subpart.getParentSubpart() != null) continue;
            this.exportSubpart(configElement.addElement("subpart"), subpart, session);
        }
        for (SchedulingSubpart subpart : config.getSchedulingSubparts()) {
            if (subpart.getParentSubpart() != null) continue;
            for (Class_ clazz : subpart.getClasses()) {
                this.exportClass(configElement.addElement("class"), clazz, session);
            }
        }
    }

    protected void exportSubpart(Element subpartElement, SchedulingSubpart subpart, Session session) {
        subpartElement.addAttribute("type", subpart.getItypeDesc().trim());
        subpartElement.addAttribute("suffix", subpart.getSchedulingSubpartSuffix());
        subpartElement.addAttribute("minPerWeek", subpart.getMinutesPerWk().toString());
        for (CourseCreditUnitConfig credit : subpart.getCreditConfigs()) {
            this.exportCredit(subpartElement.addElement("subpartCredit"), credit, session);
        }
        for (SchedulingSubpart childSubpart : subpart.getChildSubparts()) {
            this.exportSubpart(subpartElement.addElement("subpart"), childSubpart, session);
        }
    }

    protected void exportClass(Element classElement, Class_ clazz, Session session) {
        classElement.addAttribute("id", this.getExternalUniqueId(clazz));
        classElement.addAttribute("type", clazz.getItypeDesc().trim());
        classElement.addAttribute("suffix", this.getClassSuffix(clazz));
        if (clazz.getSchedulingSubpart().getInstrOfferingConfig().isUnlimitedEnrollment().booleanValue()) {
            classElement.addAttribute("limit", "inf");
        } else {
            classElement.addAttribute("limit", String.valueOf(clazz.getClassLimit()));
        }
        if (clazz.getSchedulePrintNote() != null) {
            classElement.addAttribute("scheduleNote", clazz.getSchedulePrintNote());
        }
        classElement.addAttribute("studentScheduling", clazz.isEnabledForStudentScheduling() != false ? "true" : "false");
        classElement.addAttribute("displayInScheduleBook", clazz.isEnabledForStudentScheduling() != false ? "true" : "false");
        classElement.addAttribute("cancelled", clazz.isCancelled() != false ? "true" : "false");
        if (clazz.getNbrRooms() != 1) {
            classElement.addAttribute("nbrRooms", clazz.getNbrRooms().toString());
        }
        if (clazz.getNbrRooms() > 1 && clazz.isRoomsSplitAttendance() != null) {
            classElement.addAttribute("splitAttendance", clazz.isRoomsSplitAttendance() != false ? "true" : "false");
        }
        if (clazz.getRoomRatio().floatValue() != 1.0f) {
            classElement.addAttribute("roomRatio", sRoomRatioDF.format(clazz.getRoomRatio()));
        }
        for (Class_ childClazz : clazz.getChildClasses()) {
            this.exportClass(classElement.addElement("class"), childClazz, session);
        }
        if (clazz.getManagingDept() != null && !clazz.getManagingDept().equals(clazz.getControllingDept())) {
            classElement.addAttribute("managingDept", clazz.getManagingDept().getDeptCode());
        }
        if (this.iExportAssignments) {
            if (clazz.getCommittedAssignment() != null) {
                this.exportAssignment(classElement, clazz.getCommittedAssignment(), session);
            } else if (clazz.getManagingDept().getSolverGroup() != null && clazz.getManagingDept().getSolverGroup().getCommittedSolution() != null) {
                this.exportArrHours(classElement, clazz, session);
            }
        }
        if (ApplicationProperty.CoursesFundingDepartmentsEnabled.isTrue() && clazz.getFundingDept() != null) {
            classElement.addAttribute("fundingDepartment", clazz.getManagingDept().getDeptCode());
        }
        if (clazz.isDisplayInstructor().booleanValue()) {
            for (ClassInstructor instructor : clazz.getClassInstructors()) {
                if (instructor.getInstructor().getExternalUniqueId() == null) continue;
                this.exportInstructor(classElement.addElement("instructor"), instructor, session);
            }
        }
    }

    protected void exportInstructor(Element instructorElement, ClassInstructor instructor, Session session) {
        this.exportInstructor(instructorElement, instructor.getInstructor(), session);
        if (instructor.getPercentShare() != null) {
            instructorElement.addAttribute("share", instructor.getPercentShare().toString());
        }
        instructorElement.addAttribute("lead", instructor.isLead() != false ? "true" : "false");
        if (instructor.getResponsibility() != null) {
            instructorElement.addAttribute("responsibility", instructor.getResponsibility().getReference());
        }
    }

    protected void exportInstructor(Element instructorElement, DepartmentalInstructor instructor, Session session) {
        if (instructor.getExternalUniqueId() != null) {
            instructorElement.addAttribute("id", instructor.getExternalUniqueId());
        }
        if (instructor.getFirstName() != null) {
            instructorElement.addAttribute("fname", instructor.getFirstName());
        }
        if (instructor.getMiddleName() != null) {
            instructorElement.addAttribute("mname", instructor.getMiddleName());
        }
        if (instructor.getLastName() != null) {
            instructorElement.addAttribute("lname", instructor.getLastName());
        }
        if (instructor.getAcademicTitle() != null) {
            instructorElement.addAttribute("title", instructor.getAcademicTitle());
        }
    }

    private static String dayCode2days(int dayCode) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < Constants.DAY_CODES.length; ++i) {
            if ((dayCode & Constants.DAY_CODES[i]) == 0) continue;
            sb.append(Constants.DAY_NAMES_SHORT[i]);
        }
        return sb.toString();
    }

    private static String startSlot2startTime(int startSlot) {
        int minHrs = startSlot * Constants.SLOT_LENGTH_MIN + Constants.FIRST_SLOT_TIME_MIN;
        return sTwoNumbersDF.format(minHrs / 60) + sTwoNumbersDF.format(minHrs % 60);
    }

    private static String timeLocation2endTime(TimeLocation time) {
        int minHrs = (time.getStartSlot() + time.getLength()) * Constants.SLOT_LENGTH_MIN + Constants.FIRST_SLOT_TIME_MIN - time.getBreakTime();
        return sTwoNumbersDF.format(minHrs / 60) + sTwoNumbersDF.format(minHrs % 60);
    }

    protected void exportAssignment(Element classElement, Assignment assignment, Session session) {
        this.exportDatePattern(classElement, assignment.getDatePattern(), session);
        this.exportTimeLocation(classElement, assignment, session);
        this.exportRooms(classElement, assignment, session);
        if (this.iClassEvents != null) {
            this.exportEvent(classElement, this.iClassEvents.get(assignment.getClassId()), session);
        }
        if (this.iExportGroupInfos) {
            this.exportGroupInfos(classElement, assignment, session);
        }
    }

    protected void exportTimeLocation(Element classElement, Assignment assignment, Session session) {
        TimeLocation time = assignment.getTimeLocation();
        if (time != null) {
            Element timeElement = classElement.addElement("time");
            timeElement.addAttribute("days", CourseOfferingExport.dayCode2days(time.getDayCode()));
            timeElement.addAttribute("startTime", CourseOfferingExport.startSlot2startTime(time.getStartSlot()));
            timeElement.addAttribute("endTime", CourseOfferingExport.timeLocation2endTime(time));
            DatePattern dp = assignment.getDatePattern();
            if (dp != null && (!dp.isDefault() || ApplicationProperty.DataExchangeIncludeDefaultDatePattern.isTrue())) {
                timeElement.addAttribute("datePattern", dp.getName());
            }
            if (assignment.getTimePattern() != null) {
                timeElement.addAttribute("timePattern", assignment.getTimePattern().getName());
            }
        }
    }

    protected void exportRooms(Element classElement, Assignment assignment, Session session) {
        for (Location location : assignment.getRooms()) {
            if (location instanceof Room) {
                Room room = (Room)location;
                Element roomElement = classElement.addElement("room");
                if (room.getExternalUniqueId() != null) {
                    roomElement.addAttribute("id", room.getExternalUniqueId());
                }
                roomElement.addAttribute("building", room.getBuildingAbbv());
                roomElement.addAttribute("roomNbr", room.getRoomNumber());
                continue;
            }
            Element roomElement = classElement.addElement("location");
            if (location.getExternalUniqueId() != null) {
                roomElement.addAttribute("id", location.getExternalUniqueId());
            }
            roomElement.addAttribute("name", location.getLabel());
        }
    }

    protected void exportArrHours(Element classElement, Class_ clazz, Session session) {
        this.exportDatePattern(classElement, clazz.effectiveDatePattern(), session);
        this.exportRequiredRooms(classElement, clazz, session);
    }

    protected void exportDatePattern(Element classElement, DatePattern dp, Session session) {
        if (dp != null && (!dp.equals(session.getDefaultDatePattern()) || ApplicationProperty.DataExchangeIncludeDefaultDatePattern.isTrue())) {
            Calendar startDate = Calendar.getInstance(Locale.US);
            startDate.setTime(dp.getStartDate());
            Calendar endDate = Calendar.getInstance(Locale.US);
            endDate.setTime(dp.getEndDate());
            int startMonth = startDate.get(2);
            int endMonth = endDate.get(2);
            int startYear = startDate.get(1);
            int endYear = endDate.get(1);
            if (endYear > startYear) {
                endMonth += 12 * (endYear - startYear);
            }
            String first = null;
            String previous = null;
            char[] ptrn = dp.getPattern().toCharArray();
            int charPosition = 0;
            int dayOfWeek = startDate.get(7);
            for (int m = startMonth; m <= endMonth; ++m) {
                int d;
                int daysOfMonth = DateUtils.getNrDaysOfMonth(m, startYear);
                int n = d = m == startMonth ? startDate.get(5) : 1;
                while (d <= daysOfMonth && charPosition < ptrn.length) {
                    if (ptrn[charPosition] == '1') {
                        if (first == null) {
                            first = (m < 0 ? startYear - 1 : (m >= 12 ? startYear + 1 : startYear)) + "/" + ((m < 0 ? 12 + m : m % 12) + 1) + "/" + d;
                        }
                    } else if (first != null) {
                        Element dateElement = classElement.addElement("date");
                        dateElement.addAttribute("startDate", first);
                        dateElement.addAttribute("endDate", previous);
                        first = null;
                    }
                    previous = (m < 0 ? startYear - 1 : (m >= 12 ? startYear + 1 : startYear)) + "/" + ((m < 0 ? 12 + m : m % 12) + 1) + "/" + d;
                    ++charPosition;
                    if (++dayOfWeek > 7) {
                        dayOfWeek = 1;
                    }
                    ++d;
                }
            }
            if (first != null) {
                Element dateElement = classElement.addElement("date");
                dateElement.addAttribute("startDate", first);
                dateElement.addAttribute("endDate", previous);
                first = null;
            }
        }
    }

    protected void exportRequiredRooms(Element classElement, Class_ clazz, Session session) {
        for (RoomPref rp : clazz.getEffectiveRoomPreferences()) {
            if (!PreferenceLevel.sRequired.equals(rp.getPrefLevel().getPrefProlog())) continue;
            if (rp.getRoom() instanceof Room) {
                Room room = (Room)rp.getRoom();
                Element roomElement = classElement.addElement("room");
                if (room.getExternalUniqueId() != null) {
                    roomElement.addAttribute("id", room.getExternalUniqueId());
                }
                roomElement.addAttribute("building", room.getBuildingAbbv());
                roomElement.addAttribute("roomNbr", room.getRoomNumber());
                continue;
            }
            Element roomElement = classElement.addElement("location");
            if (rp.getRoom().getExternalUniqueId() != null) {
                roomElement.addAttribute("id", rp.getRoom().getExternalUniqueId());
            }
            roomElement.addAttribute("name", rp.getRoom().getLabel());
        }
    }

    protected void exportExam(Element offeringElement, InstructionalOffering offering, Exam exam, Session session) {
        Element examElement = offeringElement.addElement("exam");
        examElement.addAttribute("id", exam.getUniqueId().toString());
        examElement.addAttribute("name", exam.getLabel());
        if (exam.getExamSize() != null) {
            examElement.addAttribute("size", String.valueOf(exam.getExamSize()));
        }
        examElement.addAttribute("enrollment", String.valueOf(exam.countStudents()));
        examElement.addAttribute("limit", String.valueOf(exam.getLimit()));
        examElement.addAttribute("length", String.valueOf(exam.getLength()));
        if (exam.getNote() != null) {
            examElement.addAttribute("note", exam.getNote());
        }
        examElement.addAttribute("seatingType", exam.getSeatingType() == 1 ? "exam" : "normal");
        examElement.addAttribute("type", exam.getExamType().getReference());
        if (exam.getPrintOffset() != null) {
            examElement.addAttribute("printOffset", String.valueOf(exam.getPrintOffset()));
        }
        if (exam.getNote() != null) {
            examElement.addAttribute("note", exam.getNote());
        }
        if (exam.getMaxNbrRooms() != null && !exam.getMaxNbrRooms().equals(this.iDefaultMaxNbrRooms)) {
            examElement.addAttribute("maxRooms", String.valueOf(exam.getMaxNbrRooms()));
        }
        HashMap<Long, Object> courseElements = new HashMap<Long, Object>();
        for (Object owner : exam.getOwnerObjects()) {
            Element courseElement;
            CourseOffering course;
            if (owner instanceof Class_) {
                Class_ clazz = (Class_)owner;
                course = clazz.getSchedulingSubpart().getControllingCourseOffering();
                courseElement = null;
                if (!(offering != null && course.getInstructionalOffering().equals(offering) || (courseElement = (Element)courseElements.get(course.getUniqueId())) != null)) {
                    courseElement = examElement.addElement("course");
                    courseElement.addAttribute("id", course.getExternalUniqueId() != null ? course.getExternalUniqueId() : course.getUniqueId().toString());
                    courseElement.addAttribute("subject", course.getSubjectAreaAbbv());
                    courseElement.addAttribute("courseNbr", course.getCourseNbr());
                    courseElements.put(course.getUniqueId(), courseElement);
                }
                Element classElement = (courseElement == null ? examElement : courseElement).addElement("class");
                classElement.addAttribute("id", this.getExternalUniqueId(clazz));
                classElement.addAttribute("type", clazz.getItypeDesc().trim());
                classElement.addAttribute("suffix", this.getClassSuffix(clazz));
                continue;
            }
            if (owner instanceof InstrOfferingConfig) {
                InstrOfferingConfig config = (InstrOfferingConfig)owner;
                course = config.getInstructionalOffering().getControllingCourseOffering();
                courseElement = null;
                if (!(offering != null && course.getInstructionalOffering().equals(offering) || (courseElement = (Element)courseElements.get(course.getUniqueId())) != null)) {
                    courseElement = examElement.addElement("course");
                    courseElement.addAttribute("id", course.getExternalUniqueId() != null ? course.getExternalUniqueId() : course.getUniqueId().toString());
                    courseElement.addAttribute("subject", course.getSubjectAreaAbbv());
                    courseElement.addAttribute("courseNbr", course.getCourseNbr());
                    courseElements.put(course.getUniqueId(), courseElement);
                }
                BaseSchedulingSubpart subpart = null;
                SchedulingSubpartComparator cmp = new SchedulingSubpartComparator();
                for (SchedulingSubpart s : config.getSchedulingSubparts()) {
                    if (subpart != null && cmp.compare(s, subpart) >= 0) continue;
                    subpart = s;
                }
                if (subpart == null) continue;
                for (Class_ clazz : subpart.getClasses()) {
                    Element classElement = (courseElement == null ? examElement : courseElement).addElement("class");
                    classElement.addAttribute("id", this.getExternalUniqueId(clazz));
                    classElement.addAttribute("type", clazz.getItypeDesc().trim());
                    classElement.addAttribute("suffix", this.getClassSuffix(clazz));
                }
                continue;
            }
            if (owner instanceof CourseOffering) {
                CourseOffering course2 = (CourseOffering)owner;
                if (offering != null && course2.getInstructionalOffering().equals(offering) && course2.getInstructionalOffering().getCourseOfferings().size() <= 1) continue;
                Element courseElement2 = examElement.addElement("course");
                courseElement2.addAttribute("id", course2.getExternalUniqueId() != null ? course2.getExternalUniqueId() : course2.getUniqueId().toString());
                courseElement2.addAttribute("subject", course2.getSubjectAreaAbbv());
                courseElement2.addAttribute("courseNbr", course2.getCourseNbr());
                courseElements.put(course2.getUniqueId(), courseElement2);
                continue;
            }
            if (!(owner instanceof InstructionalOffering)) continue;
            InstructionalOffering o = (InstructionalOffering)owner;
            if (offering != null && o.equals(offering)) continue;
            for (CourseOffering course3 : o.getCourseOfferings()) {
                Element courseElement3 = examElement.addElement("course");
                courseElement3.addAttribute("id", course3.getExternalUniqueId() != null ? course3.getExternalUniqueId() : course3.getUniqueId().toString());
                courseElement3.addAttribute("subject", course3.getSubjectAreaAbbv());
                courseElement3.addAttribute("courseNbr", course3.getCourseNbr());
                courseElements.put(course3.getUniqueId(), courseElement3);
            }
        }
        for (DepartmentalInstructor instructor : exam.getInstructors()) {
            if (instructor.getExternalUniqueId() == null) continue;
            this.exportInstructor(examElement.addElement("instructor"), instructor, session);
        }
        if (exam.getAssignedPeriod() != null) {
            Element periodElement = examElement.addElement("period");
            periodElement.addAttribute("date", sDateFormat.format(exam.getAssignedPeriod().getStartDate()));
            periodElement.addAttribute("startTime", sTimeFormat.format(exam.getStartTime(exam.getAssignedPeriod())));
            periodElement.addAttribute("endTime", sTimeFormat.format(exam.getEndTime(exam.getAssignedPeriod())));
            for (Location location : exam.getAssignedRooms()) {
                if (location instanceof Room) {
                    Room room = (Room)location;
                    Element roomElement = examElement.addElement("room");
                    if (room.getExternalUniqueId() != null) {
                        roomElement.addAttribute("id", room.getExternalUniqueId());
                    }
                    roomElement.addAttribute("building", room.getBuildingAbbv());
                    roomElement.addAttribute("roomNbr", room.getRoomNumber());
                    continue;
                }
                Element roomElement = examElement.addElement("location");
                if (location.getExternalUniqueId() != null) {
                    roomElement.addAttribute("id", location.getExternalUniqueId());
                }
                roomElement.addAttribute("name", location.getLabel());
            }
        }
    }

    protected void exportEvent(Element classElement, Event event, Session session) {
        if (event == null) {
            return;
        }
        ArrayList<Meeting> meetings = new ArrayList<Meeting>(event.getMeetings());
        Collections.sort(meetings, new Comparator<Meeting>(){

            @Override
            public int compare(Meeting m1, Meeting m2) {
                Location l2;
                if (m1.equals(m2)) {
                    return 0;
                }
                int cmp = m1.getMeetingDate().compareTo(m2.getMeetingDate());
                if (cmp != 0) {
                    return cmp;
                }
                cmp = m1.getStartPeriod().compareTo(m2.getStartPeriod());
                if (cmp != 0) {
                    return cmp;
                }
                Location l1 = m1.getLocationPermanentId() == null ? null : CourseOfferingExport.this.iMeetingLocations.get(m1.getLocationPermanentId());
                cmp = (l1 == null ? "" : l1.getLabel()).compareTo((l2 = m2.getLocationPermanentId() == null ? null : CourseOfferingExport.this.iMeetingLocations.get(m2.getLocationPermanentId())) == null ? "" : l2.getLabel());
                if (cmp != 0) {
                    return cmp;
                }
                return m1.getUniqueId().compareTo(m2.getUniqueId());
            }
        });
        for (Meeting meeting : meetings) {
            Location location;
            if (meeting.getStatus() != Meeting.Status.APPROVED) continue;
            Element meetingElement = classElement.addElement("meeting");
            meetingElement.addAttribute("startDate", sDateFormat.format(meeting.getMeetingDate()));
            meetingElement.addAttribute("endDate", sDateFormat.format(meeting.getMeetingDate()));
            meetingElement.addAttribute("startTime", sTimeFormat.format(meeting.getStartTime()));
            meetingElement.addAttribute("endTime", sTimeFormat.format(meeting.getStopTime()));
            Calendar c = Calendar.getInstance(Locale.US);
            c.setTime(meeting.getMeetingDate());
            switch (c.get(7)) {
                case 2: {
                    meetingElement.addAttribute("days", "M");
                    break;
                }
                case 3: {
                    meetingElement.addAttribute("days", "T");
                    break;
                }
                case 4: {
                    meetingElement.addAttribute("days", "W");
                    break;
                }
                case 5: {
                    meetingElement.addAttribute("days", "R");
                    break;
                }
                case 6: {
                    meetingElement.addAttribute("days", "F");
                    break;
                }
                case 7: {
                    meetingElement.addAttribute("days", "S");
                    break;
                }
                case 1: {
                    meetingElement.addAttribute("days", "U");
                }
            }
            if ((location = meeting.getLocationPermanentId() == null ? null : this.iMeetingLocations.get(meeting.getLocationPermanentId())) == null) continue;
            if (location instanceof Room) {
                meetingElement.addAttribute("building", ((Room)location).getBuildingAbbv());
                meetingElement.addAttribute("room", ((Room)location).getRoomNumber());
                continue;
            }
            meetingElement.addAttribute("location", location.getLabel());
        }
    }

    protected void exportGroupInfos(Element classElement, Assignment assignment, Session session) {
        for (ConstraintInfo ci : assignment.getConstraintInfo()) {
            if (!"GroupInfo".equals(ci.getDefinition().getName())) continue;
            StudentGroupInfo info = (StudentGroupInfo)ci.getInfo();
            Element element = classElement.addElement("group-info");
            if (info.getGroupId() < 0L) {
                CurriculumClassification cc = (CurriculumClassification)CurriculumClassificationDAO.getInstance().get(-info.getGroupId().longValue(), this.getHibSession());
                if (cc != null) {
                    element.addAttribute("curriculum", cc.getCurriculum().getAbbv());
                    element.addAttribute("classification", cc.getName() == null ? cc.getAcademicClassification().getCode() : cc.getName());
                }
            } else {
                StudentGroup group = (StudentGroup)StudentGroupDAO.getInstance().get(info.getGroupId(), this.getHibSession());
                if (group != null) {
                    element.addAttribute("group", group.getGroupAbbreviation());
                }
            }
            element.addAttribute("name", info.getGroupName());
            List<StudentGroupInfo.StudentInfo> students = info.getStudentAssignments(assignment.getClassId());
            if (students == null) continue;
            element.addAttribute("students", String.valueOf(students.size()));
        }
    }

    public static void main(String[] args) {
        try {
            if (args.length == 0) {
                args = new String[]{"c:\\test\\courseOfferings.xml", "puWestLafayetteTrdtn", "2007", "Fal"};
            }
            ToolBox.configureLogging();
            HibernateUtil.configureHibernate(ApplicationProperties.getProperties());
            Session session = Session.getSessionUsingInitiativeYearTerm(args[1], args[2], args[3]);
            if (session == null) {
                throw new Exception("Session " + args[1] + " " + args[2] + args[3] + " not found!");
            }
            new CourseOfferingExport().saveXml(args[0], session, ApplicationProperties.getProperties());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

