/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.action;

import jakarta.servlet.http.HttpServletRequest;
import java.net.URLEncoder;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import org.apache.struts2.convention.annotation.Action;
import org.apache.struts2.convention.annotation.Result;
import org.unitime.timetable.action.UniTimeAction;
import org.unitime.timetable.defaults.ApplicationProperty;
import org.unitime.timetable.defaults.UserProperty;
import org.unitime.timetable.form.BlankForm;
import org.unitime.timetable.gwt.services.SectioningService;
import org.unitime.timetable.gwt.shared.AcademicSessionProvider;
import org.unitime.timetable.gwt.shared.SectioningException;
import org.unitime.timetable.model.Session;
import org.unitime.timetable.model.Student;
import org.unitime.timetable.model.StudentSectioningStatus;
import org.unitime.timetable.model.dao.CourseOfferingDAO;
import org.unitime.timetable.model.dao.SessionDAO;
import org.unitime.timetable.model.dao.StudentDAO;
import org.unitime.timetable.security.Qualifiable;
import org.unitime.timetable.security.UserAuthority;
import org.unitime.timetable.security.UserQualifier;
import org.unitime.timetable.security.context.UniTimeUserContext;
import org.unitime.timetable.security.qualifiers.SimpleQualifier;
import org.unitime.timetable.security.rights.Right;
import org.unitime.timetable.spring.SpringApplicationContextHolder;

@Action(value="studentScheduling", results={@Result(name={"main"}, type="redirect", location="/main.action")})
public class StudentSchedulingAction
extends UniTimeAction<BlankForm> {
    private static final long serialVersionUID = -287721682089077684L;
    private String campus;
    private String term;
    private String session;
    private String prefer;

    public String getCampus() {
        return this.campus;
    }

    public void setCampus(String campus) {
        this.campus = campus;
    }

    public String getTerm() {
        return this.term;
    }

    public void setTerm(String term) {
        this.term = term;
    }

    public String getSession() {
        return this.session;
    }

    public void setSession(String session) {
        this.session = session;
    }

    public String getPrefer() {
        return this.prefer;
    }

    public void setPrefer(String prefer) {
        this.prefer = prefer;
    }

    protected boolean matchCampus(AcademicSessionProvider.AcademicSessionInfo info, String campus) {
        if (info.hasExternalCampus() && campus.equalsIgnoreCase(info.getExternalCampus())) {
            return true;
        }
        return campus.equalsIgnoreCase(info.getCampus());
    }

    protected boolean matchTerm(AcademicSessionProvider.AcademicSessionInfo info, String term) {
        if (info.hasExternalTerm() && term.equalsIgnoreCase(info.getExternalTerm())) {
            return true;
        }
        return term.equalsIgnoreCase(info.getTerm() + info.getYear()) || term.equalsIgnoreCase(info.getYear() + info.getTerm()) || term.equalsIgnoreCase(info.getTerm() + info.getYear() + info.getCampus());
    }

    protected boolean matchSession(AcademicSessionProvider.AcademicSessionInfo info, String session) {
        if (info.hasExternalTerm() && info.hasExternalCampus() && session.equalsIgnoreCase(info.getExternalTerm() + info.hasExternalCampus())) {
            return true;
        }
        return session.equalsIgnoreCase(info.getTerm() + info.getYear() + info.getCampus()) || session.equalsIgnoreCase(info.getTerm() + info.getYear()) || session.equals(info.getSessionId().toString());
    }

    public boolean match(HttpServletRequest request, AcademicSessionProvider.AcademicSessionInfo info, boolean useDefault) {
        if (this.campus != null && !this.matchCampus(info, this.campus)) {
            return false;
        }
        if (this.term != null && !this.matchTerm(info, this.term)) {
            return false;
        }
        if (this.session != null && !this.matchSession(info, this.session)) {
            return false;
        }
        if (useDefault && this.campus == null && this.term == null && this.session == null) {
            return info.getSessionId().equals(this.sessionContext.getUser().getCurrentAcademicSessionId());
        }
        return true;
    }

    public String execute() throws Exception {
        List<? extends UserQualifier> q;
        String target = null;
        for (Map.Entry entry : this.request.getParameterMap().entrySet()) {
            for (String value : (String[])entry.getValue()) {
                if ("prefer".equals(entry.getKey())) continue;
                target = target == null ? (String)entry.getKey() + "=" + URLEncoder.encode(value, "UTF-8") : target + "&" + (String)entry.getKey() + "=" + URLEncoder.encode(value, "UTF-8");
            }
        }
        boolean useDefault = ApplicationProperty.StudentSchedulingUseDefaultSession.isTrue();
        if (this.sessionContext.isAuthenticated() && "Instructor".equals(this.sessionContext.getUser().getCurrentAuthority().getRole())) {
            Iterator<? extends UserAuthority> iterator = this.sessionContext.getUser().getAuthorities("Student", new SimpleQualifier("Session", this.sessionContext.getUser().getCurrentAcademicSessionId())).iterator();
            if (iterator.hasNext()) {
                UserAuthority auth = iterator.next();
                this.sessionContext.getUser().setCurrentAuthority(auth);
            }
            if ("Instructor".equals(this.sessionContext.getUser().getCurrentAuthority().getRole())) {
                Iterator<? extends UserAuthority> iterator2;
                Session session;
                TreeSet<Session> treeSet = new TreeSet<Session>();
                UserAuthority firstStudentAuth = null;
                for (UserAuthority userAuthority : this.sessionContext.getUser().getAuthorities("Student", new Qualifiable[0])) {
                    Session session2 = (Session)SessionDAO.getInstance().get((Long)userAuthority.getAcademicSession().getQualifierId());
                    if (session2 != null) {
                        treeSet.add(session2);
                    }
                    if (firstStudentAuth != null) continue;
                    firstStudentAuth = userAuthority;
                }
                if (!treeSet.isEmpty() && (session = UniTimeUserContext.defaultSession(treeSet, firstStudentAuth, UserProperty.PrimaryCampus.get(this.sessionContext.getUser()))) != null && (iterator2 = this.sessionContext.getUser().getAuthorities("Student", new SimpleQualifier("Session", session.getUniqueId())).iterator()).hasNext()) {
                    UserAuthority auth3 = iterator2.next();
                    this.sessionContext.getUser().setCurrentAuthority(auth3);
                }
            }
        }
        SectioningService sectioningService = (SectioningService)SpringApplicationContextHolder.getBean("sectioning.gwt");
        if (this.sessionContext.isAuthenticated()) {
            UserAuthority preferredAuthority = null;
            try {
                for (AcademicSessionProvider.AcademicSessionInfo academicSessionInfo : sectioningService.listAcademicSessions(true)) {
                    if (!this.match(this.request, academicSessionInfo, useDefault)) continue;
                    for (UserAuthority userAuthority : this.sessionContext.getUser().getAuthorities(null, new SimpleQualifier("Session", academicSessionInfo.getSessionId()))) {
                        if (preferredAuthority == null && "Student".equals(userAuthority.getRole())) {
                            preferredAuthority = userAuthority;
                            continue;
                        }
                        if ((preferredAuthority == null || !preferredAuthority.hasRight(Right.StudentSchedulingAdmin)) && userAuthority.hasRight(Right.StudentSchedulingAdvisor)) {
                            preferredAuthority = userAuthority;
                            continue;
                        }
                        if (!userAuthority.hasRight(Right.StudentSchedulingAdmin)) continue;
                        preferredAuthority = userAuthority;
                    }
                }
                if (preferredAuthority == null) {
                    for (AcademicSessionProvider.AcademicSessionInfo academicSessionInfo : sectioningService.listAcademicSessions(false)) {
                        if (!this.match(this.request, academicSessionInfo, useDefault)) continue;
                        for (UserAuthority userAuthority : this.sessionContext.getUser().getAuthorities(null, new SimpleQualifier("Session", academicSessionInfo.getSessionId()))) {
                            if (preferredAuthority == null && "Student".equals(userAuthority.getRole())) {
                                preferredAuthority = userAuthority;
                                continue;
                            }
                            if ((preferredAuthority == null || !preferredAuthority.hasRight(Right.StudentSchedulingAdmin)) && userAuthority.hasRight(Right.StudentSchedulingAdvisor)) {
                                preferredAuthority = userAuthority;
                                continue;
                            }
                            if (!userAuthority.hasRight(Right.StudentSchedulingAdmin)) continue;
                            preferredAuthority = userAuthority;
                        }
                    }
                }
            }
            catch (SectioningException session) {
                // empty catch block
            }
            if (preferredAuthority == null && this.sessionContext.getUser().getCurrentAuthority() != null) {
                for (UserAuthority userAuthority : this.sessionContext.getUser().getAuthorities(null, this.sessionContext.getUser().getCurrentAuthority().getAcademicSession())) {
                    if (preferredAuthority == null && "Student".equals(userAuthority.getRole())) {
                        preferredAuthority = userAuthority;
                        continue;
                    }
                    if ((preferredAuthority == null || !preferredAuthority.hasRight(Right.StudentSchedulingAdmin)) && userAuthority.hasRight(Right.StudentSchedulingAdvisor)) {
                        preferredAuthority = userAuthority;
                        continue;
                    }
                    if (!userAuthority.hasRight(Right.StudentSchedulingAdmin)) continue;
                    preferredAuthority = userAuthority;
                }
            }
            if (preferredAuthority != null) {
                this.sessionContext.getUser().setCurrentAuthority(preferredAuthority);
            }
        }
        if (this.sessionContext.hasPermission(Right.SchedulingDashboard)) {
            if (!this.sessionContext.hasPermission(Right.StudentSchedulingAdmin)) {
                Number myStudents = (Number)CourseOfferingDAO.getInstance().getSession().createQuery("select count(s) from Advisor a inner join a.students s where a.externalUniqueId = :user and a.role.reference = :role and a.session.uniqueId = :sessionId", Number.class).setParameter("sessionId", (Object)this.sessionContext.getUser().getCurrentAcademicSessionId()).setParameter("user", (Object)this.sessionContext.getUser().getExternalUserId()).setParameter("role", (Object)this.sessionContext.getUser().getCurrentAuthority().getRole()).setCacheable(true).uniqueResult();
                this.response.sendRedirect("onlinesctdash" + (String)(target == null ? "" : "?" + target) + (myStudents.intValue() > 0 ? "#mode:%22My%20Students%22@" : ""));
            } else {
                this.response.sendRedirect("onlinesctdash" + (String)(target == null ? "" : "?" + target));
            }
            return null;
        }
        if ("Student".equals(this.sessionContext.getUser().getCurrentAuthority().getRole()) && (q = this.sessionContext.getUser().getCurrentAuthority().getQualifiers("Student")) != null && !q.isEmpty()) {
            boolean bl;
            UserQualifier studentQualifier = q.get(0);
            boolean bl2 = ApplicationProperty.StudentSchedulingPreferCourseRequests.isTrue();
            if (this.prefer != null) {
                boolean bl3 = bl = "cr".equalsIgnoreCase(this.prefer) || "crf".equalsIgnoreCase(this.prefer);
            }
            if (bl) {
                try {
                    for (AcademicSessionProvider.AcademicSessionInfo academicSessionInfo : sectioningService.listAcademicSessions(false)) {
                        if (!this.match(this.request, academicSessionInfo, useDefault)) continue;
                        student = Student.findByExternalId(academicSessionInfo.getSessionId(), studentQualifier.getQualifierReference());
                        if (student == null) {
                            student = (Student)StudentDAO.getInstance().get((Long)studentQualifier.getQualifierId());
                        }
                        if (student == null || (status = student.getEffectiveStatus()) == null || !status.hasOption(StudentSectioningStatus.Option.regenabled)) continue;
                        this.response.sendRedirect("requests" + (String)(target == null ? "" : "?" + target));
                        return null;
                    }
                }
                catch (SectioningException sectioningException) {
                    // empty catch block
                }
                try {
                    for (AcademicSessionProvider.AcademicSessionInfo academicSessionInfo : sectioningService.listAcademicSessions(true)) {
                        if (!this.match(this.request, academicSessionInfo, useDefault) || (server = this.getSolverServerService().getOnlineStudentSchedulingContainer().getSolver(academicSessionInfo.getSessionId().toString())) == null || !server.getAcademicSession().isSectioningEnabled()) continue;
                        student = Student.findByExternalId(academicSessionInfo.getSessionId(), studentQualifier.getQualifierReference());
                        if (student == null) {
                            student = (Student)StudentDAO.getInstance().get((Long)studentQualifier.getQualifierId());
                        }
                        if (student == null || (status = student.getEffectiveStatus()) != null && !status.hasOption(StudentSectioningStatus.Option.enrollment)) continue;
                        this.response.sendRedirect("sectioning" + (String)(target == null ? "" : "?" + target));
                        return null;
                    }
                }
                catch (SectioningException sectioningException) {}
            } else {
                try {
                    for (AcademicSessionProvider.AcademicSessionInfo academicSessionInfo : sectioningService.listAcademicSessions(true)) {
                        if (!this.match(this.request, academicSessionInfo, useDefault) || (server = this.getSolverServerService().getOnlineStudentSchedulingContainer().getSolver(academicSessionInfo.getSessionId().toString())) == null || !server.getAcademicSession().isSectioningEnabled()) continue;
                        student = Student.findByExternalId(academicSessionInfo.getSessionId(), studentQualifier.getQualifierReference());
                        if (student == null) {
                            student = (Student)StudentDAO.getInstance().get((Long)studentQualifier.getQualifierId());
                        }
                        if (student == null || (status = student.getEffectiveStatus()) != null && !status.hasOption(StudentSectioningStatus.Option.enrollment)) continue;
                        this.response.sendRedirect("sectioning" + (String)(target == null ? "" : "?" + target));
                        return null;
                    }
                }
                catch (SectioningException sectioningException) {
                    // empty catch block
                }
                try {
                    for (AcademicSessionProvider.AcademicSessionInfo academicSessionInfo : sectioningService.listAcademicSessions(false)) {
                        if (!this.match(this.request, academicSessionInfo, useDefault)) continue;
                        student = Student.findByExternalId(academicSessionInfo.getSessionId(), studentQualifier.getQualifierReference());
                        if (student == null) {
                            student = (Student)StudentDAO.getInstance().get((Long)studentQualifier.getQualifierId());
                        }
                        if (student == null || (status = student.getEffectiveStatus()) == null || !status.hasOption(StudentSectioningStatus.Option.regenabled)) continue;
                        this.response.sendRedirect("requests" + (String)(target == null ? "" : "?" + target));
                        return null;
                    }
                }
                catch (SectioningException sectioningException) {
                    // empty catch block
                }
            }
        }
        try {
            for (AcademicSessionProvider.AcademicSessionInfo session : sectioningService.listAcademicSessions(true)) {
                if (!this.match(this.request, session, useDefault)) continue;
                this.response.sendRedirect("sectioning" + (String)(target == null ? "" : "?" + target));
                return null;
            }
        }
        catch (SectioningException sectioningException) {
            // empty catch block
        }
        try {
            for (AcademicSessionProvider.AcademicSessionInfo session : sectioningService.listAcademicSessions(false)) {
                if (!this.match(this.request, session, useDefault)) continue;
                this.response.sendRedirect("requests" + (String)(target == null ? "" : "?" + target));
                return null;
            }
        }
        catch (SectioningException sectioningException) {
            // empty catch block
        }
        return "main";
    }
}

