/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.action;

import jakarta.servlet.http.HttpServletRequest;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.Hashtable;
import java.util.Locale;
import java.util.StringTokenizer;
import java.util.TreeSet;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.apache.struts2.convention.annotation.Action;
import org.apache.struts2.convention.annotation.Result;
import org.apache.struts2.tiles.annotation.TilesDefinition;
import org.apache.struts2.tiles.annotation.TilesPutAttribute;
import org.unitime.commons.Debug;
import org.unitime.commons.MultiComparable;
import org.unitime.commons.web.WebTable;
import org.unitime.localization.impl.Localization;
import org.unitime.localization.messages.ExaminationMessages;
import org.unitime.timetable.action.UniTimeAction;
import org.unitime.timetable.form.RoomAvailabilityForm;
import org.unitime.timetable.gwt.resources.GwtConstants;
import org.unitime.timetable.interfaces.RoomAvailabilityInterface;
import org.unitime.timetable.model.DepartmentStatusType;
import org.unitime.timetable.model.Exam;
import org.unitime.timetable.model.ExamPeriod;
import org.unitime.timetable.model.ExamType;
import org.unitime.timetable.model.Location;
import org.unitime.timetable.model.Session;
import org.unitime.timetable.model.dao.ExamDAO;
import org.unitime.timetable.model.dao.ExamTypeDAO;
import org.unitime.timetable.model.dao.SessionDAO;
import org.unitime.timetable.security.rights.Right;
import org.unitime.timetable.solver.WebSolver;
import org.unitime.timetable.solver.exam.ExamSolverProxy;
import org.unitime.timetable.solver.exam.ui.ExamAssignment;
import org.unitime.timetable.util.Constants;
import org.unitime.timetable.util.ExportUtils;
import org.unitime.timetable.util.Formats;
import org.unitime.timetable.util.LookupTables;
import org.unitime.timetable.util.RoomAvailability;
import org.unitime.timetable.webutil.PdfWebTable;

@Action(value="roomAvailability", results={@Result(name={"showReport"}, type="tiles", location="roomAvailability.tiles")})
@TilesDefinition(name="roomAvailability.tiles", extend="baseLayout", putAttributes={@TilesPutAttribute(name="title", value="Room Availability"), @TilesPutAttribute(name="body", value="/exam/roomAvailability.jsp")})
public class RoomAvailabilityAction
extends UniTimeAction<RoomAvailabilityForm> {
    private static final long serialVersionUID = 3901909271352342751L;
    protected static final ExaminationMessages MSG = Localization.create(ExaminationMessages.class);
    protected static final GwtConstants GWT_CONST = Localization.create(GwtConstants.class);

    public String execute() throws Exception {
        this.sessionContext.checkPermission(Right.RoomAvailability);
        ExamSolverProxy solver = this.getExaminationSolverService().getSolver();
        if (this.form == null) {
            this.form = new RoomAvailabilityForm();
            ((RoomAvailabilityForm)this.form).reset();
            if (solver != null) {
                ((RoomAvailabilityForm)this.form).setExamType(solver.getExamTypeId());
            }
        }
        if (((RoomAvailabilityForm)this.form).getOp() != null) {
            this.op = ((RoomAvailabilityForm)this.form).getOp();
        }
        if (MSG.actionExportPdf().equals(this.op) || MSG.actionExportCsv().equals(this.op) || MSG.buttonApply().equals(this.op)) {
            ((RoomAvailabilityForm)this.form).save(this.sessionContext);
        } else if (MSG.buttonRefresh().equals(this.op)) {
            ((RoomAvailabilityForm)this.form).reset();
            if (solver != null) {
                ((RoomAvailabilityForm)this.form).setExamType(solver.getExamTypeId());
            }
        }
        ((RoomAvailabilityForm)this.form).load(this.sessionContext);
        Session session = (Session)SessionDAO.getInstance().get(this.sessionContext.getUser().getCurrentAcademicSessionId());
        if (((RoomAvailabilityForm)this.form).getExamType() != null && ((RoomAvailabilityForm)this.form).getExamType() >= 0L) {
            PdfWebTable table;
            String exclude;
            Date[] bounds = ExamPeriod.getBounds(session, ((RoomAvailabilityForm)this.form).getExamType());
            String string = ((RoomAvailabilityForm)this.form).getIncludeExams() ? null : (exclude = ((ExamType)ExamTypeDAO.getInstance().get(((RoomAvailabilityForm)this.form).getExamType())).getType() == 0 ? RoomAvailabilityInterface.sFinalExamType : RoomAvailabilityInterface.sMidtermExamType);
            if (bounds != null && RoomAvailability.getInstance() != null) {
                RoomAvailability.getInstance().activate(session.getUniqueId(), bounds[0], bounds[1], exclude, "Refresh".equals(this.op));
            }
            WebTable.setOrder(this.sessionContext, ((RoomAvailabilityForm)this.form).getCompare() ? "roomAvailability.cord" : "roomAvailability.ord", this.request.getParameter("ord"), 1);
            PdfWebTable pdfWebTable = table = ((RoomAvailabilityForm)this.form).getCompare() ? this.getCompareTable(this.request, session.getUniqueId(), true, true) : this.getTable(this.request, session.getUniqueId(), true, true);
            if (MSG.actionExportPdf().equals(this.op) && table != null) {
                ExportUtils.exportPDF(((RoomAvailabilityForm)this.form).getCompare() ? this.getCompareTable(this.request, session.getUniqueId(), false, true) : this.getTable(this.request, session.getUniqueId(), false, true), WebTable.getOrder(this.sessionContext, ((RoomAvailabilityForm)this.form).getCompare() ? "roomAvailability.cord" : "roomAvailability.ord"), this.response, "roomavail");
                return null;
            }
            if (MSG.actionExportCsv().equals(this.op) && table != null) {
                ExportUtils.exportCSV(((RoomAvailabilityForm)this.form).getCompare() ? this.getCompareTable(this.request, session.getUniqueId(), false, false) : this.getTable(this.request, session.getUniqueId(), false, false), WebTable.getOrder(this.sessionContext, ((RoomAvailabilityForm)this.form).getCompare() ? "roomAvailability.cord" : "roomAvailability.ord"), this.response, "roomavail");
                return null;
            }
            if (table != null) {
                ((RoomAvailabilityForm)this.form).setTable(table.printTable(WebTable.getOrder(this.sessionContext, ((RoomAvailabilityForm)this.form).getCompare() ? "roomAvailability.cord" : "roomAvailability.ord")), 6, table.getLines().size());
            }
            RoomAvailability.setAvailabilityWarning(this.request, session, ((RoomAvailabilityForm)this.form).getExamType(), false, true);
        }
        if (this.request.getParameter("backId") != null) {
            this.request.setAttribute("hash", (Object)this.request.getParameter("backId"));
        }
        LookupTables.setupExamTypes(this.request, this.sessionContext.getUser(), DepartmentStatusType.Status.ExamView, DepartmentStatusType.Status.ExamTimetable);
        return "showReport";
    }

    public boolean match(String name) {
        if (((RoomAvailabilityForm)this.form).getFilter() == null || ((RoomAvailabilityForm)this.form).getFilter().trim().length() == 0) {
            return true;
        }
        String n = name.toUpperCase();
        StringTokenizer stk1 = new StringTokenizer(((RoomAvailabilityForm)this.form).getFilter().toUpperCase(), ";");
        while (stk1.hasMoreTokens()) {
            StringTokenizer stk2 = new StringTokenizer(stk1.nextToken(), " ,");
            boolean match = true;
            while (match && stk2.hasMoreTokens()) {
                String token = stk2.nextToken().trim();
                if (token.length() == 0) continue;
                if (token.indexOf(42) >= 0 || token.indexOf(63) >= 0) {
                    try {
                        String tokenRegExp = "\\s+" + token.replaceAll("\\.", "\\.").replaceAll("\\?", ".+").replaceAll("\\*", ".*") + "\\s";
                        if (Pattern.compile(tokenRegExp).matcher(" " + n + " ").find()) continue;
                        match = false;
                    }
                    catch (PatternSyntaxException e) {
                        match = false;
                    }
                    continue;
                }
                if (n.indexOf(token) >= 0) continue;
                match = false;
            }
            if (!match) continue;
            return true;
        }
        return false;
    }

    public PdfWebTable getTable(HttpServletRequest request, Long sessionId, boolean html, boolean color) {
        RoomAvailabilityInterface ra = RoomAvailability.getInstance();
        if (ra == null) {
            return null;
        }
        String nl = html ? "<br>" : "\n";
        PdfWebTable table = new PdfWebTable(8, MSG.sectRoomAvailability(), "roomAvailability.action?ord=%%", new String[]{MSG.colRoom(), MSG.colRoomCapacity(), MSG.colExaminationCapacity().replace("\n", nl), MSG.colEvent(), MSG.colEventType(), MSG.colDate(), MSG.colStartTime(), MSG.colEndTime()}, new String[]{"left", "right", "right", "left", "left", "left", "left", "left"}, new boolean[]{true, true, true, true, true, true, true, true});
        table.setBlankWhenSame(true);
        TreeSet<ExamPeriod> periods = ExamPeriod.findAll(sessionId, ((RoomAvailabilityForm)this.form).getExamType());
        if (periods.isEmpty()) {
            table.addLine(new String[]{color ? "<font color='orange'>" + MSG.warnNoExaminationPeriods() + "</font>" : MSG.warnNoExaminationPeriods()}, null);
            return table;
        }
        Date[] bounds = ExamPeriod.getBounds((Session)SessionDAO.getInstance().get(sessionId), ((RoomAvailabilityForm)this.form).getExamType());
        Formats.Format<Date> dateFormat = Formats.getDateFormat(Formats.Pattern.DATE_MEETING);
        Formats.Format<Date> timeFormat = Formats.getDateFormat(Formats.Pattern.TIME_SHORT);
        String ts = null;
        try {
            for (Location location : Location.findAllExamLocations(sessionId, ((RoomAvailabilityForm)this.form).getExamType())) {
                String exclude;
                if (!this.match(location.getLabel())) continue;
                String string = ((RoomAvailabilityForm)this.form).getIncludeExams() ? null : (exclude = ((ExamType)ExamTypeDAO.getInstance().get(((RoomAvailabilityForm)this.form).getExamType())).getType() == 0 ? RoomAvailabilityInterface.sFinalExamType : RoomAvailabilityInterface.sMidtermExamType);
                Collection<RoomAvailabilityInterface.TimeBlock> events = ra.getRoomAvailability(location.getUniqueId(), bounds[0], bounds[1], exclude);
                if (events == null) continue;
                if (ts == null) {
                    ts = ra.getTimeStamp(bounds[0], bounds[1], exclude);
                }
                for (RoomAvailabilityInterface.TimeBlock event : events) {
                    boolean overlaps = false;
                    for (ExamPeriod period : periods) {
                        if (!period.overlap(event)) continue;
                        overlaps = true;
                        break;
                    }
                    if (!overlaps) continue;
                    table.addLine(null, new String[]{location.getLabel(), location.getCapacity().toString(), location.getExamCapacity().toString(), event.getEventName(), event.getEventType(), dateFormat.format(event.getStartTime()), timeFormat.format(event.getStartTime()).replaceAll("AM", GWT_CONST.timeShortAm()).replaceAll("PM", GWT_CONST.timeShortPm()), timeFormat.format(event.getEndTime()).replaceAll("AM", GWT_CONST.timeShortAm()).replaceAll("PM", GWT_CONST.timeShortPm())}, new Comparable[]{new MultiComparable((Comparable)((Object)location.getLabel()), event.getStartTime()), new MultiComparable(Integer.valueOf(-location.getCapacity().intValue()), (Comparable)((Object)location.getLabel()), event.getStartTime()), new MultiComparable(Integer.valueOf(-location.getExamCapacity().intValue()), (Comparable)((Object)location.getLabel()), event.getStartTime()), new MultiComparable((Comparable)((Object)event.getEventName()), (Comparable)((Object)location.getLabel()), event.getStartTime()), new MultiComparable((Comparable)((Object)event.getEventType()), (Comparable)((Object)event.getEventName()), (Comparable)((Object)location.getLabel()), event.getStartTime()), new MultiComparable(event.getStartTime(), (Comparable)((Object)location.getLabel())), new MultiComparable(Long.valueOf(event.getStartTime().getTime() % 86400000L), (Comparable)((Object)location.getLabel())), new MultiComparable(Long.valueOf(event.getEndTime().getTime() % 86400000L), (Comparable)((Object)location.getLabel()))}, location.getUniqueId().toString());
                }
            }
            if (ts != null) {
                request.setAttribute("timestamp", ts);
            }
        }
        catch (Exception e) {
            Debug.error(e);
            table.addLine(new String[]{color ? "<font color='red'>" + MSG.error(e.getMessage()) + "</font>" : MSG.error(e.getMessage())}, null);
        }
        return table;
    }

    public PdfWebTable getCompareTable(HttpServletRequest request, Long sessionId, boolean html, boolean color) {
        RoomAvailabilityInterface ra = RoomAvailability.getInstance();
        if (ra == null) {
            return null;
        }
        String nl = html ? "<br>" : "\n";
        PdfWebTable table = new PdfWebTable(9, MSG.sectExaminationComparison(), "roomAvailability.action?ord=%%", new String[]{MSG.colRoom(), MSG.colRoomCapacity(), MSG.colExaminationCapacity().replace("\n", nl), MSG.colExamination(), MSG.colExaminationDate().replace("\n", nl), MSG.colExaminationTime().replace("\n", nl), MSG.colEvent(), MSG.colEventDate().replace("\n", nl), MSG.colEventTime().replace("\n", nl)}, new String[]{"left", "right", "right", "left", "left", "left", "left", "left", "left"}, new boolean[]{true, true, true, true, true, true, true, true, true});
        table.setBlankWhenSame(true);
        TreeSet<ExamPeriod> periods = ExamPeriod.findAll(sessionId, ((RoomAvailabilityForm)this.form).getExamType());
        if (periods.isEmpty()) {
            table.addLine(new String[]{color ? "<font color='orange'>" + MSG.warnNoExaminationPeriods() + "</font>" : MSG.warnNoExaminationPeriods()}, null);
            return table;
        }
        Date[] bounds = ExamPeriod.getBounds((Session)SessionDAO.getInstance().get(sessionId), ((RoomAvailabilityForm)this.form).getExamType());
        Formats.Format<Date> dateFormat = Formats.getDateFormat(Formats.Pattern.DATE_EXAM_PERIOD);
        Formats.Format<Date> timeFormat = Formats.getDateFormat(Formats.Pattern.TIME_SHORT);
        String ts = null;
        String eventType = ((ExamType)ExamTypeDAO.getInstance().get(((RoomAvailabilityForm)this.form).getExamType())).getType() == 0 ? RoomAvailabilityInterface.sFinalExamType : RoomAvailabilityInterface.sMidtermExamType;
        ExamSolverProxy examAssignment = WebSolver.getExamSolver(request.getSession());
        if (examAssignment != null && !examAssignment.getExamTypeId().equals(((RoomAvailabilityForm)this.form).getExamType())) {
            examAssignment = null;
        }
        try {
            for (Location location : Location.findAllExamLocations(sessionId, ((RoomAvailabilityForm)this.form).getExamType())) {
                ExamAssignment match;
                if (!this.match(location.getLabel())) continue;
                Collection<RoomAvailabilityInterface.TimeBlock> events = ra.getRoomAvailability(location.getUniqueId(), bounds[0], bounds[1], null);
                if (ts == null) {
                    ts = ra.getTimeStamp(bounds[0], bounds[1], null);
                }
                TreeSet<Object> exams = null;
                if (examAssignment != null) {
                    exams = examAssignment.getExamsOfRoom(location.getUniqueId());
                } else {
                    exams = new TreeSet();
                    for (Exam x : ExamDAO.getInstance().getSession().createQuery("select x from Exam x inner join x.assignedRooms r where x.examType.uniqueId=:examTypeId and r.uniqueId=:locationId", Exam.class).setParameter("examTypeId", (Object)((RoomAvailabilityForm)this.form).getExamType()).setParameter("locationId", (Object)location.getUniqueId()).setCacheable(true).list()) {
                        exams.add(new ExamAssignment(x));
                    }
                }
                if (exams == null) {
                    exams = new TreeSet();
                }
                if (events == null) {
                    events = new TreeSet<RoomAvailabilityInterface.TimeBlock>();
                }
                Hashtable<RoomAvailabilityInterface.TimeBlock, ExamAssignment> mapping = new Hashtable<RoomAvailabilityInterface.TimeBlock, ExamAssignment>();
                for (RoomAvailabilityInterface.TimeBlock timeBlock : events) {
                    if (!eventType.equals(timeBlock.getEventType())) continue;
                    match = null;
                    for (ExamAssignment examAssignment2 : exams) {
                        if (!timeBlock.getEventName().trim().equalsIgnoreCase(examAssignment2.getExamName().trim()) || !examAssignment2.getPeriod().overlap(timeBlock)) continue;
                        match = examAssignment2;
                        break;
                    }
                    if (match == null) continue;
                    mapping.put(timeBlock, match);
                    exams.remove(match);
                }
                for (RoomAvailabilityInterface.TimeBlock timeBlock : events) {
                    if (!eventType.equals(timeBlock.getEventType())) continue;
                    match = null;
                    for (ExamAssignment examAssignment3 : exams) {
                        if (!timeBlock.getEventName().trim().equalsIgnoreCase(examAssignment3.getExamName().trim())) continue;
                        match = examAssignment3;
                        break;
                    }
                    if (match == null) continue;
                    mapping.put(timeBlock, match);
                    exams.remove(match);
                }
                for (RoomAvailabilityInterface.TimeBlock timeBlock : events) {
                    if (!eventType.equals(timeBlock.getEventType())) continue;
                    match = null;
                    for (ExamAssignment examAssignment4 : exams) {
                        if (!examAssignment4.getPeriod().overlap(timeBlock)) continue;
                        match = examAssignment4;
                        break;
                    }
                    if (match == null) continue;
                    mapping.put(timeBlock, match);
                    exams.remove(match);
                }
                for (RoomAvailabilityInterface.TimeBlock timeBlock : events) {
                    if (!eventType.equals(timeBlock.getEventType())) continue;
                    match = (ExamAssignment)mapping.get(timeBlock);
                    if (match == null) {
                        table.addLine(null, new String[]{location.getLabel(), location.getCapacity().toString(), location.getExamCapacity().toString(), "", "", "", (html ? "<span style='background-color:yellow;'>" : (color ? "@@BGCOLOR FFFF00 " : "")) + timeBlock.getEventName() + (html ? "</span>" : (color ? " @@END_BGCOLOR " : "")), (html ? "<span style='background-color:yellow;'>" : (color ? "@@BGCOLOR FFFF00 " : "")) + (html ? dateFormat.format(timeBlock.getStartTime()).replaceAll(" ", "&nbsp;") : dateFormat.format(timeBlock.getStartTime())) + (html ? "</span>" : (color ? " @@END_BGCOLOR " : "")), (html ? "<span style='background-color:yellow;'>" : (color ? "@@BGCOLOR FFFF00 " : "")) + timeFormat.format(timeBlock.getStartTime()).replaceAll("AM", GWT_CONST.timeShortAm()).replaceAll("PM", GWT_CONST.timeShortPm()) + (html ? "</span>" : (color ? " @@END_BGCOLOR " : "")) + (html ? "&nbsp;-&nbsp;" : " - ") + (html ? "<span style='background-color:yellow;'>" : (color ? "@@BGCOLOR FFFF00 " : "")) + timeFormat.format(timeBlock.getEndTime()).replaceAll("AM", GWT_CONST.timeShortAm()).replaceAll("PM", GWT_CONST.timeShortPm()) + (html ? "</span>" : (color ? " @@END_BGCOLOR " : ""))}, new Comparable[]{new MultiComparable((Comparable)((Object)location.getLabel()), timeBlock.getStartTime()), new MultiComparable(Integer.valueOf(-location.getCapacity().intValue()), (Comparable)((Object)location.getLabel()), timeBlock.getStartTime()), new MultiComparable(Integer.valueOf(-location.getExamCapacity().intValue()), (Comparable)((Object)location.getLabel()), timeBlock.getStartTime()), new MultiComparable((Comparable)((Object)""), (Comparable)((Object)location.getLabel()), new Date(0L)), new MultiComparable(new Date(0L), (Comparable)((Object)location.getLabel())), new MultiComparable(Integer.valueOf(0), (Comparable)((Object)location.getLabel())), new MultiComparable((Comparable)((Object)timeBlock.getEventName()), (Comparable)((Object)location.getLabel()), timeBlock.getStartTime()), new MultiComparable(timeBlock.getStartTime(), (Comparable)((Object)location.getLabel())), new MultiComparable(Long.valueOf(timeBlock.getStartTime().getTime() % 86400000L), (Comparable)((Object)location.getLabel()))}, location.getUniqueId().toString());
                        continue;
                    }
                    Calendar c = Calendar.getInstance();
                    c.setTime(match.getPeriod().getStartTime());
                    c.add(12, match.getPrintOffset());
                    Date date = c.getTime();
                    c.add(12, match.getLength());
                    Date endTime = c.getTime();
                    boolean nameMatch = timeBlock.getEventName().trim().equalsIgnoreCase(match.getExamName().trim());
                    boolean dateMatch = dateFormat.format(timeBlock.getStartTime()).equals(dateFormat.format(match.getPeriod().getStartDate()));
                    Date start = timeBlock.getStartTime();
                    int breakTimeStart = match.getPeriod().getEventStartOffset() * Constants.SLOT_LENGTH_MIN;
                    c = Calendar.getInstance(Locale.US);
                    c.setTime(start);
                    c.add(12, breakTimeStart);
                    start = c.getTime();
                    Date stop = timeBlock.getEndTime();
                    int breakTimeStop = match.getPeriod().getEventStopOffset() * Constants.SLOT_LENGTH_MIN;
                    c = Calendar.getInstance(Locale.US);
                    c.setTime(stop);
                    c.add(12, -breakTimeStop);
                    stop = c.getTime();
                    boolean startMatch = start.equals(date);
                    boolean endMatch = stop.equals(endTime);
                    if (nameMatch && dateMatch && startMatch && endMatch) continue;
                    table.addLine(null, new String[]{location.getLabel(), location.getCapacity().toString(), location.getExamCapacity().toString(), (nameMatch ? "" : (html ? "<span style='background-color:yellow;'>" : (color ? "@@BGCOLOR FFFF00 " : ""))) + match.getExamName() + (nameMatch ? "" : (html ? "</span>" : (color ? " @@END_BGCOLOR " : ""))), (dateMatch ? "" : (html ? "<span style='background-color:yellow;'>" : (color ? "@@BGCOLOR FFFF00 " : ""))) + (html ? dateFormat.format(match.getPeriod().getStartDate()).replaceAll(" ", "&nbsp;") : dateFormat.format(match.getPeriod().getStartDate())) + (dateMatch ? "" : (html ? "</span>" : (color ? " @@END_BGCOLOR " : ""))), (startMatch ? "" : (html ? "<span style='background-color:yellow;'>" : (color ? "@@BGCOLOR FFFF00 " : ""))) + timeFormat.format(date).replaceAll("AM", "a").replaceAll("PM", "p") + (startMatch ? "" : (html ? "</span>" : (color ? " @@END_BGCOLOR " : ""))) + (html ? "&nbsp;-&nbsp;" : " - ") + (endMatch ? "" : (html ? "<span style='background-color:yellow;'>" : (color ? "@@BGCOLOR FFFF00 " : ""))) + timeFormat.format(endTime).replaceAll("AM", "a").replaceAll("PM", "p") + (endMatch ? "" : (html ? "</span>" : (color ? " @@END_BGCOLOR " : ""))), (nameMatch ? "" : (html ? "<span style='background-color:yellow;'>" : (color ? "@@BGCOLOR FFFF00 " : ""))) + timeBlock.getEventName() + (nameMatch ? "" : (html ? "</span>" : (color ? " @@END_BGCOLOR " : ""))), (dateMatch ? "" : (html ? "<span style='background-color:yellow;'>" : (color ? "@@BGCOLOR FFFF00 " : ""))) + (html ? dateFormat.format(timeBlock.getStartTime()).replaceAll(" ", "&nbsp;") : dateFormat.format(timeBlock.getStartTime())) + (dateMatch ? "" : (html ? "</span>" : (color ? " @@END_BGCOLOR " : ""))), (startMatch ? "" : (html ? "<span style='background-color:yellow;'>" : (color ? "@@BGCOLOR FFFF00 " : ""))) + timeFormat.format(timeBlock.getStartTime()).replaceAll("AM", GWT_CONST.timeShortAm()).replaceAll("PM", GWT_CONST.timeShortPm()) + (startMatch ? "" : (html ? "</span>" : (color ? " @@END_BGCOLOR " : ""))) + (html ? "&nbsp;-&nbsp;" : " - ") + (endMatch ? "" : (html ? "<span style='background-color:yellow;'>" : (color ? "@@BGCOLOR FFFF00 " : ""))) + timeFormat.format(timeBlock.getEndTime()).replaceAll("AM", GWT_CONST.timeShortAm()).replaceAll("PM", GWT_CONST.timeShortPm()) + (endMatch ? "" : (html ? "</span>" : (color ? " @@END_BGCOLOR " : "")))}, new Comparable[]{new MultiComparable((Comparable)((Object)location.getLabel()), timeBlock.getStartTime()), new MultiComparable(Integer.valueOf(-location.getCapacity().intValue()), (Comparable)((Object)location.getLabel()), timeBlock.getStartTime()), new MultiComparable(Integer.valueOf(-location.getExamCapacity().intValue()), (Comparable)((Object)location.getLabel()), timeBlock.getStartTime()), new MultiComparable((Comparable)((Object)match.getExamName()), (Comparable)((Object)location.getLabel()), match.getPeriod().getStartTime()), new MultiComparable(match.getPeriod().getStartTime(), (Comparable)((Object)location.getLabel())), new MultiComparable(Long.valueOf(match.getPeriod().getStartTime().getTime() % 86400000L), (Comparable)((Object)location.getLabel())), new MultiComparable((Comparable)((Object)timeBlock.getEventName()), (Comparable)((Object)location.getLabel()), timeBlock.getStartTime()), new MultiComparable(timeBlock.getStartTime(), (Comparable)((Object)location.getLabel())), new MultiComparable(Long.valueOf(timeBlock.getStartTime().getTime() % 86400000L), (Comparable)((Object)location.getLabel()))}, location.getUniqueId().toString());
                }
                for (ExamAssignment examAssignment5 : exams) {
                    Calendar c = Calendar.getInstance();
                    c.setTime(examAssignment5.getPeriod().getStartTime());
                    c.add(12, examAssignment5.getLength());
                    Date endTime = c.getTime();
                    table.addLine(null, new String[]{location.getLabel(), location.getCapacity().toString(), location.getExamCapacity().toString(), (html ? "<span style='background-color:yellow;'>" : (color ? "@@BGCOLOR FFFF00 " : "")) + examAssignment5.getExamName() + (html ? "</span>" : (color ? " @@END_BGCOLOR " : "")), (html ? "<span style='background-color:yellow;'>" : (color ? "@@BGCOLOR FFFF00 " : "")) + (html ? dateFormat.format(examAssignment5.getPeriod().getStartDate()).replaceAll(" ", "&nbsp;") : dateFormat.format(examAssignment5.getPeriod().getStartDate())) + (html ? "</span>" : (color ? " @@END_BGCOLOR " : "")), (html ? "<span style='background-color:yellow;'>" : (color ? "@@BGCOLOR FFFF00 " : "")) + timeFormat.format(examAssignment5.getPeriod().getStartTime()).replaceAll("AM", GWT_CONST.timeShortAm()).replaceAll("PM", GWT_CONST.timeShortPm()) + (html ? "</span>" : (color ? " @@END_BGCOLOR " : "")) + (html ? "&nbsp;-&nbsp;" : " - ") + (html ? "<span style='background-color:yellow;'>" : (color ? "@@BGCOLOR FFFF00 " : "")) + timeFormat.format(endTime).replaceAll("AM", GWT_CONST.timeShortAm()).replaceAll("PM", GWT_CONST.timeShortPm()) + (html ? "</span>" : (color ? " @@END_BGCOLOR " : "")), "", "", ""}, new Comparable[]{new MultiComparable((Comparable)((Object)location.getLabel()), examAssignment5.getPeriod().getStartTime()), new MultiComparable(Integer.valueOf(-location.getCapacity().intValue()), (Comparable)((Object)location.getLabel()), examAssignment5.getPeriod().getStartTime()), new MultiComparable(Integer.valueOf(-location.getExamCapacity().intValue()), (Comparable)((Object)location.getLabel()), examAssignment5.getPeriod().getStartTime()), new MultiComparable((Comparable)((Object)examAssignment5.getExamName()), (Comparable)((Object)location.getLabel()), examAssignment5.getPeriod().getStartTime()), new MultiComparable(examAssignment5.getPeriod().getStartTime(), (Comparable)((Object)location.getLabel())), new MultiComparable(Long.valueOf(examAssignment5.getPeriod().getStartTime().getTime() % 86400000L), (Comparable)((Object)location.getLabel())), new MultiComparable((Comparable)((Object)""), (Comparable)((Object)location.getLabel()), new Date(0L)), new MultiComparable(new Date(0L), (Comparable)((Object)location.getLabel())), new MultiComparable(Integer.valueOf(0), (Comparable)((Object)location.getLabel()))}, location.getUniqueId().toString());
                }
            }
            if (ts != null) {
                request.setAttribute("timestamp", ts);
            }
        }
        catch (Exception e) {
            Debug.error(e);
            table.addLine(new String[]{color ? "<font color='red'>" + MSG.error(e.getMessage()) + "</font>" : MSG.error(e.getMessage())}, null);
        }
        return table;
    }
}

