/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.action;

import java.util.StringTokenizer;
import org.apache.struts2.convention.annotation.Action;
import org.apache.struts2.convention.annotation.Result;
import org.apache.struts2.tiles.annotation.TilesDefinition;
import org.apache.struts2.tiles.annotation.TilesDefinitions;
import org.apache.struts2.tiles.annotation.TilesPutAttribute;
import org.unitime.commons.web.WebTable;
import org.unitime.localization.impl.Localization;
import org.unitime.localization.messages.CourseMessages;
import org.unitime.timetable.action.UniTimeAction;
import org.unitime.timetable.form.ManagerSettingsForm;
import org.unitime.timetable.model.Settings;
import org.unitime.timetable.model.dao.SettingsDAO;
import org.unitime.timetable.security.rights.Right;

@Action(value="managerSettings", results={@Result(name={"showManagerSettings"}, type="tiles", location="managerSettings.tiles"), @Result(name={"editManagerSettings"}, type="tiles", location="editManagerSettings.tiles")})
@TilesDefinitions(value={@TilesDefinition(name="managerSettings.tiles", extend="baseLayout", putAttributes={@TilesPutAttribute(name="title", value="Manager Settings"), @TilesPutAttribute(name="body", value="/user/managerSettings.jsp")}), @TilesDefinition(name="editManagerSettings.tiles", extend="baseLayout", putAttributes={@TilesPutAttribute(name="title", value="Edit Manager Setting"), @TilesPutAttribute(name="body", value="/user/managerSettings.jsp")})})
public class ManagerSettingsAction
extends UniTimeAction<ManagerSettingsForm> {
    private static final long serialVersionUID = 1306771389501347777L;
    protected static final CourseMessages MSG = Localization.create(CourseMessages.class);

    public String execute() throws Exception {
        this.sessionContext.checkPermission(Right.SettingsUser);
        if (this.form == null) {
            this.form = new ManagerSettingsForm();
            ((ManagerSettingsForm)this.form).reset();
        }
        if (this.op == null) {
            this.op = ((ManagerSettingsForm)this.form).getOp();
        } else {
            ((ManagerSettingsForm)this.form).setOp(this.op);
        }
        if (MSG.actionBackToManagerSettings().equals(this.op)) {
            ((ManagerSettingsForm)this.form).reset();
            ((ManagerSettingsForm)this.form).setOp("List");
        }
        if ("Edit".equals(this.op)) {
            Settings s = (Settings)SettingsDAO.getInstance().get(Long.valueOf(this.request.getParameter("id")));
            ((ManagerSettingsForm)this.form).setOp("Edit");
            ((ManagerSettingsForm)this.form).setAllowedValues(s.getAllowedValues());
            ((ManagerSettingsForm)this.form).setKey(s.getKey());
            ((ManagerSettingsForm)this.form).setName(s.getDescription());
            ((ManagerSettingsForm)this.form).setDefaultValue(s.getDefaultValue());
            ((ManagerSettingsForm)this.form).setValue(this.sessionContext.getUser().getProperty(s.getKey(), s.getDefaultValue()));
            return "editManagerSettings";
        }
        if (MSG.actionUpdateManagerSetting().equals(this.op)) {
            ((ManagerSettingsForm)this.form).validate(this);
            if (this.hasFieldErrors()) {
                ((ManagerSettingsForm)this.form).setOp("Edit");
                ((ManagerSettingsForm)this.form).setAllowedValues(Settings.getSetting(((ManagerSettingsForm)this.form).getKey()).getAllowedValues());
                return "editManagerSettings";
            }
            this.sessionContext.getUser().setProperty(((ManagerSettingsForm)this.form).getKey(), ((ManagerSettingsForm)this.form).getValue());
        }
        this.getSettingsList();
        return "showManagerSettings";
    }

    private void getSettingsList() throws Exception {
        WebTable.setOrder(this.sessionContext, "managerSettings.ord", this.request.getParameter("ord"), 1);
        WebTable webTable = new WebTable(2, MSG.sectionManagerSettings(), "managerSettings.action?ord=%%", new String[]{MSG.columnManagerSettingKey(), MSG.columnManagerSettingValue()}, new String[]{"left", "left"}, null);
        for (Settings s : SettingsDAO.getInstance().getSession().createQuery("from Settings order by key", Settings.class).setCacheable(true).list()) {
            String value;
            String onClick = "onClick=\"document.location='managerSettings.action?op=Edit&id=" + s.getUniqueId() + "';\"";
            String label = value = this.sessionContext.getUser().getProperty(s.getKey(), s.getDefaultValue());
            StringTokenizer k = new StringTokenizer(s.getAllowedValues(), ",");
            while (k.hasMoreTokens()) {
                String v = k.nextToken().trim();
                if (!v.startsWith(value + ":")) continue;
                label = v.substring(v.indexOf(58) + 1);
                break;
            }
            webTable.addLine(onClick, new String[]{s.getDescription(), label}, (Comparable[])new String[]{s.getDescription(), label});
        }
        this.request.setAttribute("table", (Object)webTable.printTable(WebTable.getOrder(this.sessionContext, "managerSettings.ord")));
    }
}

