/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.action;

import java.net.URLEncoder;
import java.text.ParseException;
import java.util.Enumeration;
import java.util.HashSet;
import org.apache.struts2.convention.annotation.Action;
import org.apache.struts2.convention.annotation.Result;
import org.apache.struts2.tiles.annotation.TilesDefinition;
import org.apache.struts2.tiles.annotation.TilesPutAttribute;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.unitime.commons.Debug;
import org.unitime.localization.impl.Localization;
import org.unitime.localization.messages.CourseMessages;
import org.unitime.timetable.action.PreferencesAction2;
import org.unitime.timetable.defaults.ApplicationProperty;
import org.unitime.timetable.defaults.UserProperty;
import org.unitime.timetable.form.InstructorEditForm;
import org.unitime.timetable.model.ChangeLog;
import org.unitime.timetable.model.DepartmentalInstructor;
import org.unitime.timetable.model.InstructorAttribute;
import org.unitime.timetable.model.Preference;
import org.unitime.timetable.model.PreferenceLevel;
import org.unitime.timetable.model.TimePattern;
import org.unitime.timetable.model.TimePref;
import org.unitime.timetable.model.dao.DepartmentalInstructorDAO;
import org.unitime.timetable.security.rights.Right;
import org.unitime.timetable.util.Formats;
import org.unitime.timetable.util.LookupTables;
import org.unitime.timetable.webutil.BackTracker;
import org.unitime.timetable.webutil.Navigation;

@Action(value="instructorAssignmentPref", results={@Result(name={"showEdit"}, type="tiles", location="instructorAssignmentPref.tiles"), @Result(name={"showDetail"}, type="redirect", location="/instructorDetail.action", params={"instructorId", "${form.instructorId}", "showPrefs", "true"}), @Result(name={"showList"}, type="redirect", location="/instructorSearch.action")})
@TilesDefinition(name="instructorAssignmentPref.tiles", extend="baseLayout", putAttributes={@TilesPutAttribute(name="title", value="Instructor Assignment Preferences"), @TilesPutAttribute(name="body", value="/user/instructorAssignmentPref.jsp"), @TilesPutAttribute(name="showNavigation", value="true"), @TilesPutAttribute(name="checkRole", value="false")})
public class InstructorAssignmentPrefAction
extends PreferencesAction2<InstructorEditForm> {
    private static final long serialVersionUID = 8795827984312568961L;
    protected static final CourseMessages MSG = Localization.create(CourseMessages.class);
    protected String instructorId = null;
    protected String op2 = null;

    public String getInstructorId() {
        return this.instructorId;
    }

    public void setInstructorId(String instructorId) {
        this.instructorId = instructorId;
    }

    public String getOp2() {
        return this.op2;
    }

    public void setOp2(String op2) {
        this.op2 = op2;
    }

    @Override
    public String execute() throws Exception {
        if (ApplicationProperty.LegacyInstructors.isFalse()) {
            Object url = "instrAssignmentPrefs";
            boolean first = true;
            Enumeration e = this.getRequest().getParameterNames();
            while (e.hasMoreElements()) {
                String param = (String)e.nextElement();
                url = (String)url + (first ? "?" : "&") + param + "=" + URLEncoder.encode(this.getRequest().getParameter(param), "utf-8");
                first = false;
            }
            this.response.sendRedirect((String)url);
            return null;
        }
        if (this.form == null) {
            this.form = new InstructorEditForm();
        }
        super.execute();
        if (this.instructorId == null && this.request.getAttribute("instructorId") != null) {
            this.instructorId = (String)this.request.getAttribute("instructorId");
        }
        if (this.instructorId == null) {
            this.instructorId = ((InstructorEditForm)this.form).getInstructorId();
        }
        if (this.op == null) {
            this.op = ((InstructorEditForm)this.form).getOp();
        }
        if (this.op2 != null && !this.op2.isEmpty()) {
            this.op = this.op2;
        }
        if (this.op == null || this.op.trim().isEmpty()) {
            this.op = "init";
        }
        if (this.op == null || this.op.trim().isEmpty()) {
            throw new Exception(MSG.exceptionNullOperationNotSupported());
        }
        if (this.instructorId == null || this.instructorId.trim().isEmpty()) {
            throw new Exception(MSG.exceptionInstructorInfoNotSupplied());
        }
        ((InstructorEditForm)this.form).setScreenName("instructorPref");
        DepartmentalInstructorDAO idao = DepartmentalInstructorDAO.getInstance();
        DepartmentalInstructor inst = (DepartmentalInstructor)idao.get(Long.valueOf(this.instructorId));
        LookupTables.setupInstructorDistribTypes(this.request, this.sessionContext, inst);
        this.sessionContext.checkPermission(inst.getDepartment(), Right.InstructorAssignmentPreferences);
        if (MSG.actionBackToDetail().equals(this.op)) {
            if (BackTracker.hasBack(this.request, 1)) {
                BackTracker.doBack(this.request, this.response);
                return null;
            }
            if (this.instructorId != null && !this.instructorId.trim().isEmpty()) {
                return "showDetail";
            }
            return "showList";
        }
        if ("init".equals(this.op)) {
            ((InstructorEditForm)this.form).reset();
            this.doLoad(inst, this.instructorId);
        }
        if (MSG.actionUpdatePreferences().equals(this.op) || MSG.actionNextInstructor().equals(this.op) || MSG.actionPreviousInstructor().equals(this.op)) {
            ((InstructorEditForm)this.form).validate(this);
            if (!this.hasFieldErrors()) {
                this.doUpdate();
                if (MSG.actionNextInstructor().equals(this.op)) {
                    this.response.sendRedirect(this.response.encodeURL("instructorAssignmentPref.action?instructorId=" + ((InstructorEditForm)this.form).getNextId()));
                    return null;
                }
                if (MSG.actionPreviousInstructor().equals(this.op)) {
                    this.response.sendRedirect(this.response.encodeURL("instructorAssignmentPref.action?instructorId=" + ((InstructorEditForm)this.form).getPreviousId()));
                    return null;
                }
                return "showDetail";
            }
        }
        HashSet<TimePattern> timePatterns = new HashSet<TimePattern>();
        ((InstructorEditForm)this.form).setAvailableTimePatterns(null);
        if ("init".equals(this.op)) {
            this.initPrefs(inst, null, true);
            timePatterns.add(new TimePattern(-1L));
            for (Preference pref : inst.getPreferences()) {
                if (!(pref instanceof TimePref)) continue;
                ((InstructorEditForm)this.form).setAvailability(((TimePref)pref).getPreference());
                break;
            }
        }
        this.processPrefAction();
        LookupTables.setupCourses(this.request, inst);
        LookupTables.setupInstructorAttributeTypes(this.request, inst);
        LookupTables.setupInstructorAttributes(this.request, inst);
        BackTracker.markForBack(this.request, "instructorDetail.action?instructorId=" + ((InstructorEditForm)this.form).getInstructorId(), MSG.backInstructor(((InstructorEditForm)this.form).getName() == null ? "null" : ((InstructorEditForm)this.form).getName().trim()), true, false);
        return "showEdit";
    }

    private void doLoad(DepartmentalInstructor inst, String instructorId) {
        ((InstructorEditForm)this.form).setInstructorId(instructorId);
        if ("Enabled".equalsIgnoreCase(ApplicationProperty.InstructorUnavailbeDays.value()) || "Assignments".equalsIgnoreCase(ApplicationProperty.InstructorUnavailbeDays.value())) {
            this.request.setAttribute("unavailableDaysPattern", (Object)inst.getUnavailablePatternHtml(true));
        }
        ((InstructorEditForm)this.form).setName(inst.getName(UserProperty.NameFormat.get(this.sessionContext.getUser())) + (String)(inst.getPositionType() == null ? "" : " (" + inst.getPositionType().getLabel() + ")"));
        ((InstructorEditForm)this.form).setMaxLoad(inst.getMaxLoad() == null ? null : Formats.getNumberFormat("0.##").format(inst.getMaxLoad()));
        ((InstructorEditForm)this.form).setTeachingPreference(inst.getTeachingPreference() == null ? PreferenceLevel.sProhibited : inst.getTeachingPreference().getPrefProlog());
        ((InstructorEditForm)this.form).clearAttributes();
        for (InstructorAttribute attribute : inst.getAttributes()) {
            ((InstructorEditForm)this.form).setAttribute(attribute.getUniqueId(), (Boolean)true);
        }
        ((InstructorEditForm)this.form).setPreviousId(Navigation.getPrevious(this.sessionContext, Navigation.sInstructionalOfferingLevel, inst.getUniqueId()));
        ((InstructorEditForm)this.form).setNextId(Navigation.getNext(this.sessionContext, Navigation.sInstructionalOfferingLevel, inst.getUniqueId()));
    }

    protected void doUpdate() throws Exception {
        DepartmentalInstructorDAO idao = DepartmentalInstructorDAO.getInstance();
        Session hibSession = idao.getSession();
        Transaction tx = null;
        try {
            tx = hibSession.beginTransaction();
            DepartmentalInstructor inst = (DepartmentalInstructor)idao.get(Long.valueOf(((InstructorEditForm)this.form).getInstructorId()), hibSession);
            if (((InstructorEditForm)this.form).getMaxLoad() != null && !((InstructorEditForm)this.form).getMaxLoad().isEmpty()) {
                try {
                    inst.setMaxLoad(Float.valueOf(Formats.getNumberFormat("0.##").parse(((InstructorEditForm)this.form).getMaxLoad()).floatValue()));
                }
                catch (ParseException parseException) {}
            } else {
                inst.setMaxLoad(null);
            }
            if (((InstructorEditForm)this.form).getTeachingPreference() != null && !((InstructorEditForm)this.form).getTeachingPreference().isEmpty() && !PreferenceLevel.sProhibited.equals(((InstructorEditForm)this.form).getTeachingPreference())) {
                inst.setTeachingPreference(PreferenceLevel.getPreferenceLevel(((InstructorEditForm)this.form).getTeachingPreference()));
            } else {
                inst.setTeachingPreference(null);
            }
            for (InstructorAttribute attribute : inst.getDepartment().getAvailableAttributes()) {
                if (((InstructorEditForm)this.form).getAttribute(attribute.getUniqueId())) {
                    if (inst.getAttributes().contains(attribute)) continue;
                    inst.getAttributes().add(attribute);
                    continue;
                }
                if (!inst.getAttributes().contains(attribute)) continue;
                inst.getAttributes().remove(attribute);
            }
            super.doUpdate(inst, inst.getPreferences(), false, Preference.Type.TIME, Preference.Type.DISTRIBUTION, Preference.Type.COURSE);
            if ("Enabled".equalsIgnoreCase(ApplicationProperty.InstructorUnavailbeDays.value()) || "Assignments".equalsIgnoreCase(ApplicationProperty.InstructorUnavailbeDays.value())) {
                inst.setUnavailablePatternAndOffset(this.request);
            }
            hibSession.merge((Object)inst);
            ChangeLog.addChange(hibSession, this.sessionContext, inst, ChangeLog.Source.INSTRUCTOR_ASSIGNMENT_PREF_EDIT, ChangeLog.Operation.UPDATE, null, inst.getDepartment());
            tx.commit();
        }
        catch (Exception e) {
            Debug.error(e);
            try {
                if (tx != null && tx.isActive()) {
                    tx.rollback();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw e;
        }
    }
}

