/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.timetable.action;

import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeSet;
import org.apache.struts2.convention.annotation.Action;
import org.apache.struts2.convention.annotation.Result;
import org.apache.struts2.tiles.annotation.TilesDefinition;
import org.apache.struts2.tiles.annotation.TilesPutAttribute;
import org.hibernate.Session;
import org.unitime.localization.impl.Localization;
import org.unitime.localization.messages.CourseMessages;
import org.unitime.timetable.action.UniTimeAction;
import org.unitime.timetable.defaults.ApplicationProperty;
import org.unitime.timetable.defaults.CommonValues;
import org.unitime.timetable.defaults.SessionAttribute;
import org.unitime.timetable.defaults.UserProperty;
import org.unitime.timetable.form.ClassInstructorAssignmentForm;
import org.unitime.timetable.interfaces.ExternalInstrOfferingConfigAssignInstructorsAction;
import org.unitime.timetable.model.ChangeLog;
import org.unitime.timetable.model.Class_;
import org.unitime.timetable.model.DepartmentalInstructor;
import org.unitime.timetable.model.InstrOfferingConfig;
import org.unitime.timetable.model.InstructionalOffering;
import org.unitime.timetable.model.OfferingCoordinator;
import org.unitime.timetable.model.SchedulingSubpart;
import org.unitime.timetable.model.StudentSectioningQueue;
import org.unitime.timetable.model.comparators.ClassComparator;
import org.unitime.timetable.model.comparators.ClassCourseComparator;
import org.unitime.timetable.model.comparators.DepartmentalInstructorComparator;
import org.unitime.timetable.model.comparators.SchedulingSubpartComparator;
import org.unitime.timetable.model.dao.InstrOfferingConfigDAO;
import org.unitime.timetable.model.dao.InstructionalOfferingDAO;
import org.unitime.timetable.security.permissions.Permission;
import org.unitime.timetable.security.rights.Right;
import org.unitime.timetable.util.LookupTables;

@Action(value="classInstructorAssignment", results={@Result(name={"classInstructorAssignment"}, type="tiles", location="classInstructorAssignment.tiles"), @Result(name={"instructionalOfferingDetail"}, type="redirect", location="/instructionalOfferingDetail.action", params={"io", "${form.instrOfferingId}", "op", "view"})})
@TilesDefinition(name="classInstructorAssignment.tiles", extend="baseLayout", putAttributes={@TilesPutAttribute(name="title", value="Assign Instructors"), @TilesPutAttribute(name="body", value="/user/classInstructorAssignment.jsp"), @TilesPutAttribute(name="showNavigation", value="true"), @TilesPutAttribute(name="showSolverWarnings", value="assignment")})
public class ClassInstructorAssignmentAction
extends UniTimeAction<ClassInstructorAssignmentForm> {
    private static final long serialVersionUID = -8297282704645449996L;
    protected static final CourseMessages MSG = Localization.create(CourseMessages.class);
    protected String op2 = null;
    private Long uid = null;
    private String nameFormat = null;

    public String getHdnOp() {
        return this.op2;
    }

    public void setHdnOp(String hdnOp) {
        this.op2 = hdnOp;
    }

    public Long getUid() {
        return this.uid;
    }

    public void setUid(Long uid) {
        this.uid = uid;
    }

    public String execute() throws Exception {
        if (this.form == null) {
            this.form = new ClassInstructorAssignmentForm();
            ((ClassInstructorAssignmentForm)this.form).reset();
        }
        if (this.op == null) {
            this.op = ((ClassInstructorAssignmentForm)this.form).getOp();
        }
        if (this.op2 != null && !this.op2.isEmpty()) {
            this.op = this.op2;
        }
        if (this.op == null || this.op.trim().length() == 0) {
            throw new Exception(MSG.exceptionOperationNotInterpreted() + this.op);
        }
        if (this.op.equals(MSG.actionBackToIODetail())) {
            return "instructionalOfferingDetail";
        }
        Long instrOffrConfigId = this.uid;
        if (this.uid == null) {
            instrOffrConfigId = ((ClassInstructorAssignmentForm)this.form).getInstrOffrConfigId();
        }
        ((ClassInstructorAssignmentForm)this.form).setOp(this.op);
        ((ClassInstructorAssignmentForm)this.form).setProxy(this.getClassAssignmentService().getAssignment());
        InstrOfferingConfig ioc = (InstrOfferingConfig)InstrOfferingConfigDAO.getInstance().get(instrOffrConfigId);
        ((ClassInstructorAssignmentForm)this.form).setInstrOffrConfigId(instrOffrConfigId);
        this.sessionContext.checkPermission(ioc, Right.AssignInstructors);
        ArrayList<DepartmentalInstructor> instructors = new ArrayList<DepartmentalInstructor>(ioc.getDepartment().getInstructors());
        if (ApplicationProperty.InstructorsDropdownFollowNameFormatting.isTrue()) {
            Collections.sort(instructors, new DepartmentalInstructorComparator(UserProperty.NameFormat.get(this.sessionContext.getUser())));
        } else {
            Collections.sort(instructors, new DepartmentalInstructorComparator());
        }
        this.request.setAttribute(DepartmentalInstructor.INSTR_LIST_ATTR_NAME, instructors);
        LookupTables.setupInstructorTeachingResponsibilities(this.request);
        if (this.op.equalsIgnoreCase(MSG.actionAssignInstructors())) {
            this.doLoad(instrOffrConfigId, ioc);
        }
        if (this.op.equals(MSG.actionUpdateClassInstructorsAssignment()) || this.op.equals(MSG.actionNextIO()) || this.op.equals(MSG.actionPreviousIO()) || this.op.equals(MSG.actionUnassignAllInstructorsFromConfig())) {
            if (this.op.equals(MSG.actionUnassignAllInstructorsFromConfig())) {
                ((ClassInstructorAssignmentForm)this.form).unassignAllInstructors();
            }
            ((ClassInstructorAssignmentForm)this.form).validate(this);
            if (!this.hasFieldErrors()) {
                ((ClassInstructorAssignmentForm)this.form).updateClasses();
                InstrOfferingConfig cfg = (InstrOfferingConfig)InstrOfferingConfigDAO.getInstance().get(((ClassInstructorAssignmentForm)this.form).getInstrOffrConfigId());
                Session hibSession = InstructionalOfferingDAO.getInstance().getSession();
                ChangeLog.addChange(hibSession, this.sessionContext, cfg, ChangeLog.Source.CLASS_INSTR_ASSIGN, ChangeLog.Operation.UPDATE, cfg.getInstructionalOffering().getControllingCourseOffering().getSubjectArea(), null);
                if (this.getPermissionOfferingLockNeeded().check(this.sessionContext.getUser(), cfg.getInstructionalOffering())) {
                    StudentSectioningQueue.offeringChanged(hibSession, this.sessionContext.getUser(), cfg.getInstructionalOffering().getSessionId(), cfg.getInstructionalOffering().getUniqueId());
                }
                hibSession.flush();
                String className = ApplicationProperty.ExternalActionInstrOfferingConfigAssignInstructors.value();
                if (className != null && className.trim().length() > 0) {
                    ExternalInstrOfferingConfigAssignInstructorsAction assignAction = (ExternalInstrOfferingConfigAssignInstructorsAction)Class.forName(className).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                    assignAction.performExternalInstrOfferingConfigAssignInstructorsAction(ioc, InstrOfferingConfigDAO.getInstance().getSession());
                }
                if (this.op.equals(MSG.actionNextIO())) {
                    this.response.sendRedirect(this.response.encodeURL("classInstructorAssignment.action?uid=" + ((ClassInstructorAssignmentForm)this.form).getNextId() + "&op=" + URLEncoder.encode(MSG.actionAssignInstructors(), "UTF-8")));
                    return null;
                }
                if (this.op.equals(MSG.actionPreviousIO())) {
                    this.response.sendRedirect(this.response.encodeURL("classInstructorAssignment.action?uid=" + ((ClassInstructorAssignmentForm)this.form).getPreviousId() + "&op=" + URLEncoder.encode(MSG.actionAssignInstructors(), "UTF-8")));
                    return null;
                }
                return "instructionalOfferingDetail";
            }
        }
        if (this.op.equals("Delete")) {
            ((ClassInstructorAssignmentForm)this.form).deleteInstructor();
        }
        if (this.op.equals("Add Instructor")) {
            ((ClassInstructorAssignmentForm)this.form).addInstructor();
        }
        return "classInstructorAssignment";
    }

    private void doLoad(Long instrOffrConfigId, InstrOfferingConfig ioc) throws Exception {
        if (instrOffrConfigId == null) {
            throw new Exception(MSG.exceptionMissingIOConfig());
        }
        InstructionalOffering io = ioc.getInstructionalOffering();
        ((ClassInstructorAssignmentForm)this.form).setInstrOffrConfigId(ioc.getUniqueId());
        ((ClassInstructorAssignmentForm)this.form).setInstrOffrConfigLimit(ioc.getLimit());
        ((ClassInstructorAssignmentForm)this.form).setInstrOfferingId(io.getUniqueId());
        ((ClassInstructorAssignmentForm)this.form).setDisplayExternalId(ApplicationProperty.ClassSetupShowExternalIds.isTrue());
        Object name = io.getCourseNameWithTitle();
        if (io.hasMultipleConfigurations()) {
            name = (String)name + " [" + ioc.getName() + "]";
        }
        ((ClassInstructorAssignmentForm)this.form).setInstrOfferingName((String)name);
        if (ioc.getSchedulingSubparts() == null || ioc.getSchedulingSubparts().size() == 0) {
            throw new Exception(MSG.exceptionIOConfigUndefined());
        }
        InstrOfferingConfig config = ioc.getNextInstrOfferingConfig(this.sessionContext);
        if (config != null) {
            ((ClassInstructorAssignmentForm)this.form).setNextId(config.getUniqueId().toString());
        } else {
            ((ClassInstructorAssignmentForm)this.form).setNextId(null);
        }
        config = ioc.getPreviousInstrOfferingConfig(this.sessionContext);
        if (config != null) {
            ((ClassInstructorAssignmentForm)this.form).setPreviousId(config.getUniqueId().toString());
        } else {
            ((ClassInstructorAssignmentForm)this.form).setPreviousId(null);
        }
        ArrayList<SchedulingSubpart> subpartList = new ArrayList<SchedulingSubpart>(ioc.getSchedulingSubparts());
        Collections.sort(subpartList, new SchedulingSubpartComparator());
        for (SchedulingSubpart ss : subpartList) {
            if (ss.getClasses() == null || ss.getClasses().size() == 0) {
                throw new Exception(MSG.exceptionInitialIOSetupIncomplete());
            }
            if (ss.getParentSubpart() != null) continue;
            this.loadClasses((ClassInstructorAssignmentForm)this.form, ss.getClasses(), new String());
        }
        Object coordinators = "";
        String instructorNameFormat = this.sessionContext.getUser().getProperty(UserProperty.NameFormat);
        for (OfferingCoordinator coordinator : new TreeSet<OfferingCoordinator>(io.getOfferingCoordinators())) {
            if (!((String)coordinators).isEmpty()) {
                coordinators = (String)coordinators + "<br>";
            }
            coordinators = (String)coordinators + "<a href='instructorDetail.action?instructorId=" + coordinator.getInstructor().getUniqueId() + "' class='noFancyLinks'>" + coordinator.getInstructor().getName(instructorNameFormat) + (String)(coordinator.getResponsibility() == null ? (coordinator.getPercentShare() != 0 ? " (" + coordinator.getPercentShare() + "%)" : "") : " (" + coordinator.getResponsibility().getLabel() + (String)(coordinator.getPercentShare() > 0 ? ", " + coordinator.getPercentShare() + "%" : "") + ")") + "</a>";
        }
        ((ClassInstructorAssignmentForm)this.form).setCoordinators((String)coordinators);
    }

    private void loadClasses(ClassInstructorAssignmentForm form, Set classes, String indent) {
        if (classes != null && classes.size() > 0) {
            ArrayList classesList = new ArrayList(classes);
            if (CommonValues.Yes.eq(UserProperty.ClassesKeepSort.get(this.sessionContext.getUser()))) {
                Collections.sort(classesList, new ClassCourseComparator(this.sessionContext.getUser().getProperty("InstructionalOfferingList.sortBy", ClassCourseComparator.getName(ClassCourseComparator.SortBy.NAME)), form.getProxy(), false));
            } else {
                Collections.sort(classesList, new ClassComparator(3));
            }
            Class_ cls = null;
            Iterator it = classesList.iterator();
            while (it.hasNext()) {
                form.addToClasses(cls, !this.sessionContext.hasPermission(cls = (Class_)it.next(), Right.AssignInstructorsClass), indent, this.getNameFormat());
                this.loadClasses(form, cls.getChildClasses(), indent + "&nbsp;&nbsp;&nbsp;&nbsp;");
            }
        }
    }

    protected Permission<InstructionalOffering> getPermissionOfferingLockNeeded() {
        return this.getPermission("permissionOfferingLockNeeded");
    }

    public String getCrsNbr() {
        return (String)this.sessionContext.getAttribute(SessionAttribute.OfferingsCourseNumber);
    }

    public String getNameFormat() {
        if (this.nameFormat == null) {
            this.nameFormat = UserProperty.NameFormat.get(this.sessionContext.getUser());
        }
        return this.nameFormat;
    }
}

