/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.localization.impl;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.http.HttpEntity;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.message.BasicNameValuePair;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.SAXReader;
import org.dom4j.io.XMLWriter;
import org.unitime.localization.impl.ExportTranslations;
import org.unitime.localization.impl.POHelper;
import org.unitime.localization.impl.PageNameGenerator;
import org.unitime.localization.messages.PageNames;
import org.unitime.timetable.util.Constants;

public class ImportTranslations {
    private List<ExportTranslations.Locale> iLocales = new ArrayList<ExportTranslations.Locale>();
    private Project iProject;
    private File iBaseDir;
    private File iSource;
    private String iTranslations = "Documentation/Translations";
    private String iToken = null;
    private boolean iGeneratePageNames = false;
    private boolean iFixGwtConfig = true;
    private boolean iDownload = true;

    public void setProject(Project project) {
        this.iProject = project;
        this.iBaseDir = project.getBaseDir();
    }

    public void setBaseDir(String baseDir) {
        this.iBaseDir = new File(baseDir);
    }

    public void setSource(String source) {
        this.iSource = new File(source);
    }

    public ExportTranslations.Locale createLocale() {
        ExportTranslations.Locale locale = new ExportTranslations.Locale();
        this.iLocales.add(locale);
        return locale;
    }

    public void addLocale(ExportTranslations.Locale locale) {
        this.iLocales.add(locale);
    }

    public void setLocales(String locales) {
        for (String value : locales.split(",")) {
            this.addLocale(new ExportTranslations.Locale(value));
        }
    }

    public void setTranslations(String translations) {
        this.iTranslations = translations;
    }

    public void setGeneratePageNames(boolean generatePageNames) {
        this.iGeneratePageNames = generatePageNames;
    }

    public void setFixGwtConfig(boolean fixGwtConfig) {
        this.iFixGwtConfig = fixGwtConfig;
    }

    public void setDownload(boolean download) {
        this.iDownload = download;
    }

    public void setToken(String token) {
        this.iToken = token;
    }

    public void info(String message) {
        if (this.iProject != null) {
            this.iProject.log(message);
        } else {
            System.out.println("     [info] " + message);
        }
    }

    public void warn(String message) {
        if (this.iProject != null) {
            this.iProject.log(message, 1);
        } else {
            System.out.println("  [warning] " + message);
        }
    }

    public void debug(String message) {
        if (this.iProject != null) {
            this.iProject.log(message, 4);
        } else {
            System.out.println("    [debug] " + message);
        }
    }

    public void error(String message) {
        if (this.iProject != null) {
            this.iProject.log(message, 0);
        } else {
            System.out.println("    [error] " + message);
        }
    }

    public void execute() throws BuildException {
        try {
            File translations = new File(this.iBaseDir, this.iTranslations);
            HashMap<String, byte[]> downloads = new HashMap<String, byte[]>();
            if (this.iDownload) {
                this.info("Downloading translations to: " + String.valueOf(translations));
                CloseableHttpClient client = HttpClients.createDefault();
                for (ExportTranslations.Locale locale : this.iLocales) {
                    this.info("Locale " + locale.getValue().replace('_', '-').toLowerCase());
                    HttpPost httpPost = new HttpPost("https://api.poeditor.com/v2/projects/export");
                    ArrayList<BasicNameValuePair> params = new ArrayList<BasicNameValuePair>(2);
                    params.add(new BasicNameValuePair("api_token", this.iToken));
                    params.add(new BasicNameValuePair("id", "568029"));
                    params.add(new BasicNameValuePair("language", locale.getValue().replace('_', '-').toLowerCase()));
                    params.add(new BasicNameValuePair("type", "po"));
                    httpPost.setEntity((HttpEntity)new UrlEncodedFormEntity(params, "UTF-8"));
                    CloseableHttpResponse response = client.execute((HttpUriRequest)httpPost);
                    HttpEntity entity = response.getEntity();
                    HttpGet get = null;
                    if (entity != null) {
                        JsonObject json = JsonParser.parseReader((Reader)new InputStreamReader(entity.getContent())).getAsJsonObject();
                        this.info("Response: " + String.valueOf(json));
                        String url = json.getAsJsonObject("result").get("url").getAsString();
                        this.debug("URL: " + url);
                        get = new HttpGet(url);
                    }
                    response.close();
                    if (get != null && (entity = (response = client.execute(get)).getEntity()) != null) {
                        this.info("Downloading " + String.valueOf(get.getURI()));
                        InputStream in = entity.getContent();
                        byte[] buffer = new byte[10240];
                        File file = new File(translations, "UniTime" + Constants.VERSION + "_" + locale.getValue() + ".po");
                        this.debug("Writing " + String.valueOf(file));
                        ByteArrayOutputStream bos = new ByteArrayOutputStream();
                        FileOutputStream out = new FileOutputStream(file);
                        int read = 0;
                        while ((read = in.read(buffer)) > 0) {
                            out.write(buffer, 0, read);
                            bos.write(buffer, 0, read);
                        }
                        out.flush();
                        out.close();
                        bos.flush();
                        bos.close();
                        downloads.put(locale.getValue(), bos.toByteArray());
                    }
                    response.close();
                }
                client.close();
            }
            if (downloads.isEmpty()) {
                this.info("Importing translations from: " + String.valueOf(translations));
            } else {
                this.info("Importing translations");
            }
            Map<String, String> pageNames = null;
            if (this.iGeneratePageNames) {
                PageNameGenerator gen = new PageNameGenerator();
                gen.setSource(this.iSource);
                gen.execute();
                pageNames = gen.getPageNames();
            } else {
                Properties p = new Properties();
                p.load(new FileInputStream(new File(this.iSource, PageNames.class.getName().replace('.', File.separatorChar) + ".properties")));
                pageNames = new HashMap<String, String>();
                for (Map.Entry<Object, Object> entry : p.entrySet()) {
                    pageNames.put((String)entry.getKey(), (String)entry.getValue());
                }
            }
            for (ExportTranslations.Locale locale : this.iLocales) {
                this.debug("Locale " + String.valueOf(locale));
                POHelper pOHelper = new POHelper(locale.getValue(), pageNames);
                byte[] data = (byte[])downloads.get(locale.getValue());
                if (data == null) {
                    POHelper.Bundle[] input = new File(translations, "UniTime" + Constants.VERSION + "_" + locale.getValue() + ".po");
                    if (!input.exists()) {
                        this.error("Input file " + String.valueOf(input) + " does not exist.");
                        continue;
                    }
                    pOHelper.readPOFile(null, new InputStreamReader((InputStream)new FileInputStream((File)input), StandardCharsets.UTF_8));
                } else {
                    pOHelper.readPOFile(null, new InputStreamReader((InputStream)new ByteArrayInputStream(data), StandardCharsets.UTF_8));
                }
                for (POHelper.Bundle bundle : POHelper.Bundle.values()) {
                    pOHelper.writePropertiesFile(this.iSource, bundle);
                }
            }
            HashSet<String> locales = new HashSet<String>();
            if (this.iFixGwtConfig) {
                this.info("Updating GWT configuration, if needed.");
                File file = new File(this.iSource, "org" + File.separator + "unitime" + File.separator + "timetable" + File.separator + "gwt" + File.separator + "UniTime.gwt.xml");
                Document document = new SAXReader().read(file);
                Iterator i = document.getRootElement().elementIterator("extend-property");
                while (i.hasNext()) {
                    Element e = (Element)i.next();
                    if (!"locale".equals(e.attributeValue("name"))) continue;
                    locales.add(e.attributeValue("values"));
                }
                this.debug("Existing locales: " + String.valueOf(locales));
                boolean changed = false;
                for (ExportTranslations.Locale locale : this.iLocales) {
                    if (locales.contains(locale.getValue())) continue;
                    this.info("added " + String.valueOf(locale));
                    changed = true;
                    document.getRootElement().addElement("extend-property").addAttribute("name", "locale").addAttribute("values", locale.getValue());
                }
                if (changed) {
                    FileOutputStream out = new FileOutputStream(file);
                    new XMLWriter((OutputStream)out, OutputFormat.createPrettyPrint()).write(document);
                    out.flush();
                    out.close();
                }
            }
        }
        catch (Exception e) {
            throw new BuildException("Import failed: " + e.getMessage(), (Throwable)e);
        }
    }

    public static void main(String[] args) {
        try {
            ImportTranslations task = new ImportTranslations();
            task.setBaseDir(System.getProperty("source", "/Users/muller/git/unitime"));
            task.setSource(System.getProperty("source", "/Users/muller/git/unitime") + File.separator + "JavaSource");
            task.setLocales(System.getProperty("locale", "cs"));
            task.setToken(System.getProperty("token", "b191dd443ab1800fc1e09ef23e50cdb0"));
            task.execute();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

