/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.commons.jgroups;

import java.util.Date;
import java.util.List;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.jgroups.Address;
import org.jgroups.conf.ClassConfigurator;
import org.jgroups.protocols.JDBC_PING;
import org.jgroups.protocols.PingData;
import org.jgroups.util.ByteArray;
import org.jgroups.util.Responses;
import org.unitime.commons.hibernate.util.HibernateUtil;
import org.unitime.timetable.model.ClusterDiscovery;
import org.unitime.timetable.model.base.ClusterDiscoveryId;
import org.unitime.timetable.model.dao.ClusterDiscoveryDAO;

public class UniTimeClusterDiscovery
extends JDBC_PING {
    public void init() throws Exception {
        super.init();
    }

    protected void verifyConfigurationParameters() {
    }

    public void attemptSchemaInitialization() {
    }

    protected void loadDriver() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void remove(String clustername, Address addr) {
        if (!HibernateUtil.isConfigured()) {
            return;
        }
        String addressAsString = UniTimeClusterDiscovery.addressAsString((Address)addr);
        Session hibSession = HibernateUtil.createNewSession();
        Transaction tx = hibSession.beginTransaction();
        try {
            ClusterDiscovery cd = (ClusterDiscovery)hibSession.get(ClusterDiscovery.class, (Object)new ClusterDiscoveryId(addressAsString, clustername));
            if (cd != null) {
                hibSession.remove((Object)cd);
            }
            tx.commit();
        }
        catch (Exception e) {
            this.log.error("%s: failed to remove address %s: %s", new Object[]{clustername, addr, e});
            if (tx.isActive()) {
                tx.rollback();
            }
        }
        finally {
            hibSession.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean contains(String cluster_name, Address addr) {
        if (!HibernateUtil.isConfigured()) {
            return false;
        }
        String addressAsString = UniTimeClusterDiscovery.addressAsString((Address)addr);
        try (Session hibSession = HibernateUtil.createNewSession();){
            ClusterDiscovery cd = (ClusterDiscovery)ClusterDiscoveryDAO.getInstance().get(new ClusterDiscoveryId(addressAsString, cluster_name), hibSession);
            boolean bl = cd != null;
            return bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeAll(String clustername) {
        if (!HibernateUtil.isConfigured()) {
            return;
        }
        Session hibSession = HibernateUtil.createNewSession();
        Transaction tx = hibSession.beginTransaction();
        try {
            hibSession.createMutationQuery("delete ClusterDiscovery where clusterName = :clustername").setParameter("clustername", (Object)clustername).executeUpdate();
            tx.commit();
        }
        catch (Exception e) {
            this.log.error("%s: failed to remove all: %s", new Object[]{clustername, e});
            if (tx.isActive()) {
                tx.rollback();
            }
        }
        finally {
            hibSession.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void readAll(List<Address> members, String clustername, Responses responses) {
        if (!HibernateUtil.isConfigured()) {
            return;
        }
        Session hibSession = HibernateUtil.createNewSession();
        Transaction tx = hibSession.beginTransaction();
        try {
            for (ClusterDiscovery cd : hibSession.createQuery("from ClusterDiscovery where clusterName = :clustername", ClusterDiscovery.class).setParameter("clustername", (Object)clustername).list()) {
                try {
                    List data = UniTimeClusterDiscovery.deserialize((byte[])cd.getPingData(), (int)0, (int)cd.getPingData().length);
                    if (data == null || data.isEmpty()) continue;
                    for (PingData pd : data) {
                        if (members != null && !members.contains(pd.getAddress())) continue;
                        responses.addResponse(pd, false);
                        if (this.local_addr == null || this.local_addr.equals(pd.getAddress())) continue;
                        this.addDiscoveryResponseToCaches(pd.getAddress(), pd.getLogicalName(), pd.getPhysicalAddr());
                    }
                }
                catch (Exception e) {
                    this.log.error("%s: failed deserializing row %s: %s; removing it from the table", new Object[]{this.local_addr, cd.getOwnAddress(), e});
                    hibSession.remove((Object)cd);
                }
            }
            tx.commit();
        }
        catch (Exception e) {
            this.log.error("%s: failed to read all: %s", new Object[]{clustername, e});
            if (tx.isActive()) {
                tx.rollback();
            }
        }
        finally {
            hibSession.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized void writeToDB(PingData data, String clustername, boolean overwrite) {
        if (!HibernateUtil.isConfigured()) {
            return;
        }
        String ownAddress = UniTimeClusterDiscovery.addressAsString((Address)data.getAddress());
        ByteArray serializedPingData = this.serializeWithoutView(data);
        Session hibSession = HibernateUtil.createNewSession();
        Transaction tx = hibSession.beginTransaction();
        try {
            ClusterDiscovery cd = (ClusterDiscovery)ClusterDiscoveryDAO.getInstance().get(new ClusterDiscoveryId(ownAddress, this.cluster_name), hibSession);
            if (cd != null) {
                if (overwrite) {
                    cd.setPingData(serializedPingData.getBytes());
                    cd.setTimeStamp(new Date());
                    hibSession.merge((Object)cd);
                }
            } else {
                cd = new ClusterDiscovery();
                cd.setClusterName(clustername);
                cd.setOwnAddress(ownAddress);
                cd.setPingData(serializedPingData.getBytes());
                cd.setTimeStamp(new Date());
                hibSession.persist((Object)cd);
            }
            tx.commit();
        }
        catch (Exception e) {
            this.log.error("%s: failed to update database: %s", new Object[]{clustername, e});
            if (tx.isActive()) {
                tx.rollback();
            }
        }
        finally {
            hibSession.close();
        }
    }

    static {
        ClassConfigurator.addProtocol((short)666, UniTimeClusterDiscovery.class);
    }
}

