/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.commons.jgroups;

import java.util.ArrayList;
import java.util.Map;
import org.jgroups.conf.ConfiguratorFactory;
import org.jgroups.conf.ProtocolConfiguration;
import org.jgroups.conf.ProtocolStackConfigurator;
import org.jgroups.util.Util;
import org.unitime.timetable.ApplicationProperties;

public class JGroupsUtils {
    public static String getProperty(String s) {
        String retval = null;
        int index = s.indexOf(":");
        if (index >= 0) {
            String var = s.substring(0, index);
            String default_val = s.substring(index + 1);
            if (default_val != null && default_val.length() > 0) {
                default_val = default_val.trim();
            }
            retval = JGroupsUtils._getProperty(var, default_val);
        } else {
            String var = s;
            retval = JGroupsUtils._getProperty(var, null);
        }
        return retval;
    }

    private static String _getProperty(String var, String default_value) {
        if (var == null) {
            return null;
        }
        ArrayList<String> list = Util.parseCommaDelimitedStrings((String)var);
        if (list == null || list.isEmpty()) {
            list = new ArrayList<String>(1);
            list.add(var);
        }
        String retval = null;
        for (String prop : list) {
            try {
                retval = ApplicationProperties.getProperty(prop);
                if (retval == null) continue;
                return retval;
            }
            catch (Throwable throwable) {
            }
        }
        return default_value;
    }

    private static String _substituteVar(String val) {
        int start_index = val.indexOf("${");
        if (start_index == -1) {
            return val;
        }
        int end_index = val.indexOf("}", start_index + 2);
        if (end_index == -1) {
            throw new IllegalArgumentException("missing \"}\" in " + val);
        }
        String tmp = JGroupsUtils.getProperty(val.substring(start_index + 2, end_index));
        if (tmp == null) {
            return val;
        }
        StringBuilder sb = new StringBuilder();
        sb.append(val.substring(0, start_index));
        sb.append(tmp);
        sb.append(val.substring(end_index + 1));
        return sb.toString();
    }

    public static String substituteVariable(String val) {
        if (val == null) {
            return val;
        }
        String retval = val;
        while (retval.contains("${")) {
            String prev = retval;
            if (!(retval = JGroupsUtils._substituteVar(retval)).equals(prev)) continue;
            break;
        }
        return retval;
    }

    public static void substituteVariables(ProtocolConfiguration config) {
        Map properties = config.getProperties();
        for (Map.Entry entry : properties.entrySet()) {
            String tmp;
            String key = (String)entry.getKey();
            String val = (String)entry.getValue();
            if (val.equals(tmp = JGroupsUtils.substituteVariable(val))) continue;
            properties.put(key, tmp);
        }
    }

    public static void substituteVariables(ProtocolStackConfigurator configurator) {
        for (ProtocolConfiguration config : configurator.getProtocolStack()) {
            JGroupsUtils.substituteVariables(config);
        }
    }

    public static ProtocolStackConfigurator getConfigurator(String properties) throws Exception {
        ProtocolStackConfigurator configurator = ConfiguratorFactory.getStackConfigurator((String)properties);
        JGroupsUtils.substituteVariables(configurator);
        return configurator;
    }

    public static String getConfigurationString(String properties) throws Exception {
        ProtocolStackConfigurator configurator = ConfiguratorFactory.getStackConfigurator((String)properties);
        StringBuffer ret = new StringBuffer();
        for (ProtocolConfiguration config : configurator.getProtocolStack()) {
            JGroupsUtils.substituteVariables(config);
            if (ret.length() > 0) {
                ret.append(":");
            }
            ret.append(config.getProtocolString());
        }
        return ret.toString();
    }
}

