/*
 * Decompiled with CFR 0.152.
 */
package org.unitime.commons.ant;

import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;
import org.xml.sax.SAXException;

public class DoubleVarcharSizes
extends Task {
    private SAXReader iSAXReader = new SAXReader();
    private String iSource = null;
    private String iConfig = "hibernate.cfg.xml";

    public DoubleVarcharSizes() throws DocumentException, SAXException {
        this.iSAXReader.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
    }

    public void setSource(String source) {
        this.iSource = source;
    }

    public void setConfig(String config) {
        this.iConfig = config;
    }

    protected Document read(String resource) throws IOException, DocumentException {
        if (this.iSource == null) {
            return this.iSAXReader.read(((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream(resource));
        }
        return this.iSAXReader.read(new File(this.iSource + File.separator + resource));
    }

    protected void pretty(File f) {
    }

    public void execute() throws BuildException {
        try {
            this.generate();
        }
        catch (Exception e) {
            throw new BuildException((Throwable)e);
        }
    }

    public void info(String message) {
        try {
            this.log(message);
        }
        catch (Exception e) {
            System.out.println(message);
        }
    }

    public void warn(String message) {
        try {
            this.log(message, 1);
        }
        catch (Exception e) {
            System.out.println(message);
        }
    }

    public void generate() throws IOException, DocumentException {
        Document document = this.read(this.iConfig);
        Element root = document.getRootElement();
        Element sessionFactoryElement = root.element("session-factory");
        Iterator i = sessionFactoryElement.elementIterator("mapping");
        while (i.hasNext()) {
            Element m = (Element)i.next();
            String resource = m.attributeValue("resource");
            if (resource == null) continue;
            this.generate(this.read(resource).getRootElement(), null);
        }
    }

    private void generate(Element element, String table) {
        if ((table = element.attributeValue("table", table)) != null && "property".equals(element.getName())) {
            String column = element.attributeValue("column");
            String type = element.attributeValue("type");
            String length = element.attributeValue("length");
            if (("String".equals(type) || "java.lang.String".equals(type)) && length != null && !length.isEmpty() && column != null && !column.isEmpty()) {
                int size = Integer.parseInt(length);
                this.info("alter table " + table + " modify " + column + " varchar2(" + Math.min(4000, 2 * size) + ");");
            }
        }
        Iterator i = element.elementIterator();
        while (i.hasNext()) {
            this.generate((Element)i.next(), table);
        }
    }

    public static void main(String[] args) {
        try {
            DoubleVarcharSizes dvs = new DoubleVarcharSizes();
            dvs.generate();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

