/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.resource;

import org.restlet.Request;
import org.restlet.Response;
import org.restlet.data.Status;
import org.restlet.resource.Resource;

public class ResourceException
extends RuntimeException {
    private static final long serialVersionUID = 1L;
    private final transient Status status;
    private final transient Request request;
    private final transient Response response;

    public ResourceException(int code) {
        this(new Status(code));
    }

    public ResourceException(int code, String reasonPhrase) {
        this(new Status(code, reasonPhrase));
    }

    public ResourceException(int code, String reasonPhrase, String description) {
        this(new Status(code, reasonPhrase, description));
    }

    public ResourceException(int code, String name, String description, String uri) {
        this(new Status(code, name, description, uri));
    }

    public ResourceException(int code, String reasonPhrase, String description, String uri, Throwable cause) {
        this(new Status(code, cause, reasonPhrase, description, uri), cause);
    }

    public ResourceException(int code, Throwable cause) {
        this(new Status(code, cause), cause);
    }

    public ResourceException(int code, Throwable throwable, String reasonPhrase) {
        this(new Status(code, throwable, reasonPhrase, null, null));
    }

    public ResourceException(int code, Throwable throwable, String reasonPhrase, String description) {
        this(new Status(code, throwable, reasonPhrase, description, null));
    }

    public ResourceException(int code, Throwable throwable, String reasonPhrase, String description, String uri) {
        this(new Status(code, throwable, reasonPhrase, description, uri));
    }

    public ResourceException(Status status) {
        this(status, status == null ? null : status.getThrowable());
    }

    @Deprecated
    public ResourceException(Status status, Resource resource) {
        this(status, status == null ? null : status.getThrowable(), resource.getRequest(), resource.getResponse());
    }

    public ResourceException(Status status, Request request, Response response) {
        this(status, status == null ? null : status.getThrowable(), request, response);
    }

    public ResourceException(Status status, String description) {
        this(new Status(status, description));
    }

    public ResourceException(Status status, String description, Throwable cause) {
        this(new Status(status, cause, null, description), cause);
    }

    public ResourceException(Status status, Throwable cause) {
        this(status, cause, null, null);
    }

    public ResourceException(Status status, Throwable cause, Request request, Response response) {
        super(status == null ? null : status.toString(), cause);
        this.status = status;
        this.request = request;
        this.response = response;
    }

    public ResourceException(Throwable cause) {
        this(new Status(Status.SERVER_ERROR_INTERNAL, cause), cause);
    }

    public Request getRequest() {
        return this.request;
    }

    public Response getResponse() {
        return this.response;
    }

    public Status getStatus() {
        return this.status;
    }
}

