/*
 * Decompiled with CFR 0.152.
 */
package org.cpsolver.studentsct.online.expectations;

import java.util.Set;
import org.cpsolver.ifs.assignment.Assignment;
import org.cpsolver.ifs.util.DataProperties;
import org.cpsolver.studentsct.model.Enrollment;
import org.cpsolver.studentsct.model.Request;
import org.cpsolver.studentsct.model.Section;
import org.cpsolver.studentsct.online.expectations.OverExpectedCriterion;

public class MinimizeConflicts
implements OverExpectedCriterion,
OverExpectedCriterion.HasContext {
    private boolean iTimeConflicts = true;
    private boolean iSpaceConflicts = true;
    private OverExpectedCriterion iParent;
    private double iParentWeight = 0.5;

    public MinimizeConflicts(DataProperties config) {
        this(config, null);
    }

    public MinimizeConflicts(DataProperties config, OverExpectedCriterion parent) {
        this.iParent = parent;
        this.iTimeConflicts = config.getPropertyBoolean("OverExpected.TimeConflicts", this.iTimeConflicts);
        this.iSpaceConflicts = config.getPropertyBoolean("OverExpected.SpaceConflicts", this.iSpaceConflicts);
        this.iParentWeight = config.getPropertyDouble("OverExpected.ParentWeight", this.iParentWeight);
    }

    @Override
    public double getOverExpected(Assignment<Request, Enrollment> assignment, Section section, Request request) {
        double penalty = 0.0;
        if (this.iSpaceConflicts && section.getLimit() == 0) {
            penalty += 1.0;
        }
        if (this.iTimeConflicts && !section.isAllowOverlap()) {
            for (Request r : request.getStudent().getRequests()) {
                if (request.equals(r)) break;
                Enrollment e = assignment.getValue(r);
                if (e == null || !e.isCourseRequest() || !section.isOverlapping(e.getAssignments())) continue;
                penalty += 1.0;
            }
        }
        if (penalty > 0.0) {
            return penalty / (double)section.getSubpart().getConfig().getSubparts().size();
        }
        return this.iParent == null ? 0.0 : this.iParentWeight * this.iParent.getOverExpected(assignment, section, request);
    }

    @Override
    public Integer getExpected(int sectionLimit, double expectedSpace) {
        return this.iParent == null ? null : this.iParent.getExpected(sectionLimit, expectedSpace);
    }

    public String toString() {
        return "min-conflict" + (this.iParent == null ? "" : "/" + this.iParent);
    }

    @Override
    public double getOverExpected(Assignment<Request, Enrollment> assignment, Enrollment selection, Enrollment value, Set<Enrollment> conflicts) {
        if (selection == null || !selection.isCourseRequest()) {
            return 0.0;
        }
        double penalty = 0.0;
        if (this.iSpaceConflicts) {
            for (Section section : selection.getSections()) {
                if (section.getLimit() != 0) continue;
                penalty += 1.0 / (double)selection.getSections().size();
            }
        }
        Request request = selection.getRequest();
        if (this.iTimeConflicts && !request.equals(value.getRequest())) {
            for (Section section : selection.getSections()) {
                if (section.isAllowOverlap()) continue;
                for (Request r : request.getStudent().getRequests()) {
                    if (request.equals(r)) break;
                    Enrollment e = ((Request)value.variable()).equals(r) ? value : assignment.getValue(r);
                    if (e == null || !e.isCourseRequest() || conflicts != null && conflicts.contains(e) || !section.isOverlapping(e.getAssignments())) continue;
                    penalty += 1.0 / (double)selection.getSections().size();
                }
            }
        }
        if (this.iTimeConflicts && request.getPriority() < value.getRequest().getPriority() && value.isCourseRequest()) {
            for (Section section : value.getSections()) {
                if (section.isAllowOverlap() || !section.isOverlapping(selection.getSections())) continue;
                penalty += 1.0 / (double)value.getSections().size();
            }
        }
        if (penalty > 0.0) {
            return penalty;
        }
        if (this.iParent == null) {
            return 0.0;
        }
        for (Section section : selection.getSections()) {
            penalty += this.iParentWeight * this.iParent.getOverExpected(assignment, section, request);
        }
        return penalty;
    }

    @Override
    public double getOverExpected(Assignment<Request, Enrollment> assignment, Enrollment[] enrollment, int index, Section section, Request request) {
        double penalty = 0.0;
        if (this.iSpaceConflicts && section.getLimit() == 0) {
            penalty += 1.0;
        }
        if (this.iTimeConflicts && !section.isAllowOverlap()) {
            for (int i = 0; i < index; ++i) {
                if (enrollment[i] == null || enrollment[i].getSections() == null || !enrollment[i].isCourseRequest() || !section.isOverlapping(enrollment[i].getSections())) continue;
                penalty += 1.0;
            }
        }
        if (penalty > 0.0) {
            return penalty / (double)section.getSubpart().getConfig().getSubparts().size();
        }
        return this.iParent == null ? 0.0 : this.iParentWeight * this.iParent.getOverExpected(assignment, section, request);
    }
}

