/*
 * Decompiled with CFR 0.152.
 */
package org.cpsolver.studentsct.online.expectations;

import org.cpsolver.ifs.assignment.Assignment;
import org.cpsolver.ifs.util.DataProperties;
import org.cpsolver.studentsct.model.Enrollment;
import org.cpsolver.studentsct.model.Request;
import org.cpsolver.studentsct.model.Section;
import org.cpsolver.studentsct.online.expectations.PercentageOverExpected;

public class FractionallyOverExpected
extends PercentageOverExpected {
    private Double iMaximum = null;

    public FractionallyOverExpected(DataProperties config) {
        super(config);
        this.iMaximum = config.getPropertyDouble("OverExpected.Maximum", this.iMaximum);
    }

    public FractionallyOverExpected(Double percentage, Double maximum) {
        super(percentage);
        this.iMaximum = maximum;
    }

    public FractionallyOverExpected(Double percentage) {
        this(percentage, 1.0);
    }

    public FractionallyOverExpected() {
        this(null, 1.0);
    }

    public Double getMaximum() {
        return this.iMaximum;
    }

    public double getMaximum(Section section) {
        return this.iMaximum == null || this.iMaximum <= 0.0 ? (double)this.getLimit(section) : this.iMaximum;
    }

    @Override
    public double getOverExpected(Assignment<Request, Enrollment> assignment, Section section, Request request) {
        if (section.getLimit() <= 0) {
            return 0.0;
        }
        double expected = this.round(this.getPercentage() * section.getSpaceExpected());
        double enrolled = this.getEnrollment(assignment, section, request) + request.getWeight();
        double limit = this.getLimit(section);
        int subparts = section.getSubpart().getConfig().getSubparts().size();
        double max = this.getMaximum(section);
        return expected + enrolled > limit ? Math.min(max, expected + enrolled - limit) / max / (double)subparts : 0.0;
    }

    @Override
    public String toString() {
        return "frac(" + this.getPercentage() + "," + this.getMaximum() + ")";
    }
}

