/*
 * Decompiled with CFR 0.152.
 */
package org.cpsolver.studentsct.heuristics.selection;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.Queue;
import org.cpsolver.ifs.assignment.Assignment;
import org.cpsolver.ifs.heuristics.ValueSelection;
import org.cpsolver.ifs.heuristics.VariableSelection;
import org.cpsolver.ifs.solution.Solution;
import org.cpsolver.ifs.solver.Solver;
import org.cpsolver.ifs.util.DataProperties;
import org.cpsolver.studentsct.filter.StudentFilter;
import org.cpsolver.studentsct.heuristics.selection.StandardSelection;
import org.cpsolver.studentsct.heuristics.selection.UnassignedRequestSelection;
import org.cpsolver.studentsct.model.Enrollment;
import org.cpsolver.studentsct.model.Request;

public class CriticalStandardSelection
extends StandardSelection {
    private Request.RequestPriority iPriority;
    private boolean iAllowCriticalUnassignment = false;

    public CriticalStandardSelection(DataProperties properties, VariableSelection<Request, Enrollment> variableSelection, ValueSelection<Request, Enrollment> valueSelection, Request.RequestPriority priority) {
        super(properties, variableSelection, valueSelection);
        this.iPriority = priority;
        this.iAllowCriticalUnassignment = properties.getPropertyBoolean("Neighbour.AllowCriticalUnassignment", this.iAllowCriticalUnassignment);
        this.iCanWorsen = properties.getPropertyBoolean("Neighbour.CriticalStandardCanWorsen", false);
    }

    public CriticalStandardSelection(DataProperties properties, ValueSelection<Request, Enrollment> valueSelection, Request.RequestPriority priority) {
        this(properties, new UnassignedCriticalCourseRequestSelection(priority), valueSelection, priority);
    }

    public CriticalStandardSelection(DataProperties properties, ValueSelection<Request, Enrollment> valueSelection) {
        this(properties, valueSelection, Request.RequestPriority.Critical);
    }

    @Override
    public void init(Solver<Request, Enrollment> solver) {
        StudentFilter filter = null;
        if (this.iVariableSelection instanceof UnassignedRequestSelection) {
            filter = ((UnassignedRequestSelection)this.iVariableSelection).getFilter();
        }
        this.init(solver, this.iPriority.name() + " Ifs" + (filter == null ? "" : " (" + filter.getName().toLowerCase() + " students)") + "...");
    }

    @Override
    public boolean canUnassign(Enrollment enrollment, Enrollment conflict, Assignment<Request, Enrollment> assignment) {
        if (!this.iAllowCriticalUnassignment) {
            return super.canUnassign(enrollment, conflict, assignment);
        }
        if (!this.iCanConflict) {
            return false;
        }
        if (!this.iCanHigherPriorityConflict && conflict.getRequest().getPriority() < enrollment.getRequest().getPriority()) {
            return false;
        }
        if (conflict.getRequest().isMPP() && conflict.equals(conflict.getRequest().getInitialAssignment())) {
            return false;
        }
        return !this.iPreferPriorityStudents && !conflict.getRequest().getRequestPriority().isSame(enrollment.getRequest()) || !conflict.getStudent().getPriority().isHigher(enrollment.getStudent());
    }

    static class UnassignedCriticalCourseRequestSelection
    implements VariableSelection<Request, Enrollment> {
        protected int iNrRounds = 0;
        protected Queue<Request> iRequests = null;
        private Request.RequestPriority iPriority;

        public UnassignedCriticalCourseRequestSelection(Request.RequestPriority priority) {
            this.iPriority = priority;
        }

        @Override
        public void init(Solver<Request, Enrollment> solver) {
            this.iRequests = new LinkedList<Request>();
            this.iNrRounds = solver.getProperties().getPropertyInt("Neighbour.CriticalRounds", 10);
        }

        @Override
        public Request selectVariable(Solution<Request, Enrollment> solution) {
            return this.nextRequest(solution);
        }

        protected synchronized Request nextRequest(Solution<Request, Enrollment> solution) {
            if (this.iRequests.isEmpty() && this.iNrRounds > 0) {
                --this.iNrRounds;
                ArrayList<Request> variables = new ArrayList<Request>();
                for (Request r : solution.getModel().unassignedVariables(solution.getAssignment())) {
                    if (!this.iPriority.isCritical(r)) continue;
                    variables.add(r);
                }
                Collections.shuffle(variables);
                this.iRequests.addAll(variables);
            }
            return this.iRequests.poll();
        }
    }
}

