/*
 * Decompiled with CFR 0.152.
 */
package org.cpsolver.studentsct.constraint;

import java.util.ArrayList;
import java.util.Set;
import org.cpsolver.ifs.assignment.Assignment;
import org.cpsolver.ifs.model.GlobalConstraint;
import org.cpsolver.studentsct.constraint.LinkedSections;
import org.cpsolver.studentsct.model.Course;
import org.cpsolver.studentsct.model.Enrollment;
import org.cpsolver.studentsct.model.Request;
import org.cpsolver.studentsct.model.Student;

public class DependentCourses
extends GlobalConstraint<Request, Enrollment> {
    @Override
    public void computeConflicts(Assignment<Request, Enrollment> assignment, Enrollment value, Set<Enrollment> conflicts) {
        if (value != null && value.getCourse() != null) {
            Enrollment original;
            Course parent = value.getCourse().getParent();
            if (parent != null && !value.getAssignments().isEmpty()) {
                for (Request request : value.getStudent().getRequests()) {
                    if (!request.hasCourse(parent)) continue;
                    if (request.equals(value.variable())) {
                        conflicts.add(value);
                        break;
                    }
                    Enrollment enrollment = assignment.getValue(request);
                    if (enrollment != null && enrollment.getCourse() != null && parent.equals(enrollment.getCourse())) continue;
                    conflicts.add(value);
                    break;
                }
            }
            if ((original = assignment.getValue((Request)value.variable())) != null && original.getCourse() != null && original.getCourse().hasChildren() && !original.getCourse().equals(value.getCourse())) {
                for (Request r : original.getStudent().getRequests()) {
                    Enrollment e = assignment.getValue(r);
                    Course p = e == null || e.getCourse() == null ? null : e.getCourse().getParent();
                    if (p == null || !original.getCourse().equals(p)) continue;
                    conflicts.add(e);
                }
            }
        }
        if (!conflicts.contains(value)) {
            ArrayList<Enrollment> additionalConflicts = null;
            for (Enrollment enrollment : conflicts) {
                if (enrollment == null || enrollment.getCourse() == null || !enrollment.getCourse().hasChildren()) continue;
                for (Request r : enrollment.getStudent().getRequests()) {
                    Course p;
                    Enrollment e = assignment.getValue(r);
                    if (r.equals(value.getRequest())) {
                        e = value;
                    }
                    if ((p = e == null || e.getCourse() == null ? null : e.getCourse().getParent()) == null || !enrollment.getCourse().equals(p)) continue;
                    if (additionalConflicts == null) {
                        additionalConflicts = new ArrayList<Enrollment>();
                    }
                    additionalConflicts.add(e);
                }
            }
            if (additionalConflicts != null) {
                conflicts.addAll(additionalConflicts);
            }
        }
    }

    @Override
    public boolean inConflict(Assignment<Request, Enrollment> assignment, Enrollment value) {
        Enrollment original;
        if (value == null || value.getCourse() == null) {
            return false;
        }
        Course parent = value.getCourse().getParent();
        if (parent != null) {
            for (Request request : value.getStudent().getRequests()) {
                if (!request.hasCourse(parent)) continue;
                if (request.equals(value.variable())) {
                    return true;
                }
                Enrollment enrollment = assignment.getValue(request);
                if (enrollment != null && enrollment.getCourse() != null && parent.equals(enrollment.getCourse())) continue;
                return true;
            }
        }
        if ((original = assignment.getValue((Request)value.variable())) != null && original.getCourse() != null && original.getCourse().hasChildren() && !original.getCourse().equals(value.getCourse())) {
            for (Request r : original.getStudent().getRequests()) {
                Enrollment e = assignment.getValue(r);
                Course p = e == null || e.getCourse() == null ? null : e.getCourse().getParent();
                if (p == null || !original.getCourse().equals(p)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isPartialScheduleInConflict(Student student, LinkedSections.EnrollmentAssignment assignment, int index) {
        Enrollment otherEnrollment;
        Request other;
        int j;
        Course parent;
        Request request = student.getRequests().get(index);
        Enrollment enrollment = assignment.getEnrollment(request, index);
        Course course = parent = enrollment == null || enrollment.getCourse() == null ? null : enrollment.getCourse().getParent();
        if (parent != null) {
            for (j = 0; j <= index; ++j) {
                other = student.getRequests().get(j);
                if (!other.hasCourse(parent) || (otherEnrollment = assignment.getEnrollment(request, j)) != null && otherEnrollment.getCourse() != null && parent.equals(otherEnrollment.getCourse())) continue;
                return true;
            }
        }
        if (request.hasChildren()) {
            for (j = 0; j <= index; ++j) {
                Course otherParent;
                other = student.getRequests().get(j);
                otherEnrollment = assignment.getEnrollment(other, j);
                Course course2 = otherParent = otherEnrollment == null || otherEnrollment.getCourse() == null ? null : otherEnrollment.getCourse().getParent();
                if (otherParent == null || !request.hasCourse(otherParent) || enrollment != null && otherParent.equals(enrollment.getCourse())) continue;
                return true;
            }
        }
        return false;
    }

    public boolean canLeaveUnassigned(Student student, LinkedSections.EnrollmentAssignment assignment, Request parentRequest) {
        Request request;
        if (!parentRequest.hasChildren()) {
            return true;
        }
        for (int i = 0; i < student.getRequests().size() && !parentRequest.equals(request = student.getRequests().get(i)); ++i) {
            Course parent;
            Enrollment enrollment = assignment.getEnrollment(request, i);
            Course course = parent = enrollment == null || enrollment.getCourse() == null ? null : enrollment.getCourse().getParent();
            if (parent == null || !parentRequest.hasCourse(parent)) continue;
            return false;
        }
        return true;
    }
}

