/*
 * Decompiled with CFR 0.152.
 */
package org.cpsolver.instructor.model;

import java.util.Collection;
import org.cpsolver.coursett.Constants;
import org.cpsolver.coursett.model.TimeLocation;

public class Section {
    private Long iId;
    private String iExternalId;
    private String iType;
    private String iName;
    private TimeLocation iTime;
    private String iRoom;
    private boolean iAllowOverlap;
    private boolean iCommon;

    public Section(long id, String externalId, String type, String name, TimeLocation time, String room, boolean allowOverlap, boolean common) {
        this.iId = id;
        this.iExternalId = externalId;
        this.iType = type;
        this.iName = name;
        this.iTime = time;
        this.iRoom = room;
        this.iAllowOverlap = allowOverlap;
        this.iCommon = common;
    }

    public Long getSectionId() {
        return this.iId;
    }

    public String getExternalId() {
        return this.iExternalId;
    }

    public String getSectionType() {
        return this.iType;
    }

    public boolean hasSectionType() {
        return this.iType != null && !this.iType.isEmpty();
    }

    public String getSectionName() {
        return this.iName;
    }

    public TimeLocation getTime() {
        return this.iTime;
    }

    public boolean hasTime() {
        return this.getTime() != null && this.getTime().getDayCode() != 0;
    }

    public String getRoom() {
        return this.iRoom;
    }

    public boolean hasRoom() {
        return this.iRoom != null && !this.iRoom.isEmpty();
    }

    public boolean isAllowOverlap() {
        return this.iAllowOverlap;
    }

    public boolean isCommon() {
        return this.iCommon;
    }

    public boolean isOverlapping(Section section) {
        if (this.isAllowOverlap() || section.isAllowOverlap()) {
            return false;
        }
        if (this.getTime() == null || section.getTime() == null) {
            return false;
        }
        return this.getTime().hasIntersection(section.getTime());
    }

    public boolean isOverlapping(Collection<Section> sections) {
        if (this.isAllowOverlap()) {
            return false;
        }
        if (this.getTime() == null) {
            return false;
        }
        if (sections.contains(this)) {
            return false;
        }
        for (Section section : sections) {
            if (section.isAllowOverlap() || section.getTime() == null || !this.getTime().hasIntersection(section.getTime())) continue;
            return true;
        }
        return false;
    }

    public boolean isBackToBack(Section section) {
        if (this.getTime() == null || section.getTime() == null) {
            return false;
        }
        return this.getTime().shareWeeks(section.getTime()) && this.getTime().shareDays(section.getTime()) && (this.getTime().getStartSlot() + this.getTime().getLength() == section.getTime().getStartSlot() || section.getTime().getStartSlot() + section.getTime().getLength() == this.getTime().getStartSlot());
    }

    public double percSameDays(Section section) {
        if (this.getTime() == null || section.getTime() == null) {
            return 0.0;
        }
        double ret = 0.0;
        for (int dayCode : Constants.DAY_CODES) {
            if ((this.getTime().getDayCode() & dayCode) == 0 || (section.getTime().getDayCode() & dayCode) == 0) continue;
            ret += 1.0;
        }
        return ret / (double)Math.min(this.getTime().getNrMeetings(), section.getTime().getNrMeetings());
    }

    public boolean isSameRoom(Section section) {
        return this.hasRoom() == section.hasRoom() && (!this.hasRoom() || this.getRoom().equals(section.getRoom()));
    }

    public boolean isSameSectionType(Section section) {
        return this.hasSectionType() == section.hasSectionType() && (!this.hasSectionType() || this.getSectionType().equals(section.getSectionType()));
    }

    public double countBackToBacks(Collection<Section> sections, double diffRoomWeight, double diffTypeWeight) {
        if (sections.contains(this)) {
            return 0.0;
        }
        double btb = 0.0;
        for (Section section : sections) {
            if (!this.isBackToBack(section)) continue;
            double w = 1.0;
            if (!this.isSameRoom(section)) {
                w *= diffRoomWeight;
            }
            if (!this.isSameSectionType(section)) {
                w *= diffTypeWeight;
            }
            if (!(w > btb)) continue;
            btb = w;
        }
        return btb;
    }

    public double countSameDays(Collection<Section> sections, double diffRoomWeight, double diffTypeWeight) {
        if (sections.contains(this)) {
            return 0.0;
        }
        double sd = 0.0;
        for (Section section : sections) {
            double w = this.percSameDays(section);
            if (!this.isSameRoom(section)) {
                w *= diffRoomWeight;
            }
            if (!this.isSameSectionType(section)) {
                w *= diffTypeWeight;
            }
            if (!(w > sd)) continue;
            sd = w;
        }
        return sd;
    }

    public double countSameRooms(Collection<Section> sections, double diffTypeWeight) {
        if (sections.contains(this)) {
            return 0.0;
        }
        double sr = 0.0;
        for (Section section : sections) {
            if (!this.isSameRoom(section)) continue;
            double w = 1.0;
            if (!this.isSameSectionType(section)) {
                w *= diffTypeWeight;
            }
            if (!(w > sr)) continue;
            sr = w;
        }
        return sr;
    }

    public int share(Section section) {
        if (this.getTime() != null && section.getTime() != null && (this.isAllowOverlap() || section.isAllowOverlap()) && this.getTime().hasIntersection(section.getTime())) {
            return this.getTime().nrSharedDays(section.getTime()) * this.getTime().nrSharedHours(section.getTime());
        }
        return 0;
    }

    public int share(TimeLocation time) {
        if (this.getTime() != null && time != null && this.getTime().hasIntersection(time)) {
            return this.getTime().nrSharedDays(time) * this.getTime().nrSharedHours(time);
        }
        return 0;
    }

    public int share(Collection<Section> sections) {
        if (sections.contains(this)) {
            return 0;
        }
        int ret = 0;
        for (Section section : sections) {
            ret += this.share(section);
        }
        return ret;
    }

    public String getTimeName(boolean useAmPm) {
        if (this.getTime() == null || this.getTime().getDayCode() == 0) {
            return "-";
        }
        return this.getTime().getDayHeader() + " " + this.getTime().getStartTimeHeader(useAmPm) + " - " + this.getTime().getEndTimeHeader(useAmPm);
    }

    public String toString() {
        return this.getExternalId() != null ? (this.getSectionType() == null ? "" : this.getSectionType() + " ") + this.getExternalId() : (this.getSectionName() != null ? this.getSectionName() : (this.getTime() != null ? this.getTime().getName(true) : "S" + this.getSectionId()));
    }

    public int hashCode() {
        return this.getSectionId().hashCode();
    }

    public boolean equals(Object o) {
        if (o == null || !(o instanceof Section)) {
            return false;
        }
        Section s = (Section)o;
        return this.getSectionId().equals(s.getSectionId());
    }
}

