/*
 * Decompiled with CFR 0.152.
 */
package org.cpsolver.ifs.heuristics;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.cpsolver.ifs.assignment.Assignment;
import org.cpsolver.ifs.assignment.context.AssignmentContext;
import org.cpsolver.ifs.constant.ConstantVariable;
import org.cpsolver.ifs.extension.ConflictStatistics;
import org.cpsolver.ifs.extension.Extension;
import org.cpsolver.ifs.heuristics.StandardNeighbourSelection;
import org.cpsolver.ifs.model.Model;
import org.cpsolver.ifs.model.Neighbour;
import org.cpsolver.ifs.model.Value;
import org.cpsolver.ifs.model.Variable;
import org.cpsolver.ifs.solution.Solution;
import org.cpsolver.ifs.solver.Solver;
import org.cpsolver.ifs.util.DataProperties;
import org.cpsolver.ifs.util.JProf;

public class BacktrackNeighbourSelection<V extends Variable<V, T>, T extends Value<V, T>>
extends StandardNeighbourSelection<V, T> {
    private ConflictStatistics<V, T> iStat = null;
    private static Logger sLog = LogManager.getLogger(BacktrackNeighbourSelection.class);
    private int iTimeout = 5000;
    private int iDepth = 4;
    private int iMaxIters = -1;
    protected BacktrackNeighbourSelectionContext iContext;

    public BacktrackNeighbourSelection(DataProperties properties) throws Exception {
        super(properties);
        this.iTimeout = properties.getPropertyInt("Neighbour.BackTrackTimeout", this.iTimeout);
        this.iDepth = properties.getPropertyInt("Neighbour.BackTrackDepth", this.iDepth);
        this.iMaxIters = properties.getPropertyInt("Neighbour.BackTrackMaxIters", this.iMaxIters);
    }

    @Override
    public void init(Solver<V, T> solver) {
        super.init(solver);
        for (Extension<V, T> extension : solver.getExtensions()) {
            if (!ConflictStatistics.class.isInstance(extension)) continue;
            this.iStat = (ConflictStatistics)extension;
        }
    }

    @Override
    public Neighbour<V, T> selectNeighbour(Solution<V, T> solution) {
        return this.selectNeighbour(solution, this.getVariableSelection().selectVariable(solution));
    }

    public Neighbour<V, T> selectNeighbour(Solution<V, T> solution, V variable) {
        if (variable == null) {
            return null;
        }
        BacktrackNeighbourSelectionContext context = new BacktrackNeighbourSelectionContext(solution);
        this.selectNeighbour(solution, variable, context);
        return context.getBackTrackNeighbour();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void selectNeighbour(Solution<V, T> solution, V variable, BacktrackNeighbourSelectionContext context) {
        this.iContext = context;
        Lock lock = solution.getLock().writeLock();
        lock.lock();
        try {
            if (sLog.isDebugEnabled()) {
                sLog.debug("-- before BT (" + ((Variable)variable).getName() + "): nrAssigned=" + solution.getAssignment().nrAssignedVariables() + ",  value=" + solution.getModel().getTotalValue(solution.getAssignment()));
            }
            ArrayList<V> variables2resolve = new ArrayList<V>(1);
            variables2resolve.add(variable);
            this.backtrack(context, variables2resolve, 0, this.iDepth);
            if (sLog.isDebugEnabled()) {
                sLog.debug("-- after  BT (" + ((Variable)variable).getName() + "): nrAssigned=" + solution.getAssignment().nrAssignedVariables() + ",  value=" + solution.getModel().getTotalValue(solution.getAssignment()));
            }
        }
        finally {
            lock.unlock();
        }
        if (sLog.isDebugEnabled()) {
            sLog.debug("-- selected neighbour: " + context.getBackTrackNeighbour());
        }
    }

    public BacktrackNeighbourSelectionContext getContext() {
        return this.iContext;
    }

    private boolean containsConstantValues(Collection<T> values) {
        for (Value value : values) {
            if (!(value.variable() instanceof ConstantVariable) || !((ConstantVariable)value.variable()).isConstant()) continue;
            return true;
        }
        return false;
    }

    protected Iterator<T> values(BacktrackNeighbourSelectionContext context, V variable) {
        return ((Variable)variable).values(context.getAssignment()).iterator();
    }

    protected boolean checkBound(List<V> variables2resolve, int idx, int depth, T value, Set<T> conflicts) {
        int nrUnassigned = variables2resolve.size() - idx;
        if (nrUnassigned + conflicts.size() > depth) {
            if (sLog.isDebugEnabled()) {
                sLog.debug("        -- too deap");
            }
            return false;
        }
        if (this.containsConstantValues(conflicts)) {
            if (sLog.isDebugEnabled()) {
                sLog.debug("        -- contains constants values");
            }
            return false;
        }
        boolean containAssigned = false;
        Iterator<T> i = conflicts.iterator();
        while (!containAssigned && i.hasNext()) {
            Value conflict = (Value)i.next();
            int confIdx = variables2resolve.indexOf(conflict.variable());
            if (confIdx < 0 || confIdx > idx) continue;
            if (sLog.isDebugEnabled()) {
                sLog.debug("        -- contains resolved variable " + conflict.variable());
            }
            containAssigned = true;
        }
        return !containAssigned;
    }

    protected boolean canContinue(BacktrackNeighbourSelectionContext context, List<V> variables2resolve, int idx, int depth) {
        if (depth <= 0) {
            if (sLog.isDebugEnabled()) {
                sLog.debug("    -- depth reached");
            }
            return false;
        }
        if (context.isTimeoutReached()) {
            if (sLog.isDebugEnabled()) {
                sLog.debug("    -- timeout reached");
            }
            return false;
        }
        if (context.isMaxItersReached()) {
            if (sLog.isDebugEnabled()) {
                sLog.debug("    -- max number of iterations reached");
            }
            return false;
        }
        return true;
    }

    protected boolean canContinueEvaluation(BacktrackNeighbourSelectionContext context) {
        return !context.isMaxItersReached() && !context.isTimeoutReached();
    }

    protected void backtrack(BacktrackNeighbourSelectionContext context, List<V> variables2resolve, int idx, int depth) {
        if (sLog.isDebugEnabled()) {
            sLog.debug("  -- bt[" + depth + "]: " + idx + " of " + variables2resolve.size() + " " + variables2resolve);
        }
        context.incIteration();
        int nrUnassigned = variables2resolve.size() - idx;
        if (nrUnassigned == 0) {
            context.saveBest(variables2resolve);
            return;
        }
        if (!this.canContinue(context, variables2resolve, idx, depth)) {
            return;
        }
        Variable variable = (Variable)variables2resolve.get(idx);
        if (sLog.isDebugEnabled()) {
            sLog.debug("    -- variable " + variable);
        }
        Iterator<T> e = this.values(context, variable);
        while (this.canContinueEvaluation(context) && e.hasNext()) {
            Object current;
            Value value = (Value)e.next();
            if (value.equals(current = context.getAssignment().getValue(variable))) continue;
            if (sLog.isDebugEnabled()) {
                sLog.debug("      -- value " + value);
            }
            Set<Value> conflicts = context.getModel().conflictValues(context.getAssignment(), value);
            if (sLog.isDebugEnabled()) {
                sLog.debug("      -- conflicts " + conflicts);
            }
            if (!this.checkBound(variables2resolve, idx, depth, value, conflicts)) continue;
            ArrayList<V> newVariables2resolve = new ArrayList<V>(variables2resolve);
            for (Value conflict : conflicts) {
                context.getAssignment().unassign(0L, conflict.variable());
                if (newVariables2resolve.contains(conflict.variable())) continue;
                newVariables2resolve.add(conflict.variable());
            }
            if (current != null) {
                context.getAssignment().unassign(0L, ((Value)current).variable());
            }
            context.getAssignment().assign(0L, value);
            this.backtrack(context, newVariables2resolve, idx + 1, depth - 1);
            if (current == null) {
                context.getAssignment().unassign(0L, variable);
            } else {
                context.getAssignment().assign(0L, current);
            }
            for (Value conflict : conflicts) {
                context.getAssignment().assign(0L, conflict);
            }
        }
    }

    public int getDepth() {
        return this.iDepth;
    }

    public void setDepth(int depth) {
        this.iDepth = depth;
    }

    public int getTimeout() {
        return this.iTimeout;
    }

    public void setTimeout(int timeout) {
        this.iTimeout = timeout;
    }

    public int getMaxIters() {
        return this.iMaxIters;
    }

    public void setMaxIters(int maxIters) {
        this.iMaxIters = maxIters;
    }

    public class BacktrackNeighbourSelectionContext
    implements AssignmentContext {
        private long iT0;
        private long iT1 = 0L;
        private boolean iTimeoutReached = false;
        private int iMaxIters = -1;
        private int iNrIters = 0;
        protected Solution<V, T> iSolution = null;
        protected BackTrackNeighbour iBackTrackNeighbour = null;
        protected double iValue = 0.0;
        private int iNrAssigned = 0;
        private boolean iMaxItersReached = false;

        public BacktrackNeighbourSelectionContext(Solution<V, T> solution) {
            this.iSolution = solution;
            this.iBackTrackNeighbour = null;
            this.iValue = solution.getModel().getTotalValue(this.iSolution.getAssignment());
            this.iNrAssigned = this.iSolution.getAssignment().nrAssignedVariables();
            this.iT0 = JProf.currentTimeMillis();
            this.iNrIters = 0;
            this.iTimeoutReached = false;
            this.iMaxItersReached = false;
        }

        public long getTime() {
            if (this.iT1 == 0L) {
                return JProf.currentTimeMillis() - this.iT0;
            }
            return this.iT1 - this.iT0;
        }

        public boolean isTimeoutReached() {
            return this.iTimeoutReached;
        }

        public boolean isMaxItersReached() {
            return this.iMaxItersReached;
        }

        public BackTrackNeighbour getBackTrackNeighbour() {
            return this.iBackTrackNeighbour;
        }

        public void incIteration() {
            this.iT1 = JProf.currentTimeMillis();
            if (!this.iTimeoutReached && BacktrackNeighbourSelection.this.iTimeout > 0 && this.iT1 - this.iT0 > (long)BacktrackNeighbourSelection.this.iTimeout) {
                this.iTimeoutReached = true;
            }
            if (!this.iMaxItersReached && this.iMaxIters > 0 && this.iNrIters++ > this.iMaxIters) {
                this.iMaxItersReached = true;
            }
        }

        public void saveBest(List<V> variables2resolve) {
            if (sLog.isDebugEnabled()) {
                sLog.debug("    -- all assigned");
            }
            if (this.iSolution.getAssignment().nrAssignedVariables() > this.iNrAssigned || this.iSolution.getAssignment().nrAssignedVariables() == this.iNrAssigned && this.iValue > this.iSolution.getModel().getTotalValue(this.iSolution.getAssignment())) {
                if (sLog.isDebugEnabled()) {
                    sLog.debug("    -- better than current");
                }
                if (this.iBackTrackNeighbour == null || this.iBackTrackNeighbour.compareTo(this.iSolution) >= 0) {
                    if (sLog.isDebugEnabled()) {
                        sLog.debug("      -- better than best");
                    }
                    this.iBackTrackNeighbour = new BackTrackNeighbour(this, variables2resolve);
                }
            }
        }

        public void saveBest(V ... variables2resolve) {
            if (sLog.isDebugEnabled()) {
                sLog.debug("    -- all assigned");
            }
            if (this.iSolution.getAssignment().nrAssignedVariables() > this.iNrAssigned || this.iSolution.getAssignment().nrAssignedVariables() == this.iNrAssigned && this.iValue > this.iSolution.getModel().getTotalValue(this.iSolution.getAssignment())) {
                if (sLog.isDebugEnabled()) {
                    sLog.debug("    -- better than current");
                }
                if (this.iBackTrackNeighbour == null || this.iBackTrackNeighbour.compareTo(this.iSolution) >= 0) {
                    if (sLog.isDebugEnabled()) {
                        sLog.debug("      -- better than best");
                    }
                    this.iBackTrackNeighbour = new BackTrackNeighbour(BacktrackNeighbourSelection.this, this, variables2resolve);
                }
            }
        }

        public Model<V, T> getModel() {
            return this.iSolution.getModel();
        }

        public Assignment<V, T> getAssignment() {
            return this.iSolution.getAssignment();
        }
    }

    public class BackTrackNeighbour
    implements Neighbour<V, T> {
        private double iTotalValue = 0.0;
        private double iValue = 0.0;
        private List<T> iDifferentAssignments = null;
        private Model<V, T> iModel = null;

        public BackTrackNeighbour(BacktrackNeighbourSelectionContext context, List<V> resolvedVariables) {
            this.iTotalValue = context.getModel().getTotalValue(context.getAssignment());
            this.iDifferentAssignments = new ArrayList();
            for (Variable variable : resolvedVariables) {
                Object value = variable.getAssignment(context.getAssignment());
                this.iDifferentAssignments.add(value);
            }
            this.iValue = this.iTotalValue - context.iValue;
            if (sLog.isDebugEnabled()) {
                this.iModel = context.getModel();
            }
        }

        public BackTrackNeighbour(BacktrackNeighbourSelectionContext context, V ... resolvedVariables) {
            this.iTotalValue = context.getModel().getTotalValue(context.getAssignment());
            this.iDifferentAssignments = new ArrayList();
            for (Object variable : resolvedVariables) {
                Object value = ((Variable)variable).getAssignment(context.getAssignment());
                this.iDifferentAssignments.add(value);
            }
            this.iValue = this.iTotalValue - context.iValue;
            if (sLog.isDebugEnabled()) {
                this.iModel = context.getModel();
            }
        }

        public double getTotalValue() {
            return this.iTotalValue;
        }

        @Override
        public double value(Assignment<V, T> assignment) {
            return this.iValue;
        }

        public List<T> getAssignments() {
            return this.iDifferentAssignments;
        }

        @Override
        public void assign(Assignment<V, T> assignment, long iteration) {
            if (sLog.isDebugEnabled()) {
                sLog.debug("-- before assignment: nrAssigned=" + assignment.nrAssignedVariables() + ",  value=" + this.iModel.getTotalValue(assignment));
            }
            if (sLog.isDebugEnabled()) {
                sLog.debug("  " + this);
            }
            int idx = 0;
            for (Value p : this.iDifferentAssignments) {
                Object o = assignment.getValue(p.variable());
                if (o != null) {
                    if (idx > 0 && BacktrackNeighbourSelection.this.iStat != null) {
                        BacktrackNeighbourSelection.this.iStat.variableUnassigned(iteration, o, (Value)this.iDifferentAssignments.get(0));
                    }
                    assignment.unassign(iteration, p.variable());
                }
                ++idx;
            }
            for (Value p : this.iDifferentAssignments) {
                assignment.assign(iteration, p);
            }
            if (sLog.isDebugEnabled()) {
                sLog.debug("-- after assignment: nrAssigned=" + assignment.nrAssignedVariables() + ",  value=" + this.iModel.getTotalValue(assignment));
            }
        }

        public int compareTo(Solution<V, T> solution) {
            return Double.compare(this.iTotalValue, solution.getModel().getTotalValue(solution.getAssignment()));
        }

        public String toString() {
            StringBuffer sb = new StringBuffer("BT{value=" + this.iTotalValue + ": ");
            Iterator e = this.iDifferentAssignments.iterator();
            while (e.hasNext()) {
                Value p = (Value)e.next();
                sb.append("\n    " + ((Variable)p.variable()).getName() + " " + p.getName() + (e.hasNext() ? "," : ""));
            }
            sb.append("}");
            return sb.toString();
        }

        @Override
        public Map<V, T> assignments() {
            HashMap ret = new HashMap();
            for (Value p : this.iDifferentAssignments) {
                ret.put(p.variable(), p);
            }
            return ret;
        }
    }
}

