/*
 * Decompiled with CFR 0.152.
 */
package org.cpsolver.ifs.example.csp;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import org.cpsolver.ifs.example.csp.CSPValue;
import org.cpsolver.ifs.model.Variable;

public class CSPVariable
extends Variable<CSPVariable, CSPValue> {
    private int iKernelId = -1;

    public CSPVariable(int id, int domainSize) {
        this(id, domainSize, -1);
    }

    public CSPVariable(int id, int domainSize, int kernelId) {
        super(null);
        this.iId = id;
        this.iKernelId = kernelId;
        this.setValues(this.computeValues(domainSize));
    }

    public int getKernelId() {
        return this.iKernelId;
    }

    public void generateInitialValue(Random rnd) {
        CSPValue aValue = (CSPValue)this.values(null).get((int)(rnd.nextFloat() * (float)this.values(null).size()));
        this.setInitialAssignment(aValue);
    }

    private List<CSPValue> computeValues(int domainSize) {
        ArrayList<CSPValue> values = new ArrayList<CSPValue>();
        for (int i = 0; i < domainSize; ++i) {
            CSPValue value = new CSPValue(this, i);
            values.add(value);
        }
        return values;
    }

    @Override
    public String getName() {
        return "V" + this.getId();
    }
}

