/*
 * Decompiled with CFR 0.152.
 */
package org.cpsolver.ifs.assignment.context;

import org.cpsolver.ifs.assignment.Assignment;
import org.cpsolver.ifs.assignment.InheritedAssignment;
import org.cpsolver.ifs.assignment.context.AssignmentContext;
import org.cpsolver.ifs.assignment.context.AssignmentContextReference;
import org.cpsolver.ifs.assignment.context.CanHoldContext;
import org.cpsolver.ifs.assignment.context.CanInheritContext;
import org.cpsolver.ifs.assignment.context.DefaultParallelAssignmentContextHolder;
import org.cpsolver.ifs.model.Value;
import org.cpsolver.ifs.model.Variable;

public class InheritedAssignmentContextHolder<V extends Variable<V, T>, T extends Value<V, T>>
extends DefaultParallelAssignmentContextHolder<V, T> {
    private long iVersion;

    public InheritedAssignmentContextHolder(int index, long version) {
        super(index);
        this.iVersion = version;
    }

    @Override
    public <U extends AssignmentContext> U getAssignmentContext(Assignment<V, T> assignment, AssignmentContextReference<V, T, U> reference) {
        if (this.iIndex >= 0 && this.iIndex < 17 && reference.getParent() instanceof CanHoldContext) {
            AssignmentContext[] contexts = ((CanHoldContext)((Object)reference.getParent())).getContext();
            VersionedContext<U> context = (VersionedContext<U>)contexts[this.iIndex];
            if (context == null) {
                context = new VersionedContext<U>();
                if (reference.getParent() instanceof CanInheritContext) {
                    context.setContent(((CanInheritContext)((Object)reference.getParent())).inheritAssignmentContext(assignment, ((InheritedAssignment)assignment).getParentAssignment().getAssignmentContext(reference)), this.iVersion);
                } else {
                    context.setContent(reference.getParent().createAssignmentContext(assignment), this.iVersion);
                }
                contexts[this.iIndex] = context;
            } else if (!context.isCurrent(this.iVersion)) {
                if (reference.getParent() instanceof CanInheritContext) {
                    context.setContent(((CanInheritContext)((Object)reference.getParent())).inheritAssignmentContext(assignment, ((InheritedAssignment)assignment).getParentAssignment().getAssignmentContext(reference)), this.iVersion);
                } else {
                    context.setContent(reference.getParent().createAssignmentContext(assignment), this.iVersion);
                }
            }
            return context.getContent();
        }
        AssignmentContext context = (AssignmentContext)this.iContexts.get(reference.getIndex());
        if (context != null) {
            return (U)context;
        }
        context = reference.getParent() instanceof CanInheritContext ? ((CanInheritContext)((Object)reference.getParent())).inheritAssignmentContext(assignment, ((InheritedAssignment)assignment).getParentAssignment().getAssignmentContext(reference)) : reference.getParent().createAssignmentContext(assignment);
        this.iContexts.put(reference.getIndex(), context);
        return (U)context;
    }

    public static class VersionedContext<U extends AssignmentContext>
    implements AssignmentContext {
        U iContent = null;
        long iContentVersion = -1L;

        VersionedContext() {
        }

        public U getContent() {
            return this.iContent;
        }

        public void setContent(U content, long version) {
            this.iContent = content;
            this.iContentVersion = version;
        }

        public boolean isCurrent(long version) {
            return this.iContentVersion == version;
        }
    }
}

