/*
 * Decompiled with CFR 0.152.
 */
package org.cpsolver.ifs.assignment;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.cpsolver.ifs.assignment.Assignment;
import org.cpsolver.ifs.assignment.AssignmentAbstract;
import org.cpsolver.ifs.assignment.InheritedAssignment;
import org.cpsolver.ifs.assignment.context.InheritedAssignmentContextHolder;
import org.cpsolver.ifs.model.Value;
import org.cpsolver.ifs.model.Variable;
import org.cpsolver.ifs.solution.Solution;

public class OptimisticInheritedAssignment<V extends Variable<V, T>, T extends Value<V, T>>
extends AssignmentAbstract<V, T>
implements InheritedAssignment<V, T> {
    private Assignment<V, T> iParent;
    private Map<V, T> iAssignments = new LinkedHashMap<V, T>();
    private Set<V> iDirty = new HashSet<V>();
    private Map<V, Long> iIteration = new HashMap<V, Long>();
    private long iVersion = -1L;

    public OptimisticInheritedAssignment(Solution<V, T> parent, int index) {
        super(new InheritedAssignmentContextHolder(index, parent.getIteration()));
        this.iParent = parent.getAssignment();
        this.iVersion = parent.getIteration();
    }

    @Override
    public long getIteration(V variable) {
        Long it = this.iIteration.get(variable);
        return it != null ? it : (this.iDirty.contains(variable) ? 0L : this.iParent.getIteration(variable));
    }

    @Override
    public Collection<V> assignedVariables() {
        HashSet<V> variables = new HashSet<V>(this.iParent.assignedVariables());
        variables.removeAll(this.iDirty);
        variables.addAll(this.iAssignments.keySet());
        return variables;
    }

    @Override
    public Collection<T> assignedValues() {
        HashSet values = new HashSet();
        for (Value val : this.iParent.assignedValues()) {
            if (val == null || this.iDirty.contains(val.variable())) continue;
            values.add(val);
        }
        values.addAll(this.iAssignments.values());
        return values;
    }

    @Override
    public int nrAssignedVariables() {
        return this.iAssignments.size() + this.iParent.nrAssignedVariables() - this.iDirty.size();
    }

    @Override
    protected T getValueInternal(V variable) {
        Value value;
        Value value2 = value = this.iAssignments.isEmpty() ? null : (Value)this.iAssignments.get(variable);
        return (T)(value != null ? value : (this.iDirty.contains(variable) ? null : this.iParent.getValue(variable)));
    }

    @Override
    protected void setValueInternal(long iteration, V variable, T value) {
        if (value == null) {
            this.iAssignments.remove(variable);
            this.iIteration.remove(variable);
            if (this.iParent.getValue(variable) != null) {
                this.iDirty.add(variable);
            }
        } else {
            this.iAssignments.put(variable, value);
            if (iteration > 0L) {
                this.iIteration.put((Long)variable, iteration);
            }
            this.iDirty.remove(variable);
        }
    }

    @Override
    public Assignment<V, T> getParentAssignment() {
        return this.iParent;
    }

    @Override
    public long getVersion() {
        return this.iVersion;
    }

    public String toString() {
        String ret = "OptAssignment{";
        for (Map.Entry<V, T> e : this.iAssignments.entrySet()) {
            T v = this.iParent.getValue((Variable)e.getKey());
            if (((Value)e.getValue()).equals(v)) continue;
            ret = ret + "\n  " + e.getKey() + " := " + e.getValue() + "\n    -- original " + (v == null ? "not-assigned" : v);
        }
        for (Variable v : this.iDirty) {
            ret = ret + "\n  " + v + " := not-assigned\n    -- original " + this.iParent.getValue(v);
        }
        return ret + "}";
    }
}

