/*
 * Decompiled with CFR 0.152.
 */
package org.cpsolver.ifs.algorithms;

import java.text.DecimalFormat;
import org.cpsolver.ifs.algorithms.NeighbourSearch;
import org.cpsolver.ifs.assignment.Assignment;
import org.cpsolver.ifs.model.Model;
import org.cpsolver.ifs.model.Neighbour;
import org.cpsolver.ifs.model.Value;
import org.cpsolver.ifs.model.Variable;
import org.cpsolver.ifs.solution.Solution;
import org.cpsolver.ifs.util.DataProperties;
import org.cpsolver.ifs.util.JProf;

public class GreatDeluge<V extends Variable<V, T>, T extends Value<V, T>>
extends NeighbourSearch<V, T> {
    private DecimalFormat sDF2 = new DecimalFormat("0.00");
    private DecimalFormat sDF5 = new DecimalFormat("0.00000");
    private double iCoolRate = 0.9999999;
    private double iUpperBoundRate = 1.05;
    private double iLowerBoundRate = 0.95;
    private Double[] iCoolRateAdjusts = null;

    public GreatDeluge(DataProperties properties) {
        super(properties);
        this.iCoolRate = properties.getPropertyDouble(this.getParameterBaseName() + ".CoolRate", this.iCoolRate);
        this.iUpperBoundRate = properties.getPropertyDouble(this.getParameterBaseName() + ".UpperBoundRate", this.iUpperBoundRate);
        this.iLowerBoundRate = properties.getPropertyDouble(this.getParameterBaseName() + ".LowerBoundRate", this.iLowerBoundRate);
        this.iCoolRateAdjusts = properties.getPropertyDoubleArry(this.getParameterBaseName() + ".CoolRateAdjustments", null);
    }

    @Override
    public String getParameterBaseName() {
        return "GreatDeluge";
    }

    @Override
    public NeighbourSearch.NeighbourSearchContext createAssignmentContext(Assignment<V, T> assignment) {
        return new GreatDelugeContext();
    }

    public class GreatDelugeContext
    extends NeighbourSearch.NeighbourSearchContext {
        private int iMoves = 0;
        private int iAcceptedMoves = 0;
        private int iNrIdle = 0;
        private long iLastImprovingIter = 0L;
        private double iBestValue = 0.0;
        private double iBound = 0.0;
        private double iUpperBound;

        @Override
        protected boolean accept(Assignment<V, T> assignment, Model<V, T> model, Neighbour<V, T> neighbour, double value, boolean lazy) {
            block3: {
                block2: {
                    ++this.iMoves;
                    if (value <= 0.0) break block2;
                    double d = lazy ? model.getTotalValue(assignment) : value + model.getTotalValue(assignment);
                    if (!(d < this.iBound)) break block3;
                }
                ++this.iAcceptedMoves;
                return true;
            }
            return false;
        }

        @Override
        protected void activate(Solution<V, T> solution) {
            super.activate(solution);
            this.iNrIdle = 0;
            this.iLastImprovingIter = 0L;
            this.iUpperBound = this.iBound = solution.getBestValue() > 0.0 ? GreatDeluge.this.iUpperBoundRate * solution.getBestValue() : solution.getBestValue() / GreatDeluge.this.iUpperBoundRate;
        }

        protected double getCoolRate(int idx) {
            if (idx < 0 || GreatDeluge.this.iCoolRateAdjusts == null || idx >= GreatDeluge.this.iCoolRateAdjusts.length || GreatDeluge.this.iCoolRateAdjusts[idx] == null) {
                return GreatDeluge.this.iCoolRate;
            }
            return GreatDeluge.this.iCoolRate * GreatDeluge.this.iCoolRateAdjusts[idx];
        }

        @Override
        protected void incIteration(Solution<V, T> solution) {
            super.incIteration(solution);
            this.iBound = solution.getBestValue() >= 0.0 ? (this.iBound *= this.getCoolRate(solution.getAssignment().getIndex() - 1)) : (this.iBound /= this.getCoolRate(solution.getAssignment().getIndex() - 1));
            if (this.iIter % 10000 == 0) {
                GreatDeluge.this.info("Iter=" + this.iIter / 1000 + "k, NonImpIter=" + GreatDeluge.this.sDF2.format((double)((long)this.iIter - this.iLastImprovingIter) / 1000.0) + "k, Speed=" + GreatDeluge.this.sDF2.format(1000.0 * (double)this.iIter / (double)(JProf.currentTimeMillis() - this.iT0)) + " it/s");
                GreatDeluge.this.info("Bound is " + GreatDeluge.this.sDF2.format(this.iBound) + ", best value is " + GreatDeluge.this.sDF2.format(solution.getBestValue()) + " (" + GreatDeluge.this.sDF2.format(100.0 * this.iBound / solution.getBestValue()) + "%), current value is " + GreatDeluge.this.sDF2.format(solution.getModel().getTotalValue(solution.getAssignment())) + " (" + GreatDeluge.this.sDF2.format(100.0 * this.iBound / solution.getModel().getTotalValue(solution.getAssignment())) + "%), #idle=" + this.iNrIdle + ", Pacc=" + GreatDeluge.this.sDF5.format(100.0 * (double)this.iAcceptedMoves / (double)this.iMoves) + "%");
                GreatDeluge.this.logNeibourStatus();
                this.iMoves = 0;
                this.iAcceptedMoves = 0;
            }
            if (GreatDeluge.this.isMaster(solution)) {
                double lowerBound;
                double upperBound = Math.max(solution.getBestValue() + 2.0, solution.getBestValue() >= 0.0 ? Math.pow(GreatDeluge.this.iUpperBoundRate, 1 + this.iNrIdle) * solution.getBestValue() : solution.getBestValue() / Math.pow(GreatDeluge.this.iUpperBoundRate, 1 + this.iNrIdle));
                double d = lowerBound = solution.getBestValue() >= 0.0 ? Math.pow(GreatDeluge.this.iLowerBoundRate, 1 + this.iNrIdle) * solution.getBestValue() : solution.getBestValue() / Math.pow(GreatDeluge.this.iLowerBoundRate, 1 + this.iNrIdle);
                if (this.iBound > upperBound) {
                    this.iBound = upperBound;
                } else if (this.iBound < lowerBound) {
                    ++this.iNrIdle;
                    this.iUpperBound = this.iBound = upperBound;
                    GreatDeluge.this.setProgressPhase("Great Deluge [" + (1 + this.iNrIdle) + "]...");
                }
                GreatDeluge.this.setProgress(100L - Math.round(100.0 * (this.iBound - lowerBound) / (this.iUpperBound - lowerBound)));
            }
            ++this.iMoves;
        }

        @Override
        public void bestSaved(Solution<V, T> solution) {
            super.bestSaved(solution);
            if (Math.abs(this.iBestValue - solution.getBestValue()) >= 1.0) {
                this.iLastImprovingIter = this.iIter;
                this.iNrIdle = 0;
                this.iBestValue = solution.getBestValue();
            }
        }
    }
}

