/*
 * Decompiled with CFR 0.152.
 */
package org.cpsolver.exam.criteria;

import java.util.Map;
import java.util.Set;
import org.cpsolver.exam.criteria.ExamCriterion;
import org.cpsolver.exam.model.Exam;
import org.cpsolver.exam.model.ExamModel;
import org.cpsolver.exam.model.ExamPeriod;
import org.cpsolver.exam.model.ExamPlacement;
import org.cpsolver.exam.model.ExamStudent;
import org.cpsolver.ifs.assignment.Assignment;
import org.cpsolver.ifs.util.DataProperties;

public class StudentDistanceBackToBackConflicts
extends ExamCriterion {
    private double iBackToBackDistance = -1.0;

    @Override
    public void configure(DataProperties properties) {
        super.configure(properties);
        this.iBackToBackDistance = properties.getPropertyDouble("Exams.BackToBackDistance", this.iBackToBackDistance);
    }

    @Override
    public String getWeightName() {
        return "Exams.DistanceBackToBackConflictWeight";
    }

    @Override
    public String getXmlWeightName() {
        return "distanceBackToBackConflictWeight";
    }

    @Override
    public double getWeightDefault(DataProperties config) {
        return 25.0;
    }

    public double getBackToBackDistance() {
        return this.iBackToBackDistance;
    }

    public void setBackToBackDistance(double backToBackDistance) {
        this.iBackToBackDistance = backToBackDistance;
    }

    @Override
    public void getXmlParameters(Map<String, String> params) {
        params.put(this.getXmlWeightName(), String.valueOf(this.getWeight()));
        params.put("backToBackDistance", String.valueOf(this.getBackToBackDistance()));
    }

    @Override
    public void setXmlParameters(Map<String, String> params) {
        try {
            this.setWeight(Double.valueOf(params.get(this.getXmlWeightName())));
        }
        catch (NumberFormatException numberFormatException) {
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        try {
            this.setBackToBackDistance(Double.valueOf(params.get("backToBackDistance")));
        }
        catch (NumberFormatException numberFormatException) {
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    @Override
    public double getValue(Assignment<Exam, ExamPlacement> assignment, ExamPlacement value, Set<ExamPlacement> conflicts) {
        Exam exam = (Exam)value.variable();
        if (this.getBackToBackDistance() < 0.0) {
            return 0.0;
        }
        int penalty = 0;
        ExamPeriod period = value.getPeriod();
        Map<ExamStudent, Set<Exam>> prev = period.prev() != null && period.prev().getDay() == period.getDay() ? ((ExamModel)this.getModel()).getStudentsOfPeriod(assignment, period.prev()) : null;
        Map<ExamStudent, Set<Exam>> next = period.next() != null && period.next().getDay() == period.getDay() ? ((ExamModel)this.getModel()).getStudentsOfPeriod(assignment, period.next()) : null;
        for (ExamStudent s : exam.getStudents()) {
            Set<Exam> exams;
            if (prev != null && (exams = prev.get(s)) != null) {
                for (Exam x : exams) {
                    if (x.equals(exam) || !(value.getDistanceInMeters(assignment.getValue(x)) > this.getBackToBackDistance())) continue;
                    ++penalty;
                }
            }
            if (next == null || (exams = next.get(s)) == null) continue;
            for (Exam x : exams) {
                if (x.equals(exam) || !(value.getDistanceInMeters(assignment.getValue(x)) > this.getBackToBackDistance())) continue;
                ++penalty;
            }
        }
        return penalty;
    }

    @Override
    public String getName() {
        return "Distance Back-To-Back Conflicts";
    }

    @Override
    public void getInfo(Assignment<Exam, ExamPlacement> assignment, Map<String, String> info) {
        if (this.getBackToBackDistance() >= 0.0 && this.getValue(assignment) != 0.0) {
            info.put(this.getName(), sDoubleFormat.format(this.getValue(assignment)));
        }
    }

    @Override
    public String toString(Assignment<Exam, ExamPlacement> assignment) {
        return this.getValue(assignment) <= 0.0 ? "" : "BTBd:" + sDoubleFormat.format(this.getValue(assignment));
    }

    @Override
    public boolean isPeriodCriterion() {
        return false;
    }
}

