/*
 * Decompiled with CFR 0.152.
 */
package org.cpsolver.coursett.constraint;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.cpsolver.coursett.constraint.JenrlConstraint;
import org.cpsolver.coursett.model.Lecture;
import org.cpsolver.coursett.model.Placement;
import org.cpsolver.coursett.model.Student;
import org.cpsolver.coursett.model.TimetableModel;
import org.cpsolver.ifs.assignment.Assignment;
import org.cpsolver.ifs.model.Constraint;
import org.cpsolver.ifs.model.GlobalConstraint;
import org.cpsolver.ifs.model.Model;
import org.cpsolver.ifs.model.ModelListener;
import org.cpsolver.ifs.solver.Solver;
import org.cpsolver.ifs.util.DataProperties;
import org.cpsolver.ifs.util.DistanceMetric;

public class ExtendedStudentConflicts
extends GlobalConstraint<Lecture, Placement>
implements ModelListener<Lecture, Placement> {
    private String iIgnoreClasses = null;
    private Map<Long, Map<Long, List<Student>>> iCommonStudents = null;
    private Set<Long> iIgnoreClassIds = null;
    private Map<Long, Map<Long, Boolean>> iClassCache = new ConcurrentHashMap<Long, Map<Long, Boolean>>();
    private boolean iCheckSameCourse = true;

    @Override
    public void setModel(Model<Lecture, Placement> model) {
        super.setModel(model);
        if (model != null && model instanceof TimetableModel) {
            DataProperties config = ((TimetableModel)model).getProperties();
            this.iIgnoreClasses = config.getProperty("ExtendedStudentConflicts.IgnoreClasses");
            this.iCheckSameCourse = config.getPropertyBoolean("ExtendedStudentConflicts.CheckSameCourse", true);
        }
    }

    protected void clearCache() {
        this.iClassCache.clear();
        this.iCommonStudents = null;
        this.iIgnoreClassIds = null;
    }

    private DistanceMetric getDistanceMetric() {
        return this.getModel() == null ? null : ((TimetableModel)this.getModel()).getDistanceMetric();
    }

    protected List<Student> getCommonStudents(Long offeringId1, Long offeringId2) {
        Map<Long, List<Student>> offeringIds;
        if (this.iCommonStudents == null) {
            this.iCommonStudents = new ConcurrentHashMap<Long, Map<Long, List<Student>>>();
            for (Lecture lecture : this.getModel().variables()) {
                Map<Long, List<Student>> commonStudents;
                if (lecture.isCommitted() || lecture.getConfiguration() == null || (commonStudents = this.iCommonStudents.get(lecture.getConfiguration().getOfferingId())) != null) continue;
                commonStudents = new ConcurrentHashMap<Long, List<Student>>();
                this.iCommonStudents.put(lecture.getConfiguration().getOfferingId(), commonStudents);
                for (Lecture other : this.getModel().variables()) {
                    if (other.isCommitted() || other.getConfiguration() == null || commonStudents.containsKey(other.getConfiguration().getOfferingId())) continue;
                    ArrayList<Student> students = new ArrayList<Student>();
                    for (Student student : ((TimetableModel)this.getModel()).getAllStudents()) {
                        if (!student.getOfferings().contains(lecture.getConfiguration().getOfferingId()) || !student.getOfferings().contains(other.getConfiguration().getOfferingId())) continue;
                        students.add(student);
                    }
                    commonStudents.put(other.getConfiguration().getOfferingId(), students);
                }
            }
        }
        return (offeringIds = this.iCommonStudents.get(offeringId1)) == null ? null : offeringIds.get(offeringId2);
    }

    protected boolean isIgnoreClass(Lecture lecture) {
        if (this.iIgnoreClassIds == null) {
            this.iIgnoreClassIds = new HashSet<Long>();
            if (this.iIgnoreClasses != null && !this.iIgnoreClasses.isEmpty()) {
                for (Lecture l : this.getModel().variables()) {
                    if (!l.getName().matches(this.iIgnoreClasses)) continue;
                    this.iIgnoreClassIds.add(l.getClassId());
                }
            }
        }
        return this.iIgnoreClassIds.contains(lecture.getClassId());
    }

    private Boolean getCachedPair(Lecture l1, Lecture l2) {
        if (l1.getClassId() < l2.getClassId()) {
            Map<Long, Boolean> cache = this.iClassCache.get(l1.getClassId());
            return cache == null ? null : cache.get(l2.getClassId());
        }
        Map<Long, Boolean> cache = this.iClassCache.get(l2.getClassId());
        return cache == null ? null : cache.get(l1.getClassId());
    }

    private void setCachedPair(Lecture l1, Lecture l2, boolean value) {
        if (l1.getClassId() < l2.getClassId()) {
            Map<Long, Boolean> cache = this.iClassCache.get(l1.getClassId());
            if (cache == null) {
                cache = new ConcurrentHashMap<Long, Boolean>();
                this.iClassCache.put(l1.getClassId(), cache);
            }
            cache.put(l2.getClassId(), value);
        } else {
            Map<Long, Boolean> cache = this.iClassCache.get(l2.getClassId());
            if (cache == null) {
                cache = new ConcurrentHashMap<Long, Boolean>();
                this.iClassCache.put(l2.getClassId(), cache);
            }
            cache.put(l1.getClassId(), value);
        }
    }

    private boolean checkSameCourseCanTakeTogether(Lecture l1, Lecture l2) {
        Object l;
        if (!this.iCheckSameCourse) {
            return false;
        }
        if (l1.getSchedulingSubpartId().equals(l2.getSchedulingSubpartId())) {
            return false;
        }
        if (!l1.getConfiguration().equals(l2.getConfiguration())) {
            return false;
        }
        HashMap<Long, Long> mustTake = new HashMap<Long, Long>();
        for (l = l1; l != null; l = ((Lecture)l).getParent()) {
            mustTake.put(((Lecture)l).getSchedulingSubpartId(), ((Lecture)l).getClassId());
        }
        l = l1.getConfiguration().getTopLectures().entrySet().iterator();
        while (l.hasNext()) {
            Map.Entry e = (Map.Entry)l.next();
            if (((Set)e.getValue()).size() != 1) continue;
            Lecture l3 = (Lecture)((Set)e.getValue()).iterator().next();
            mustTake.put(l3.getSchedulingSubpartId(), l3.getClassId());
        }
        for (l = l2; l != null; l = ((Lecture)l).getParent()) {
            Long id = (Long)mustTake.get(((Lecture)l).getSchedulingSubpartId());
            if (id == null || ((Lecture)l).getClassId().equals(id)) continue;
            return false;
        }
        return true;
    }

    protected boolean checkStudentForStudentConflicts(Lecture l1, Lecture l2) {
        if (l1.isToIgnoreStudentConflictsWith(l2)) {
            return false;
        }
        Boolean cache = this.getCachedPair(l1, l2);
        if (cache != null) {
            return cache;
        }
        if (l1.getConfiguration().getOfferingId().equals(l2.getConfiguration().getOfferingId()) && !this.checkSameCourseCanTakeTogether(l1, l2)) {
            this.setCachedPair(l1, l2, false);
            return false;
        }
        if (this.isIgnoreClass(l1) && this.isIgnoreClass(l2)) {
            this.setCachedPair(l1, l2, false);
            return false;
        }
        List<Student> commonStudents = this.getCommonStudents(l1.getConfiguration().getOfferingId(), l2.getConfiguration().getOfferingId());
        if (commonStudents == null || commonStudents.size() <= 1) {
            this.setCachedPair(l1, l2, false);
            return false;
        }
        for (Student student : commonStudents) {
            if (!student.canEnroll(l1) || !student.canEnroll(l2)) continue;
            this.setCachedPair(l1, l2, true);
            return true;
        }
        this.setCachedPair(l1, l2, false);
        return false;
    }

    @Override
    public void computeConflicts(Assignment<Lecture, Placement> assignment, Placement placement, Set<Placement> conflicts) {
        Lecture lecture = (Lecture)placement.variable();
        for (Lecture other : this.getModel().assignedVariables(assignment)) {
            Placement otherPlacement = assignment.getValue(other);
            if (!this.checkStudentForStudentConflicts(lecture, other) || !JenrlConstraint.isInConflict(placement, otherPlacement, this.getDistanceMetric(), 0)) continue;
            conflicts.add(otherPlacement);
        }
    }

    @Override
    public boolean inConflict(Assignment<Lecture, Placement> assignment, Placement placement) {
        Lecture lecture = (Lecture)placement.variable();
        for (Lecture other : this.getModel().assignedVariables(assignment)) {
            Placement otherPlacement = assignment.getValue(other);
            if (!this.checkStudentForStudentConflicts(lecture, other) || !JenrlConstraint.isInConflict(placement, otherPlacement, this.getDistanceMetric(), 0)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isConsistent(Placement p1, Placement p2) {
        return p1 != null && p2 != null && this.checkStudentForStudentConflicts((Lecture)p1.variable(), (Lecture)p2.variable()) && JenrlConstraint.isInConflict(p1, p2, this.getDistanceMetric(), 0);
    }

    @Override
    public String getName() {
        return "Extended Student Conflicts";
    }

    @Override
    public String toString() {
        return "Extended Student Conflicts";
    }

    @Override
    public void variableAdded(Lecture variable) {
        this.clearCache();
    }

    @Override
    public void variableRemoved(Lecture variable) {
        this.clearCache();
    }

    @Override
    public void constraintAdded(Constraint<Lecture, Placement> constraint) {
    }

    @Override
    public void constraintRemoved(Constraint<Lecture, Placement> constraint) {
    }

    @Override
    public void beforeAssigned(Assignment<Lecture, Placement> assignment, long iteration, Placement value) {
    }

    @Override
    public void beforeUnassigned(Assignment<Lecture, Placement> assignment, long iteration, Placement value) {
    }

    @Override
    public void afterAssigned(Assignment<Lecture, Placement> assignment, long iteration, Placement value) {
    }

    @Override
    public void afterUnassigned(Assignment<Lecture, Placement> assignment, long iteration, Placement value) {
    }

    @Override
    public boolean init(Solver<Lecture, Placement> solver) {
        this.clearCache();
        return true;
    }
}

