/*
 * Decompiled with CFR 0.152.
 */
package org.cpsolver.studentsct.online.expectations;

import org.cpsolver.ifs.assignment.Assignment;
import org.cpsolver.ifs.util.DataProperties;
import org.cpsolver.studentsct.model.Enrollment;
import org.cpsolver.studentsct.model.Request;
import org.cpsolver.studentsct.model.Section;
import org.cpsolver.studentsct.model.Subpart;
import org.cpsolver.studentsct.online.expectations.PercentageOverExpected;

public class AvoidUnbalancedWhenNoExpectations
extends PercentageOverExpected {
    private Double iDisbalance = 0.1;
    private boolean iBalanceUnlimited = false;

    public AvoidUnbalancedWhenNoExpectations(DataProperties config) {
        super(config);
        this.iDisbalance = config.getPropertyDouble("OverExpected.Disbalance", this.iDisbalance);
        this.iBalanceUnlimited = config.getPropertyBoolean("General.BalanceUnlimited", this.iBalanceUnlimited);
    }

    public AvoidUnbalancedWhenNoExpectations(Double percentage, Double disbalance) {
        super(percentage);
        this.iDisbalance = disbalance;
    }

    public AvoidUnbalancedWhenNoExpectations(Double percentage) {
        this(percentage, null);
    }

    public AvoidUnbalancedWhenNoExpectations() {
        this(null, null);
    }

    public Double getDisbalance() {
        return this.iDisbalance;
    }

    public boolean isBalanceUnlimited() {
        return this.iBalanceUnlimited;
    }

    @Override
    public double getOverExpected(Assignment<Request, Enrollment> assignment, Section section, Request request) {
        double desired;
        Subpart subpart = section.getSubpart();
        if (this.hasExpectations(subpart) && section.getLimit() > 0) {
            return super.getOverExpected(assignment, section, request);
        }
        if (this.getDisbalance() == null || this.getDisbalance() < 0.0) {
            return 0.0;
        }
        double enrlConfig = request.getWeight() + this.getEnrollment(assignment, subpart.getConfig(), request);
        int subparts = section.getSubpart().getConfig().getSubparts().size();
        int limit = this.getLimit(section);
        double enrl = request.getWeight() + this.getEnrollment(assignment, section, request);
        if (limit > 0 ? enrl - (desired = enrlConfig / (double)this.getLimit(subpart) * (double)limit) >= Math.max(1.0, this.getDisbalance() * (double)limit) : this.isBalanceUnlimited() && enrl - (desired = enrlConfig / (double)subpart.getSections().size()) >= Math.max(1.0, this.getDisbalance() * desired)) {
            return 1.0 / (double)subparts;
        }
        return 0.0;
    }

    @Override
    public String toString() {
        return "bal(" + this.getPercentage() + "," + this.getDisbalance() + ")";
    }
}

