/*
 * Decompiled with CFR 0.152.
 */
package org.cpsolver.ifs.assignment.context;

import org.cpsolver.ifs.assignment.Assignment;
import org.cpsolver.ifs.assignment.context.AssignmentConstraintContext;
import org.cpsolver.ifs.assignment.context.AssignmentContext;
import org.cpsolver.ifs.assignment.context.AssignmentContextHelper;
import org.cpsolver.ifs.assignment.context.AssignmentContextReference;
import org.cpsolver.ifs.assignment.context.CanHoldContext;
import org.cpsolver.ifs.assignment.context.HasAssignmentContext;
import org.cpsolver.ifs.model.Constraint;
import org.cpsolver.ifs.model.Model;
import org.cpsolver.ifs.model.Value;
import org.cpsolver.ifs.model.Variable;

public abstract class ConstraintWithContext<V extends Variable<V, T>, T extends Value<V, T>, C extends AssignmentConstraintContext<V, T>>
extends Constraint<V, T>
implements HasAssignmentContext<V, T, C>,
CanHoldContext {
    private AssignmentContextReference<V, T, C> iContextReference = null;
    private AssignmentContext[] iContext = new AssignmentContext[17];

    @Override
    public void setModel(Model<V, T> model) {
        super.setModel(model);
        if (model != null) {
            this.iContextReference = model.createReference(this);
        }
    }

    @Override
    public C getContext(Assignment<V, T> assignment) {
        return (C)((AssignmentConstraintContext)AssignmentContextHelper.getContext(this, assignment));
    }

    @Override
    public AssignmentContextReference<V, T, C> getAssignmentContextReference() {
        return this.iContextReference;
    }

    @Override
    public void setAssignmentContextReference(AssignmentContextReference<V, T, C> reference) {
        this.iContextReference = reference;
    }

    @Override
    public AssignmentContext[] getContext() {
        return this.iContext;
    }

    @Override
    public void assigned(Assignment<V, T> assignment, long iteration, T value) {
        super.assigned(assignment, iteration, value);
        this.getContext((Assignment)assignment).assigned(assignment, value);
    }

    @Override
    public void unassigned(Assignment<V, T> assignment, long iteration, T value) {
        super.unassigned(assignment, iteration, value);
        this.getContext((Assignment)assignment).unassigned(assignment, value);
    }
}

