/*
 * Decompiled with CFR 0.152.
 */
package org.cpsolver.ifs.assignment;

import java.util.ArrayList;
import java.util.Collection;
import org.cpsolver.ifs.assignment.Assignment;
import org.cpsolver.ifs.assignment.context.AssignmentContext;
import org.cpsolver.ifs.assignment.context.AssignmentContextHolder;
import org.cpsolver.ifs.assignment.context.AssignmentContextReference;
import org.cpsolver.ifs.assignment.context.HasAssignmentContext;
import org.cpsolver.ifs.constant.ConstantVariable;
import org.cpsolver.ifs.criteria.Criterion;
import org.cpsolver.ifs.model.Constraint;
import org.cpsolver.ifs.model.GlobalConstraint;
import org.cpsolver.ifs.model.Model;
import org.cpsolver.ifs.model.Value;
import org.cpsolver.ifs.model.Variable;

public abstract class AssignmentAbstract<V extends Variable<V, T>, T extends Value<V, T>>
implements Assignment<V, T> {
    protected AssignmentContextHolder<V, T> iContexts;
    protected boolean iHasInitialzedContext = false;

    public AssignmentAbstract(AssignmentContextHolder<V, T> contexts) {
        this.iContexts = contexts;
    }

    @Override
    public T getValue(V variable) {
        if (variable instanceof ConstantVariable && ((ConstantVariable)variable).isConstant()) {
            return ((ConstantVariable)variable).getConstantValue();
        }
        return this.getValueInternal(variable);
    }

    protected abstract T getValueInternal(V var1);

    protected abstract void setValueInternal(long var1, V var3, T var4);

    protected T assign(long iteration, V variable, T value) {
        if (variable instanceof ConstantVariable && ((ConstantVariable)variable).isConstant()) {
            return ((ConstantVariable)variable).getConstantValue();
        }
        assert (((Variable)variable).getModel() != null && (value == null || ((Variable)variable).equals(((Value)value).variable())));
        Model model = ((Variable)variable).getModel();
        this.ensureInitializedContext(variable);
        T old = this.getValueInternal(variable);
        if (old != null) {
            if (((Value)old).equals(value)) {
                return old;
            }
            if (model != null) {
                model.beforeUnassigned(this, iteration, old);
            }
            this.setValueInternal(iteration, variable, null);
            for (Constraint constraint : ((Variable)variable).constraints()) {
                constraint.unassigned(this, iteration, old);
            }
            if (model != null) {
                for (GlobalConstraint globalConstraint : model.globalConstraints()) {
                    globalConstraint.unassigned(this, iteration, old);
                }
            }
            ((Variable)variable).variableUnassigned(this, iteration, old);
            if (model != null) {
                model.afterUnassigned(this, iteration, old);
            }
        }
        if (value != null) {
            if (model != null) {
                model.beforeAssigned(this, iteration, value);
            }
            this.setValueInternal(iteration, variable, value);
            for (Constraint constraint : ((Variable)variable).constraints()) {
                constraint.assigned(this, iteration, value);
            }
            if (model != null) {
                for (GlobalConstraint globalConstraint : model.globalConstraints()) {
                    globalConstraint.assigned(this, iteration, value);
                }
            }
            ((Variable)variable).variableAssigned(this, iteration, value);
            if (model != null) {
                model.afterAssigned(this, iteration, value);
            }
        }
        return old;
    }

    @Override
    public T assign(long iteration, T value) {
        return this.assign(iteration, ((Value)value).variable(), value);
    }

    @Override
    public T unassign(long iteration, V variable) {
        return this.assign(iteration, variable, null);
    }

    @Override
    public T unassign(long iteration, V variable, T value) {
        T current = this.getValue(variable);
        if (current == null && value == null) {
            return current;
        }
        if (current != null && ((Value)current).equals(value)) {
            return current;
        }
        return this.assign(iteration, variable, null);
    }

    @Override
    public int nrAssignedVariables() {
        return this.assignedVariables().size();
    }

    @Override
    public Collection<T> assignedValues() {
        ArrayList<T> values = new ArrayList<T>();
        for (Variable variable : this.assignedVariables()) {
            values.add(this.getValueInternal(variable));
        }
        return values;
    }

    @Override
    public Collection<V> unassignedVariables(Model<V, T> model) {
        ArrayList<Variable> unassigned = new ArrayList<Variable>();
        for (Variable variable : model.variables()) {
            if (this.getValue(variable) != null) continue;
            unassigned.add(variable);
        }
        return unassigned;
    }

    @Override
    public int nrUnassignedVariables(Model<V, T> model) {
        return model.variables().size() - this.nrAssignedVariables();
    }

    @Override
    public <C extends AssignmentContext> C getAssignmentContext(AssignmentContextReference<V, T, C> reference) {
        return this.iContexts.getAssignmentContext(this, reference);
    }

    @Override
    public <C extends AssignmentContext> void clearContext(AssignmentContextReference<V, T, C> reference) {
        this.iContexts.clearContext(reference);
    }

    @Override
    public int getIndex() {
        return -1;
    }

    protected void ensureInitializedContext(V variable) {
        if (!this.iHasInitialzedContext && ((Variable)variable).getModel() != null) {
            if (((Variable)variable).getModel() instanceof HasAssignmentContext) {
                this.iContexts.getAssignmentContext(this, ((HasAssignmentContext)((Object)((Variable)variable).getModel())).getAssignmentContextReference());
            }
            for (Criterion criterion : ((Variable)variable).getModel().getCriteria()) {
                if (!(criterion instanceof HasAssignmentContext)) continue;
                this.iContexts.getAssignmentContext(this, ((HasAssignmentContext)((Object)criterion)).getAssignmentContextReference());
            }
            for (GlobalConstraint globalConstraint : ((Variable)variable).getModel().globalConstraints()) {
                if (!(globalConstraint instanceof HasAssignmentContext)) continue;
                this.iContexts.getAssignmentContext(this, ((HasAssignmentContext)((Object)globalConstraint)).getAssignmentContextReference());
            }
            this.iHasInitialzedContext = true;
        }
        for (Constraint constraint : ((Variable)variable).constraints()) {
            if (!(constraint instanceof HasAssignmentContext)) continue;
            this.iContexts.getAssignmentContext(this, ((HasAssignmentContext)((Object)constraint)).getAssignmentContextReference());
        }
    }
}

