/*
 * Decompiled with CFR 0.152.
 */
package org.cpsolver.ifs.algorithms;

import java.text.DecimalFormat;
import org.cpsolver.ifs.algorithms.NeighbourSearch;
import org.cpsolver.ifs.assignment.Assignment;
import org.cpsolver.ifs.model.Model;
import org.cpsolver.ifs.model.Neighbour;
import org.cpsolver.ifs.model.Value;
import org.cpsolver.ifs.model.Variable;
import org.cpsolver.ifs.solution.Solution;
import org.cpsolver.ifs.util.DataProperties;
import org.cpsolver.ifs.util.JProf;
import org.cpsolver.ifs.util.ToolBox;

public class SimulatedAnnealing<V extends Variable<V, T>, T extends Value<V, T>>
extends NeighbourSearch<V, T> {
    private DecimalFormat iDF5 = new DecimalFormat("0.00000");
    private DecimalFormat iDF10 = new DecimalFormat("0.0000000000");
    private double iInitialTemperature = -1.0;
    private double iMaximalTemperature = 1.5;
    private double iMinimalTemperature = 0.001;
    private double iCoolingRate = 0.95;
    private double iReheatRate = -1.0;
    private long iTemperatureLength = 25000L;
    private double iReheatLengthCoef = 5.0;
    private double iRestoreBestLengthCoef = -1.0;
    private boolean iStochasticHC = false;
    private boolean iRelativeAcceptance = true;
    private Double[] iCoolingRateAdjusts = null;
    private int iTrainingValues = 10000;
    private double iTrainingProbability = 1.0E-5;
    private double iTimeBetweenCooldowns = 10.0;

    public SimulatedAnnealing(DataProperties properties) {
        super(properties);
        this.iInitialTemperature = properties.getPropertyDouble(this.getParameterBaseName() + ".InitialTemperature", this.iInitialTemperature);
        this.iMaximalTemperature = properties.getPropertyDouble(this.getParameterBaseName() + ".MaximalTemperature", this.iInitialTemperature <= 0.0 ? -1.0 : this.iMaximalTemperature);
        this.iMinimalTemperature = properties.getPropertyDouble(this.getParameterBaseName() + ".MinimalTemperature", this.iInitialTemperature <= 0.0 ? -1.0 : 0.0);
        this.iReheatRate = properties.getPropertyDouble(this.getParameterBaseName() + ".ReheatRate", this.iReheatRate);
        this.iCoolingRate = properties.getPropertyDouble(this.getParameterBaseName() + ".CoolingRate", this.iCoolingRate);
        this.iRelativeAcceptance = properties.getPropertyBoolean(this.getParameterBaseName() + ".RelativeAcceptance", this.iRelativeAcceptance);
        this.iStochasticHC = properties.getPropertyBoolean(this.getParameterBaseName() + ".StochasticHC", this.iStochasticHC);
        this.iTemperatureLength = properties.getPropertyLong(this.getParameterBaseName() + ".TemperatureLength", this.iTemperatureLength);
        this.iReheatLengthCoef = properties.getPropertyDouble(this.getParameterBaseName() + ".ReheatLengthCoef", this.iReheatLengthCoef);
        this.iRestoreBestLengthCoef = properties.getPropertyDouble(this.getParameterBaseName() + ".RestoreBestLengthCoef", this.iRestoreBestLengthCoef);
        this.iCoolingRateAdjusts = properties.getPropertyDoubleArry(this.getParameterBaseName() + ".CoolingRateAdjustments", null);
        this.iTrainingValues = properties.getPropertyInt(this.getParameterBaseName() + ".TrainingValues", this.iTrainingValues);
        this.iTrainingProbability = properties.getPropertyDouble(this.getParameterBaseName() + ".TrainingProbability", this.iTrainingProbability);
        this.iTimeBetweenCooldowns = properties.getPropertyDouble(this.getParameterBaseName() + ".TimeBetweenCooldowns", this.iTimeBetweenCooldowns);
        if (this.iReheatRate < 0.0) {
            this.iReheatRate = Math.pow(1.0 / this.iCoolingRate, this.iReheatLengthCoef * 1.7);
        }
        if (this.iRestoreBestLengthCoef < 0.0) {
            this.iRestoreBestLengthCoef = this.iReheatLengthCoef * this.iReheatLengthCoef;
        }
    }

    @Override
    public String getParameterBaseName() {
        return "SimulatedAnnealing";
    }

    @Override
    public NeighbourSearch.NeighbourSearchContext createAssignmentContext(Assignment<V, T> assignment) {
        return new SimulatedAnnealingContext();
    }

    public class SimulatedAnnealingContext
    extends NeighbourSearch.NeighbourSearchContext {
        private double iTemperature = 0.0;
        private int iMoves = 0;
        private double iAbsValue = 0.0;
        private double iBestValue = 0.0;
        private long iLastImprovingIter = -1L;
        private long iLastBestIter = -1L;
        private long iLastReheatIter = 0L;
        private long iLastCoolingIter = 0L;
        private int[] iAcceptIter = new int[]{0, 0, 0};
        private long iReheatLength = 0L;
        private long iRestoreBestLength = 0L;
        private int iTrainingIterations = 0;
        private double iTrainingTotal = 0.0;

        @Override
        protected void activate(Solution<V, T> solution) {
            super.activate(solution);
            this.iTrainingTotal = 0.0;
            this.iTrainingIterations = 0;
            this.iTemperature = SimulatedAnnealing.this.iInitialTemperature;
            this.iReheatLength = Math.round(SimulatedAnnealing.this.iReheatLengthCoef * (double)SimulatedAnnealing.this.iTemperatureLength);
            this.iRestoreBestLength = Math.round(SimulatedAnnealing.this.iRestoreBestLengthCoef * (double)SimulatedAnnealing.this.iTemperatureLength);
            this.iLastImprovingIter = -1L;
            this.iLastBestIter = -1L;
        }

        protected double getCoolingRate(int idx) {
            if (idx < 0 || SimulatedAnnealing.this.iCoolingRateAdjusts == null || idx >= SimulatedAnnealing.this.iCoolingRateAdjusts.length || SimulatedAnnealing.this.iCoolingRateAdjusts[idx] == null) {
                return SimulatedAnnealing.this.iCoolingRate;
            }
            return SimulatedAnnealing.this.iCoolingRate * SimulatedAnnealing.this.iCoolingRateAdjusts[idx];
        }

        protected void train(Solution<V, T> solution) {
            double value = this.iTrainingTotal / (double)this.iTrainingIterations;
            if (SimulatedAnnealing.this.iStochasticHC) {
                SimulatedAnnealing.this.iInitialTemperature = value / Math.log(100.0 * SimulatedAnnealing.this.iTrainingProbability - 1.0);
                if (SimulatedAnnealing.this.iMaximalTemperature <= 0.0) {
                    SimulatedAnnealing.this.iMaximalTemperature = value / Math.log(1.0 / SimulatedAnnealing.this.iTrainingProbability - 1.0);
                }
                if (SimulatedAnnealing.this.iMinimalTemperature < 0.0) {
                    SimulatedAnnealing.this.iMinimalTemperature = 0.1 / Math.log(1.0 / SimulatedAnnealing.this.iTrainingProbability - 1.0);
                }
            } else {
                SimulatedAnnealing.this.iInitialTemperature = -value / Math.log(0.01 * SimulatedAnnealing.this.iTrainingProbability);
                if (SimulatedAnnealing.this.iMaximalTemperature <= 0.0) {
                    SimulatedAnnealing.this.iMaximalTemperature = -value / Math.log(SimulatedAnnealing.this.iTrainingProbability);
                }
                if (SimulatedAnnealing.this.iMinimalTemperature < 0.0) {
                    SimulatedAnnealing.this.iMinimalTemperature = -0.1 / Math.log(SimulatedAnnealing.this.iTrainingProbability);
                }
            }
            this.iTemperature = SimulatedAnnealing.this.iInitialTemperature;
            SimulatedAnnealing.this.info("Iter=" + this.iIter / 1000 + (this.iLastImprovingIter < 0L ? "" : "k, NonImpIter=" + SimulatedAnnealing.this.iDF2.format((double)((long)this.iIter - this.iLastImprovingIter) / 1000.0)) + "k, Speed=" + SimulatedAnnealing.this.iDF2.format(1000.0 * (double)this.iIter / (double)(JProf.currentTimeMillis() - this.iT0)) + " it/s, Value=" + SimulatedAnnealing.this.iDF2.format(solution.getModel().getTotalValue(solution.getAssignment())) + ", Best=" + SimulatedAnnealing.this.iDF2.format(solution.getBestValue()) + " (" + SimulatedAnnealing.this.iDF2.format(100.0 * solution.getModel().getTotalValue(solution.getAssignment()) / solution.getBestValue()) + " %)");
            SimulatedAnnealing.this.info("Temperature set to " + SimulatedAnnealing.this.iDF5.format(this.iTemperature) + " (p(+0.1)=" + SimulatedAnnealing.this.iDF2.format(100.0 * this.prob(0.1)) + "%, p(+1)=" + SimulatedAnnealing.this.iDF2.format(100.0 * this.prob(1.0)) + "%, p(+10)=" + SimulatedAnnealing.this.iDF5.format(100.0 * this.prob(10.0)) + "%, p(+" + SimulatedAnnealing.this.iDF2.format(value) + ")=" + SimulatedAnnealing.this.iDF5.format(100.0 * this.prob(value)) + "%)");
            SimulatedAnnealing.this.info("Maximal temperature set to " + SimulatedAnnealing.this.iDF5.format(SimulatedAnnealing.this.iMaximalTemperature) + " (p(+0.1)=" + SimulatedAnnealing.this.iDF2.format(100.0 * this.prob(0.1, SimulatedAnnealing.this.iMaximalTemperature)) + "%, p(+1)=" + SimulatedAnnealing.this.iDF2.format(100.0 * this.prob(1.0, SimulatedAnnealing.this.iMaximalTemperature)) + "%, p(+10)=" + SimulatedAnnealing.this.iDF5.format(100.0 * this.prob(10.0, SimulatedAnnealing.this.iMaximalTemperature)) + "%, p(+" + SimulatedAnnealing.this.iDF2.format(value) + ")=" + SimulatedAnnealing.this.iDF5.format(100.0 * this.prob(value, SimulatedAnnealing.this.iMaximalTemperature)) + "%)");
            SimulatedAnnealing.this.info("Minimal temperature set to " + SimulatedAnnealing.this.iDF5.format(SimulatedAnnealing.this.iMinimalTemperature) + " (p(+0.001)=" + SimulatedAnnealing.this.iDF2.format(100.0 * this.prob(0.001, SimulatedAnnealing.this.iMinimalTemperature)) + "%, p(+0.01)=" + SimulatedAnnealing.this.iDF2.format(100.0 * this.prob(0.01, SimulatedAnnealing.this.iMinimalTemperature)) + "%, p(+0.1)=" + SimulatedAnnealing.this.iDF5.format(100.0 * this.prob(0.1, SimulatedAnnealing.this.iMinimalTemperature)) + "%)");
            SimulatedAnnealing.this.logNeibourStatus();
            double speed = (double)this.iIter / (double)(JProf.currentTimeMillis() - this.iT0);
            SimulatedAnnealing.this.iTemperatureLength = Math.round(speed * SimulatedAnnealing.this.iTimeBetweenCooldowns * 1000.0);
            this.iReheatLength = Math.round(SimulatedAnnealing.this.iReheatLengthCoef * (double)SimulatedAnnealing.this.iTemperatureLength);
            this.iRestoreBestLength = Math.round(SimulatedAnnealing.this.iRestoreBestLengthCoef * (double)SimulatedAnnealing.this.iTemperatureLength);
            SimulatedAnnealing.this.info("Training speed was " + SimulatedAnnealing.this.iDF2.format(1000.0 * speed) + " it/s, temperature length adjusted to " + SimulatedAnnealing.this.iTemperatureLength + ".");
            this.iIter = 0;
            this.iT0 = JProf.currentTimeMillis();
            this.iLastImprovingIter = -1L;
            this.iLastBestIter = 0L;
            this.iBestValue = solution.getBestValue();
            this.iAcceptIter = new int[]{0, 0, 0};
            this.iMoves = 0;
            this.iAbsValue = 0.0;
        }

        protected void cool(Solution<V, T> solution) {
            SimulatedAnnealing.this.info("Iter=" + this.iIter / 1000 + (this.iLastImprovingIter < 0L ? "" : "k, NonImpIter=" + SimulatedAnnealing.this.iDF2.format((double)((long)this.iIter - this.iLastImprovingIter) / 1000.0)) + "k, Speed=" + SimulatedAnnealing.this.iDF2.format(1000.0 * (double)this.iIter / (double)(JProf.currentTimeMillis() - this.iT0)) + " it/s, Value=" + SimulatedAnnealing.this.iDF2.format(solution.getModel().getTotalValue(solution.getAssignment())) + ", Best=" + SimulatedAnnealing.this.iDF2.format(solution.getBestValue()) + " (" + SimulatedAnnealing.this.iDF2.format(100.0 * solution.getModel().getTotalValue(solution.getAssignment()) / solution.getBestValue()) + " %), Step=" + SimulatedAnnealing.this.iDF2.format(1.0 * (double)((long)this.iIter - Math.max(this.iLastReheatIter, this.iLastImprovingIter)) / (double)SimulatedAnnealing.this.iTemperatureLength));
            if (this.iLastImprovingIter < 0L || (long)this.iIter > this.iLastImprovingIter + SimulatedAnnealing.this.iTemperatureLength) {
                this.iTemperature *= this.getCoolingRate(solution.getAssignment().getIndex() - 1);
                SimulatedAnnealing.this.info("Temperature decreased to " + SimulatedAnnealing.this.iDF5.format(this.iTemperature) + " (#moves=" + this.iMoves + ", rms(value)=" + SimulatedAnnealing.this.iDF2.format(Math.sqrt(this.iAbsValue / (double)this.iMoves)) + ", accept=-" + SimulatedAnnealing.this.iDF2.format(100.0 * (double)this.iAcceptIter[0] / (double)this.iMoves) + "/" + SimulatedAnnealing.this.iDF2.format(100.0 * (double)this.iAcceptIter[1] / (double)this.iMoves) + "/+" + SimulatedAnnealing.this.iDF2.format(100.0 * (double)this.iAcceptIter[2] / (double)this.iMoves) + "%, " + (this.prob(-1.0) < 1.0 ? "p(-1)=" + SimulatedAnnealing.this.iDF2.format(100.0 * this.prob(-1.0)) + "%, " : "") + "p(+0.1)=" + SimulatedAnnealing.this.iDF2.format(100.0 * this.prob(0.1)) + "%, p(+1)=" + SimulatedAnnealing.this.iDF5.format(100.0 * this.prob(1.0)) + "%, p(+10)=" + SimulatedAnnealing.this.iDF10.format(100.0 * this.prob(10.0)) + "%)");
                this.iAbsValue = 0.0;
                this.iAcceptIter = new int[]{0, 0, 0};
                this.iMoves = 0;
            }
            SimulatedAnnealing.this.logNeibourStatus();
            this.iLastCoolingIter = this.iIter;
        }

        protected void reheat(Solution<V, T> solution) {
            this.iTemperature *= SimulatedAnnealing.this.iReheatRate;
            SimulatedAnnealing.this.info("Iter=" + this.iIter / 1000 + (this.iLastImprovingIter < 0L ? "" : "k, NonImpIter=" + SimulatedAnnealing.this.iDF2.format((double)((long)this.iIter - this.iLastImprovingIter) / 1000.0)) + "k, Speed=" + SimulatedAnnealing.this.iDF2.format(1000.0 * (double)this.iIter / (double)(JProf.currentTimeMillis() - this.iT0)) + " it/s, Value=" + SimulatedAnnealing.this.iDF2.format(solution.getModel().getTotalValue(solution.getAssignment())) + ", Best=" + SimulatedAnnealing.this.iDF2.format(solution.getBestValue()) + " (" + SimulatedAnnealing.this.iDF2.format(100.0 * solution.getModel().getTotalValue(solution.getAssignment()) / solution.getBestValue()) + " %)");
            SimulatedAnnealing.this.info("Temperature increased to " + SimulatedAnnealing.this.iDF5.format(this.iTemperature) + " " + (this.prob(-1.0) < 1.0 ? "p(-1)=" + SimulatedAnnealing.this.iDF2.format(100.0 * this.prob(-1.0)) + "%, " : "") + "p(+0.1)=" + SimulatedAnnealing.this.iDF2.format(100.0 * this.prob(0.1)) + "%, p(+1)=" + SimulatedAnnealing.this.iDF5.format(10.0 * this.prob(1.0)) + "%, p(+10)=" + SimulatedAnnealing.this.iDF10.format(100.0 * this.prob(10.0)) + "%)");
            SimulatedAnnealing.this.logNeibourStatus();
            this.iLastReheatIter = this.iIter;
            if (this.iTemperature > SimulatedAnnealing.this.iMaximalTemperature) {
                this.restoreBest(solution);
                this.iLastImprovingIter = -1L;
            }
            this.iBestValue = solution.getBestValue();
            SimulatedAnnealing.this.setProgressPhase("Simulated Annealing [" + SimulatedAnnealing.this.iDF5.format(this.iTemperature) + "]...");
        }

        protected void restoreBest(Solution<V, T> solution) {
            SimulatedAnnealing.this.info("Best solution restored.");
            solution.restoreBest();
            this.iLastBestIter = this.iIter;
        }

        protected double prob(double value) {
            return this.prob(value, this.iTemperature);
        }

        protected double prob(double value, double temp) {
            if (SimulatedAnnealing.this.iStochasticHC) {
                return 1.0 / (1.0 + Math.exp(value / temp));
            }
            return value <= 0.0 ? 1.0 : Math.exp(-value / temp);
        }

        @Override
        protected boolean accept(Assignment<V, T> assignment, Model<V, T> model, Neighbour<V, T> neighbour, double value, boolean lazy) {
            double v;
            ++this.iMoves;
            this.iAbsValue += value * value;
            double d = SimulatedAnnealing.this.iRelativeAcceptance ? value : (v = (lazy ? model.getTotalValue(assignment) : value + model.getTotalValue(assignment)) - this.iBestValue);
            if (this.iTrainingIterations < SimulatedAnnealing.this.iTrainingValues) {
                if (v <= 0.0) {
                    int n = value < 0.0 ? 0 : (value > 0.0 ? 2 : 1);
                    this.iAcceptIter[n] = this.iAcceptIter[n] + 1;
                    return true;
                }
                ++this.iTrainingIterations;
                this.iTrainingTotal += v;
                return false;
            }
            double prob = this.prob(v);
            if (v > 0.0) {
                ++this.iTrainingIterations;
                this.iTrainingTotal += v;
            }
            if (prob >= 1.0 || ToolBox.random() < prob) {
                int n = value < 0.0 ? 0 : (value > 0.0 ? 2 : 1);
                this.iAcceptIter[n] = this.iAcceptIter[n] + 1;
                return true;
            }
            return false;
        }

        @Override
        protected void incIteration(Solution<V, T> solution) {
            super.incIteration(solution);
            ++this.iIter;
            if (SimulatedAnnealing.this.isMaster(solution)) {
                if (SimulatedAnnealing.this.iInitialTemperature <= 0.0) {
                    if (this.iTrainingIterations < SimulatedAnnealing.this.iTrainingValues) {
                        SimulatedAnnealing.this.setProgress(Math.round(100.0 * (double)this.iTrainingIterations / (double)SimulatedAnnealing.this.iTrainingValues));
                        return;
                    }
                    this.train(solution);
                }
                if (this.iLastBestIter >= 0L && (long)this.iIter > this.iLastBestIter + this.iRestoreBestLength) {
                    this.restoreBest(solution);
                }
                if (this.iTemperature < SimulatedAnnealing.this.iMinimalTemperature) {
                    if ((solution.getModel().getTotalValue(solution.getAssignment()) - solution.getBestValue()) / Math.abs(solution.getBestValue()) >= 0.001) {
                        this.restoreBest(solution);
                    }
                    this.iLastImprovingIter = this.iIter;
                    this.reheat(solution);
                } else if (this.iLastImprovingIter >= 0L && (long)this.iIter > Math.max(this.iLastReheatIter, this.iLastImprovingIter) + this.iReheatLength) {
                    this.reheat(solution);
                } else if ((long)this.iIter > this.iLastCoolingIter + SimulatedAnnealing.this.iTemperatureLength) {
                    this.cool(solution);
                }
                SimulatedAnnealing.this.setProgress(Math.round(100.0 * (double)((long)this.iIter - Math.max(this.iLastReheatIter, this.iLastImprovingIter)) / (double)this.iReheatLength));
            }
        }

        @Override
        public void bestSaved(Solution<V, T> solution) {
            super.bestSaved(solution);
            if (this.iLastImprovingIter < 0L || Math.abs(this.iBestValue - solution.getBestValue()) / Math.max(Math.abs(this.iBestValue), Math.abs(solution.getBestValue())) >= 1.0E-4) {
                this.iLastImprovingIter = this.iIter;
                this.iLastBestIter = this.iIter;
                this.iBestValue = solution.getBestValue();
            }
        }
    }
}

