/*
 * Decompiled with CFR 0.152.
 */
package org.cpsolver.ifs.algorithms;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.cpsolver.ifs.algorithms.GreatDeluge;
import org.cpsolver.ifs.algorithms.HillClimber;
import org.cpsolver.ifs.algorithms.ParallelConstruction;
import org.cpsolver.ifs.algorithms.SimulatedAnnealing;
import org.cpsolver.ifs.algorithms.StepCountingHillClimber;
import org.cpsolver.ifs.assignment.Assignment;
import org.cpsolver.ifs.assignment.context.AssignmentContext;
import org.cpsolver.ifs.assignment.context.NeighbourSelectionWithContext;
import org.cpsolver.ifs.heuristics.MaxIdleNeighbourSelection;
import org.cpsolver.ifs.heuristics.NeighbourSelection;
import org.cpsolver.ifs.heuristics.StandardNeighbourSelection;
import org.cpsolver.ifs.model.Neighbour;
import org.cpsolver.ifs.model.Value;
import org.cpsolver.ifs.model.Variable;
import org.cpsolver.ifs.solution.Solution;
import org.cpsolver.ifs.solver.Solver;
import org.cpsolver.ifs.util.DataProperties;
import org.cpsolver.ifs.util.JProf;
import org.cpsolver.ifs.util.Progress;

public class SimpleSearch<V extends Variable<V, T>, T extends Value<V, T>>
extends NeighbourSelectionWithContext<V, T, SimpleSearchContext> {
    private Logger iLog = LogManager.getLogger(SimpleSearch.class);
    private NeighbourSelection<V, T> iCon = null;
    private boolean iConstructionUntilComplete = false;
    private NeighbourSelection<V, T> iStd = null;
    private SimulatedAnnealing<V, T> iSA = null;
    private HillClimber<V, T> iHC = null;
    private GreatDeluge<V, T> iGD = null;
    private boolean iUseGD = true;
    private Progress iProgress = null;
    private int iMaxIdleIterations = 1000;
    private boolean iAllowUnassignments = false;
    private int iTimeOut;
    private double iStartTime;

    public SimpleSearch(DataProperties properties) throws Exception {
        String construction = properties.getProperty("Construction.Class");
        if (construction != null) {
            try {
                Class<?> constructionClass = Class.forName(properties.getProperty("Construction.Class"));
                this.iCon = (NeighbourSelection)constructionClass.getConstructor(DataProperties.class).newInstance(properties);
                this.iConstructionUntilComplete = properties.getPropertyBoolean("Construction.UntilComplete", this.iConstructionUntilComplete);
            }
            catch (Exception e) {
                this.iLog.error("Unable to use " + construction + ": " + e.getMessage());
            }
        }
        this.iStd = new StandardNeighbourSelection(properties);
        this.iSA = new SimulatedAnnealing(properties);
        this.iHC = properties.getPropertyBoolean("Search.CountSteps", false) ? new StepCountingHillClimber(properties) : new HillClimber(properties);
        this.iGD = new GreatDeluge(properties);
        this.iUseGD = properties.getPropertyBoolean("Search.GreatDeluge", this.iUseGD);
        this.iMaxIdleIterations = properties.getPropertyInt("Search.MaxIdleIterations", this.iMaxIdleIterations);
        if (this.iMaxIdleIterations >= 0) {
            this.iStd = new MaxIdleNeighbourSelection<V, T>(properties, this.iStd, this.iMaxIdleIterations);
            if (this.iCon != null && !this.iConstructionUntilComplete) {
                this.iCon = new MaxIdleNeighbourSelection<V, T>(properties, this.iCon, this.iMaxIdleIterations);
            }
        }
        this.iTimeOut = properties.getPropertyInt("Termination.TimeOut", 1800);
        this.iAllowUnassignments = properties.getPropertyBoolean("Suggestion.AllowUnassignments", this.iAllowUnassignments);
    }

    @Override
    public void init(Solver<V, T> solver) {
        super.init(solver);
        if (!solver.hasSingleSolution()) {
            this.iCon = new ParallelConstruction<V, T>(solver.getProperties(), this.iCon == null ? this.iStd : this.iCon);
        }
        this.iStd.init(solver);
        if (this.iCon != null) {
            this.iCon.init(solver);
        }
        this.iSA.init(solver);
        this.iHC.init(solver);
        this.iGD.init(solver);
        this.iProgress = Progress.getInstance(solver.currentSolution().getModel());
        solver.setUpdateProgress(false);
        this.iStartTime = JProf.currentTimeSec();
    }

    protected void updateProgress(int phase, Solution<V, T> solution) {
        if (!this.iHC.isMaster(solution)) {
            return;
        }
        if (phase < 2) {
            if (!"Searching for initial solution ...".equals(this.iProgress.getPhase())) {
                this.iProgress.setPhase("Searching for initial solution ...", solution.getModel().variables().size());
            }
            if (solution.getModel().getBestUnassignedVariables() >= 0) {
                this.iProgress.setProgress(solution.getModel().variables().size() - solution.getModel().getBestUnassignedVariables());
            } else {
                this.iProgress.setProgress(solution.getAssignment().nrAssignedVariables());
            }
        } else {
            if (!"Improving found solution ...".equals(this.iProgress.getPhase())) {
                this.iProgress.setPhase("Improving found solution ...", 1000L);
            }
            double time = JProf.currentTimeSec() - this.iStartTime;
            this.iProgress.setProgress(Math.min(1000L, Math.round(1000.0 * time / (double)this.iTimeOut)));
        }
    }

    @Override
    public Neighbour<V, T> selectNeighbour(Solution<V, T> solution) {
        SimpleSearchContext context = (SimpleSearchContext)this.getContext(solution.getAssignment());
        this.updateProgress(context.getPhase(), solution);
        Neighbour<V, T> n = null;
        switch (context.getPhase()) {
            case -1: {
                context.setPhase(0);
                this.iProgress.info("[" + Thread.currentThread().getName() + "] Construction...");
            }
            case 0: {
                if (this.iCon != null && solution.getModel().nrUnassignedVariables(solution.getAssignment()) > 0 && ((n = this.iCon.selectNeighbour(solution)) != null || this.iConstructionUntilComplete)) {
                    return n;
                }
                context.setPhase(1);
                this.iProgress.info("[" + Thread.currentThread().getName() + "] IFS...");
            }
            case 1: {
                if (this.iStd != null && solution.getModel().nrUnassignedVariables(solution.getAssignment()) > 0 && (n = this.iStd.selectNeighbour(solution)) != null) {
                    return n;
                }
                context.setPhase(2);
                if (solution.getModel().getBestUnassignedVariables() >= 0 && solution.getModel().getBestUnassignedVariables() < solution.getAssignment().nrUnassignedVariables(solution.getModel())) {
                    solution.restoreBest();
                }
            }
            case 2: {
                if (this.iMaxIdleIterations < 0 && solution.getModel().nrUnassignedVariables(solution.getAssignment()) > 0 && (n = (this.iCon == null ? this.iStd : this.iCon).selectNeighbour(solution)) != null) {
                    return n;
                }
                if (this.iMaxIdleIterations >= 0 && !this.iAllowUnassignments && solution.getModel().getBestUnassignedVariables() >= 0 && solution.getModel().getBestUnassignedVariables() < solution.getAssignment().nrUnassignedVariables(solution.getModel())) {
                    solution.restoreBest();
                }
                if ((n = this.iHC.selectNeighbour(solution)) != null) {
                    return n;
                }
                context.setPhase(3);
            }
            case 3: {
                if (this.iMaxIdleIterations < 0 && solution.getModel().nrUnassignedVariables(solution.getAssignment()) > 0 && (n = (this.iCon == null ? this.iStd : this.iCon).selectNeighbour(solution)) != null) {
                    return n;
                }
                if (this.iMaxIdleIterations >= 0 && !this.iAllowUnassignments && solution.getModel().getBestUnassignedVariables() >= 0 && solution.getModel().getBestUnassignedVariables() < solution.getAssignment().nrUnassignedVariables(solution.getModel())) {
                    solution.restoreBest();
                }
                if (this.iUseGD) {
                    return this.iGD.selectNeighbour(solution);
                }
                return this.iSA.selectNeighbour(solution);
            }
        }
        return null;
    }

    @Override
    public SimpleSearchContext createAssignmentContext(Assignment<V, T> assignment) {
        return new SimpleSearchContext();
    }

    public class SimpleSearchContext
    implements AssignmentContext {
        private int iPhase = -1;

        public int getPhase() {
            return this.iPhase;
        }

        public void setPhase(int phase) {
            this.iPhase = phase;
        }
    }
}

