/*
 * Decompiled with CFR 0.152.
 */
package org.cpsolver.exam.model;

import org.cpsolver.exam.model.ExamPeriod;

public class ExamPeriodPlacement
implements Comparable<ExamPeriodPlacement> {
    private ExamPeriod iPeriod;
    private int iPenalty;

    public ExamPeriodPlacement(ExamPeriod period, int penalty) {
        this.iPeriod = period;
        this.iPenalty = penalty;
    }

    public ExamPeriod getPeriod() {
        return this.iPeriod;
    }

    public Long getId() {
        return this.getPeriod().getId();
    }

    public int getIndex() {
        return this.getPeriod().getIndex();
    }

    public int getPenalty() {
        return 2 * this.iPenalty + this.iPeriod.getPenalty();
    }

    public int getExamPenalty() {
        return this.iPenalty;
    }

    public int hashCode() {
        return this.getPeriod().hashCode();
    }

    public String toString() {
        return this.getPeriod().toString() + (this.getPenalty() == 0 ? "" : "/" + this.getPenalty());
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (o instanceof ExamPeriodPlacement) {
            return this.getPeriod().equals(((ExamPeriodPlacement)o).getPeriod());
        }
        if (o instanceof ExamPeriod) {
            return this.getPeriod().equals(o);
        }
        return false;
    }

    @Override
    public int compareTo(ExamPeriodPlacement o) {
        return this.getPeriod().compareTo(o.getPeriod());
    }
}

