/*
 * Decompiled with CFR 0.152.
 */
package org.cpsolver.exam.criteria;

import java.util.Map;
import java.util.Set;
import org.cpsolver.exam.criteria.StudentDistanceBackToBackConflicts;
import org.cpsolver.exam.model.Exam;
import org.cpsolver.exam.model.ExamInstructor;
import org.cpsolver.exam.model.ExamModel;
import org.cpsolver.exam.model.ExamPeriod;
import org.cpsolver.exam.model.ExamPlacement;
import org.cpsolver.ifs.assignment.Assignment;
import org.cpsolver.ifs.util.DataProperties;

public class InstructorDistanceBackToBackConflicts
extends StudentDistanceBackToBackConflicts {
    @Override
    public String getWeightName() {
        return "Exams.InstructorDistanceBackToBackConflictWeight";
    }

    @Override
    public String getXmlWeightName() {
        return "instructorDistanceBackToBackConflictWeight";
    }

    @Override
    public double getWeightDefault(DataProperties config) {
        return 25.0;
    }

    @Override
    public double getValue(Assignment<Exam, ExamPlacement> assignment, ExamPlacement value, Set<ExamPlacement> conflicts) {
        Exam exam = (Exam)value.variable();
        double btbDist = this.getBackToBackDistance();
        if (btbDist < 0.0) {
            return 0.0;
        }
        int penalty = 0;
        ExamPeriod period = value.getPeriod();
        Map<ExamInstructor, Set<Exam>> prev = period.prev() != null && period.prev().getDay() == period.getDay() ? ((ExamModel)this.getModel()).getInstructorsOfPeriod(assignment, period.prev()) : null;
        Map<ExamInstructor, Set<Exam>> next = period.next() != null && period.next().getDay() == period.getDay() ? ((ExamModel)this.getModel()).getInstructorsOfPeriod(assignment, period.next()) : null;
        for (ExamInstructor s : exam.getInstructors()) {
            Set<Exam> exams;
            if (prev != null && (exams = prev.get(s)) != null) {
                for (Exam x : exams) {
                    if (x.equals(exam) || !(value.getDistanceInMeters(assignment.getValue(x)) > this.getBackToBackDistance())) continue;
                    ++penalty;
                }
            }
            if (next == null || (exams = next.get(s)) == null) continue;
            for (Exam x : exams) {
                if (x.equals(exam) || !(value.getDistanceInMeters(assignment.getValue(x)) > this.getBackToBackDistance())) continue;
                ++penalty;
            }
        }
        return penalty;
    }

    @Override
    public String getName() {
        return "Instructor Distance Back-To-Back Conflicts";
    }

    @Override
    public String toString(Assignment<Exam, ExamPlacement> assignment) {
        return this.getValue(assignment) <= 0.0 ? "" : "iBTBd:" + sDoubleFormat.format(this.getValue(assignment));
    }

    @Override
    public boolean isPeriodCriterion() {
        return false;
    }
}

