/*
 * Decompiled with CFR 0.152.
 */
package org.cpsolver.coursett.sectioning;

import java.util.Iterator;
import java.util.Set;
import org.cpsolver.coursett.model.Lecture;
import org.cpsolver.coursett.model.Placement;
import org.cpsolver.coursett.model.Student;
import org.cpsolver.coursett.model.TimetableModel;
import org.cpsolver.coursett.sectioning.StudentSwapGenerator;
import org.cpsolver.ifs.algorithms.neighbourhoods.HillClimberSelection;
import org.cpsolver.ifs.assignment.Assignment;
import org.cpsolver.ifs.model.Neighbour;
import org.cpsolver.ifs.solution.Solution;
import org.cpsolver.ifs.solver.Solver;
import org.cpsolver.ifs.util.DataProperties;
import org.cpsolver.ifs.util.ToolBox;

public class RandomStudentSwap
extends StudentSwapGenerator
implements HillClimberSelection {
    protected boolean iHC = false;
    protected boolean iEnabled = true;

    public RandomStudentSwap(DataProperties config) {
    }

    @Override
    public void init(Solver<Lecture, Placement> solver) {
        super.init(solver);
        this.iEnabled = solver.hasSingleSolution();
    }

    @Override
    public Neighbour<Lecture, Placement> selectNeighbour(Solution<Lecture, Placement> solution) {
        if (!this.iEnabled) {
            return null;
        }
        TimetableModel model = (TimetableModel)solution.getModel();
        if (model.getAllStudents().isEmpty()) {
            return null;
        }
        if (!model.isOnFlySectioningEnabled()) {
            model.setOnFlySectioningEnabled(true);
        }
        Assignment<Lecture, Placement> assignment = solution.getAssignment();
        Lecture lecture = (Lecture)ToolBox.random(model.variables());
        Set<Student> students = lecture.students();
        if (students != null && !students.isEmpty()) {
            int i;
            int stdCnt = students.size();
            Iterator<Student> iterator = students.iterator();
            int stdIdx = ToolBox.random(stdCnt);
            for (i = 0; i < stdIdx; ++i) {
                iterator.next();
            }
            for (i = 0; i < stdCnt; ++i) {
                Student student;
                Neighbour<Lecture, Placement> n;
                if (!iterator.hasNext()) {
                    iterator = students.iterator();
                }
                if ((n = this.generateSwap(model, assignment, student = iterator.next(), lecture.getConfiguration())) == null || this.iHC && !(n.value(assignment) <= 0.0)) continue;
                return n;
            }
        }
        return null;
    }

    @Override
    public void setHcMode(boolean hcMode) {
        this.iHC = hcMode;
    }
}

