/*
 * Decompiled with CFR 0.152.
 */
package biweekly.property;

import biweekly.property.IntegerProperty;

public class Priority
extends IntegerProperty {
    public Priority(Integer priority) {
        super(priority);
    }

    public Priority(Priority original) {
        super(original);
    }

    public boolean isHigh() {
        return this.value != null && (Integer)this.value >= 1 && (Integer)this.value <= 4;
    }

    public boolean isMedium() {
        return this.value != null && (Integer)this.value == 5;
    }

    public boolean isLow() {
        return this.value != null && (Integer)this.value >= 6 && (Integer)this.value <= 9;
    }

    public boolean isUndefined() {
        return this.value != null && (Integer)this.value == 0;
    }

    public String toCuaPriority() {
        if (this.value == null || (Integer)this.value < 1 || (Integer)this.value > 9) {
            return null;
        }
        int letter = ((Integer)this.value - 1) / 3 + 65;
        int number = ((Integer)this.value - 1) % 3 + 1;
        return (char)letter + "" + number;
    }

    @Override
    public Priority copy() {
        return new Priority(this);
    }
}

