/*
 * Decompiled with CFR 0.152.
 */
package biweekly.io;

import biweekly.ICalendar;
import biweekly.component.ICalComponent;
import biweekly.component.VTimezone;
import biweekly.io.DataModelConverter;
import biweekly.io.DefaultGlobalTimezoneIdResolver;
import biweekly.io.GlobalTimezoneIdResolver;
import biweekly.io.ICalTimeZone;
import biweekly.io.ParseContext;
import biweekly.io.ParseWarning;
import biweekly.io.TimezoneAssignment;
import biweekly.io.TimezoneInfo;
import biweekly.io.scribe.ScribeIndex;
import biweekly.io.scribe.component.ICalComponentScribe;
import biweekly.io.scribe.property.ICalPropertyScribe;
import biweekly.property.Daylight;
import biweekly.property.ICalProperty;
import biweekly.property.Timezone;
import biweekly.property.ValuedProperty;
import biweekly.util.ICalDate;
import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;

public abstract class StreamReader
implements Closeable {
    protected final List<ParseWarning> warnings = new ArrayList<ParseWarning>();
    protected ScribeIndex index = new ScribeIndex();
    protected ParseContext context;
    private TimeZone defaultTimezone = TimeZone.getDefault();
    private GlobalTimezoneIdResolver globalTimezoneIdResolver = new DefaultGlobalTimezoneIdResolver();

    public void registerScribe(ICalPropertyScribe<? extends ICalProperty> scribe) {
        this.index.register(scribe);
    }

    public void registerScribe(ICalComponentScribe<? extends ICalComponent> scribe) {
        this.index.register(scribe);
    }

    public ScribeIndex getScribeIndex() {
        return this.index;
    }

    public void setScribeIndex(ScribeIndex index) {
        this.index = index;
    }

    public List<ParseWarning> getWarnings() {
        return new ArrayList<ParseWarning>(this.warnings);
    }

    public TimeZone getDefaultTimezone() {
        return this.defaultTimezone;
    }

    public void setDefaultTimezone(TimeZone defaultTimezone) {
        this.defaultTimezone = defaultTimezone;
    }

    public GlobalTimezoneIdResolver getGlobalTimezoneIdResolver() {
        return this.globalTimezoneIdResolver;
    }

    public void setGlobalTimezoneIdResolver(GlobalTimezoneIdResolver globalTimezoneIdResolver) {
        this.globalTimezoneIdResolver = globalTimezoneIdResolver;
    }

    public List<ICalendar> readAll() throws IOException {
        ICalendar ical;
        ArrayList<ICalendar> icals = new ArrayList<ICalendar>();
        while ((ical = this.readNext()) != null) {
            icals.add(ical);
        }
        return icals;
    }

    public ICalendar readNext() throws IOException {
        this.warnings.clear();
        this.context = new ParseContext();
        ICalendar ical = this._readNext();
        if (ical == null) {
            return null;
        }
        ical.setVersion(this.context.getVersion());
        this.handleTimezones(ical);
        return ical;
    }

    protected abstract ICalendar _readNext() throws IOException;

    private void handleTimezones(ICalendar ical) {
        Object cal;
        boolean userChangedTheDefaultTimezone;
        TimezoneInfo tzinfo = ical.getTimezoneInfo();
        TimezoneAssignment vcalTimezone = this.extractVCalTimezone(ical);
        Iterator<VTimezone> it = ical.getComponents(VTimezone.class).iterator();
        while (it.hasNext()) {
            VTimezone component = it.next();
            TimeZone timezone = this.buildTimeZone(component);
            if (timezone == null) {
                this.warnings.add(new ParseWarning.Builder().message(39, new Object[0]).build());
                continue;
            }
            tzinfo.getTimezones().add(new TimezoneAssignment(timezone, component));
            it.remove();
        }
        boolean bl = userChangedTheDefaultTimezone = !this.defaultTimezone.equals(TimeZone.getDefault());
        if (vcalTimezone != null) {
            cal = Calendar.getInstance(vcalTimezone.getTimeZone());
            for (ParseContext.TimezonedDate timezonedDate : this.context.getFloatingDates()) {
                this.reparseDateUnderDifferentTimezone(timezonedDate, (Calendar)cal);
            }
        } else {
            for (ParseContext.TimezonedDate timezonedDate : this.context.getFloatingDates()) {
                tzinfo.setFloating(timezonedDate.getProperty(), true);
            }
            if (userChangedTheDefaultTimezone) {
                cal = Calendar.getInstance(this.defaultTimezone);
                for (ParseContext.TimezonedDate timezonedDate : this.context.getFloatingDates()) {
                    this.reparseDateUnderDifferentTimezone(timezonedDate, (Calendar)cal);
                }
            }
        }
        for (Map.Entry<String, List<ParseContext.TimezonedDate>> entry : this.context.getTimezonedDates()) {
            String tzid = entry.getKey();
            TimezoneAssignment assignment = this.determineTimezoneAssignment(tzid, tzinfo);
            if (assignment == null && !userChangedTheDefaultTimezone) continue;
            TimeZone tz = assignment == null ? this.defaultTimezone : assignment.getTimeZone();
            Calendar cal2 = Calendar.getInstance(tz);
            for (ParseContext.TimezonedDate timezonedDate : entry.getValue()) {
                ICalProperty property = timezonedDate.getProperty();
                if (assignment != null) {
                    tzinfo.setTimezone(property, assignment);
                    property.getParameters().setTimezoneId(null);
                }
                this.reparseDateUnderDifferentTimezone(timezonedDate, cal2);
            }
        }
    }

    private TimeZone buildTimeZone(VTimezone component) {
        String id = ValuedProperty.getValue(component.getTimezoneId());
        boolean idMissing = id == null || id.trim().isEmpty();
        return idMissing ? null : new ICalTimeZone(component);
    }

    private void reparseDateUnderDifferentTimezone(ParseContext.TimezonedDate timezonedDate, Calendar cal) {
        ICalDate date = timezonedDate.getDate();
        Date realDate = date.getRawComponents().toDate(cal);
        date.setTime(realDate.getTime());
    }

    private TimezoneAssignment determineTimezoneAssignment(String tzid, TimezoneInfo tzinfo) {
        int warning;
        boolean isOlsenId = tzid.startsWith("/");
        if (isOlsenId) {
            String globalId = tzid.substring(1);
            TimeZone timezone = this.globalTimezoneIdResolver.resolve(globalId);
            if (timezone != null) {
                TimezoneAssignment assignment = new TimezoneAssignment(timezone, globalId);
                tzinfo.getTimezones().add(assignment);
                return assignment;
            }
            TimezoneAssignment assignment = tzinfo.getTimezoneById(tzid);
            int warning2 = assignment == null ? 38 : 43;
            this.warnings.add(new ParseWarning.Builder().message(warning2, tzid).build());
            return assignment;
        }
        TimezoneAssignment assignment = tzinfo.getTimezoneById(tzid);
        if (assignment != null) {
            return assignment;
        }
        String globalId = tzid;
        TimeZone timezone = this.globalTimezoneIdResolver.resolve(globalId);
        if (timezone == null) {
            warning = 38;
            assignment = null;
        } else {
            warning = 37;
            assignment = new TimezoneAssignment(timezone, globalId);
            tzinfo.getTimezones().add(assignment);
        }
        this.warnings.add(new ParseWarning.Builder().message(warning, globalId).build());
        return assignment;
    }

    private TimezoneAssignment extractVCalTimezone(ICalendar ical) {
        List<Timezone> timezones;
        Timezone timezone;
        List<Daylight> daylights = ical.removeProperties(Daylight.class);
        VTimezone vcalComponent = DataModelConverter.convert(daylights, timezone = (timezones = ical.removeProperties(Timezone.class)).isEmpty() ? null : timezones.get(0));
        if (vcalComponent == null) {
            return null;
        }
        ICalTimeZone icalTimezone = new ICalTimeZone(vcalComponent);
        TimezoneInfo tzinfo = ical.getTimezoneInfo();
        TimezoneAssignment assignment = new TimezoneAssignment((TimeZone)icalTimezone, vcalComponent);
        tzinfo.setDefaultTimezone(assignment);
        return assignment;
    }
}

