/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.util;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.jboss.byteman.rule.Rule;
import org.jboss.byteman.rule.helper.Helper;
import org.jgroups.stack.DiagnosticsHandler;
import org.jgroups.util.Profiler;
import org.jgroups.util.Util;

public class ProfilingHelper
extends Helper {
    protected static final Map<String, Profiler> profilers = new ConcurrentHashMap<String, Profiler>();
    protected static final ProfilingProbeHandler ph = new ProfilingProbeHandler();

    protected ProfilingHelper(Rule rule) {
        super(rule);
    }

    public void diagCreated(DiagnosticsHandler diag) {
        boolean already_present;
        if (diag != null && diag.isEnabled() && !(already_present = diag.getProbeHandlers().contains(ph))) {
            diag.registerProbeHandler(ph);
        }
    }

    public void start(String profiler_name) {
        Profiler p = profilers.computeIfAbsent(profiler_name, n -> new Profiler());
        p.start();
    }

    public void stop(String profiler_name) {
        Profiler p = profilers.computeIfAbsent(profiler_name, n -> new Profiler());
        p.stop();
    }

    protected static DiagnosticsHandler createDiagHandler() throws Exception {
        DiagnosticsHandler ret = new DiagnosticsHandler();
        ret.printHeaders(b -> String.format("%s [ip=%s, %s]\n", ret.getLocalAddress(), ProfilingHelper.localAddress(), Util.JAVA_VERSION.isEmpty() ? "" : String.format("java %s", Util.JAVA_VERSION)));
        return ret;
    }

    protected static String localAddress() {
        try {
            return InetAddress.getLocalHost().getHostAddress();
        }
        catch (UnknownHostException e) {
            return "n/a";
        }
    }

    protected static class ProfilingProbeHandler
    implements DiagnosticsHandler.ProbeHandler {
        @Override
        public Map<String, String> handleProbe(String ... keys) {
            HashMap<String, String> m = new HashMap<String, String>();
            for (String key : keys) {
                if ("prof".equals(key)) {
                    for (Map.Entry<String, Profiler> e : profilers.entrySet()) {
                        m.put(e.getKey(), e.getValue().toString());
                    }
                    continue;
                }
                if ("prof-reset".equals(key)) {
                    profilers.clear();
                    continue;
                }
                Profiler p = profilers.get(key);
                if (p == null) continue;
                m.put(key, p.toString());
            }
            return m;
        }

        @Override
        public String[] supportedKeys() {
            ArrayList<String> keys = new ArrayList<String>(profilers.keySet());
            keys.add("prof");
            keys.add("prof-reset");
            return keys.toArray(new String[0]);
        }
    }
}

