/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.thirdparty.debugging.sourcemap;

import com.google.gwt.thirdparty.debugging.sourcemap.SourceMapConsumerV3;
import com.google.gwt.thirdparty.debugging.sourcemap.SourceMapObject;
import com.google.gwt.thirdparty.debugging.sourcemap.SourceMapObjectParser;
import com.google.gwt.thirdparty.debugging.sourcemap.SourceMapParseException;
import com.google.gwt.thirdparty.debugging.sourcemap.SourceMapSupplier;
import com.google.gwt.thirdparty.debugging.sourcemap.SourceMapping;
import org.jspecify.nullness.Nullable;

public final class SourceMapConsumerFactory {
    private SourceMapConsumerFactory() {
    }

    public static SourceMapping parse(String contents) throws SourceMapParseException {
        return SourceMapConsumerFactory.parse(contents, null);
    }

    public static SourceMapping parse(String contents, @Nullable SourceMapSupplier supplier) throws SourceMapParseException {
        if (contents.startsWith("/** Begin line maps. **/")) {
            throw new SourceMapParseException("This appears to be a V1 SourceMap, which is not supported.");
        }
        if (contents.startsWith("{")) {
            SourceMapObject sourceMapObject = SourceMapObjectParser.parse(contents);
            switch (sourceMapObject.getVersion()) {
                case 3: {
                    SourceMapConsumerV3 consumer = new SourceMapConsumerV3();
                    consumer.parse(sourceMapObject, supplier);
                    return consumer;
                }
            }
            throw new SourceMapParseException("Unknown source map version:" + sourceMapObject.getVersion());
        }
        throw new SourceMapParseException("unable to detect source map format");
    }
}

