/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.safecss.shared;

import com.google.gwt.core.shared.GWT;
import com.google.gwt.dom.client.Style;
import com.google.gwt.safecss.shared.SafeStyles;
import com.google.gwt.safecss.shared.SafeStylesHostedModeUtils;
import com.google.gwt.safecss.shared.SafeStylesString;
import com.google.gwt.safehtml.shared.SafeUri;

public final class SafeStylesUtils {
    private static Impl impl;

    public static SafeStyles forBackgroundImage(SafeUri uri) {
        return SafeStylesUtils.fromTrustedNameAndValue("background-image", "url(\"" + uri.asString() + "\")");
    }

    public static SafeStyles forBorderStyle(Style.BorderStyle value) {
        return SafeStylesUtils.fromTrustedNameAndValue("border-style", value.getCssName());
    }

    public static SafeStyles forBorderWidth(double value, Style.Unit unit) {
        return SafeStylesUtils.fromTrustedNameAndValue("border-width", value, unit);
    }

    public static SafeStyles forBottom(double value, Style.Unit unit) {
        return SafeStylesUtils.fromTrustedNameAndValue("bottom", value, unit);
    }

    public static SafeStyles forClear(Style.Clear value) {
        return SafeStylesUtils.fromTrustedNameAndValue("clear", value.getCssName());
    }

    public static SafeStyles forCursor(Style.Cursor value) {
        return SafeStylesUtils.fromTrustedNameAndValue("cursor", value.getCssName());
    }

    public static SafeStyles forDisplay(Style.Display value) {
        return SafeStylesUtils.fromTrustedNameAndValue("display", value.getCssName());
    }

    public static SafeStyles forFloat(Style.Float value) {
        return SafeStylesUtils.fromTrustedNameAndValue("float", value.getCssName());
    }

    public static SafeStyles forFontSize(double value, Style.Unit unit) {
        return SafeStylesUtils.fromTrustedNameAndValue("font-size", value, unit);
    }

    public static SafeStyles forFontStyle(Style.FontStyle value) {
        return SafeStylesUtils.fromTrustedNameAndValue("font-style", value.getCssName());
    }

    public static SafeStyles forFontWeight(Style.FontWeight value) {
        return SafeStylesUtils.fromTrustedNameAndValue("font-weight", value.getCssName());
    }

    public static SafeStyles forHeight(double value, Style.Unit unit) {
        return SafeStylesUtils.fromTrustedNameAndValue("height", value, unit);
    }

    public static SafeStyles forLeft(double value, Style.Unit unit) {
        return SafeStylesUtils.fromTrustedNameAndValue("left", value, unit);
    }

    public static SafeStyles forLineHeight(double value, Style.Unit unit) {
        return SafeStylesUtils.fromTrustedNameAndValue("line-height", value, unit);
    }

    public static SafeStyles forListStyleType(Style.ListStyleType value) {
        return SafeStylesUtils.fromTrustedNameAndValue("list-style-type", value.getCssName());
    }

    public static SafeStyles forMargin(double value, Style.Unit unit) {
        return SafeStylesUtils.fromTrustedNameAndValue("margin", value, unit);
    }

    public static SafeStyles forMarginBottom(double value, Style.Unit unit) {
        return SafeStylesUtils.fromTrustedNameAndValue("margin-bottom", value, unit);
    }

    public static SafeStyles forMarginLeft(double value, Style.Unit unit) {
        return SafeStylesUtils.fromTrustedNameAndValue("margin-left", value, unit);
    }

    public static SafeStyles forMarginRight(double value, Style.Unit unit) {
        return SafeStylesUtils.fromTrustedNameAndValue("margin-right", value, unit);
    }

    public static SafeStyles forMarginTop(double value, Style.Unit unit) {
        return SafeStylesUtils.fromTrustedNameAndValue("margin-top", value, unit);
    }

    public static SafeStyles forOpacity(double value) {
        return SafeStylesUtils.impl().forOpacity(value);
    }

    public static SafeStyles forOutlineStyle(Style.OutlineStyle value) {
        return SafeStylesUtils.fromTrustedNameAndValue("outline-style", value.getCssName());
    }

    public static SafeStyles forOutlineWidth(double value, Style.Unit unit) {
        return SafeStylesUtils.fromTrustedNameAndValue("outline-width", value, unit);
    }

    public static SafeStyles forOverflow(Style.Overflow value) {
        return SafeStylesUtils.fromTrustedNameAndValue("overflow", value.getCssName());
    }

    public static SafeStyles forOverflowX(Style.Overflow value) {
        return SafeStylesUtils.fromTrustedNameAndValue("overflow-x", value.getCssName());
    }

    public static SafeStyles forOverflowY(Style.Overflow value) {
        return SafeStylesUtils.fromTrustedNameAndValue("overflow-y", value.getCssName());
    }

    public static SafeStyles forPadding(double value, Style.Unit unit) {
        return SafeStylesUtils.fromTrustedNameAndValue("padding", value, unit);
    }

    public static SafeStyles forPaddingBottom(double value, Style.Unit unit) {
        return SafeStylesUtils.fromTrustedNameAndValue("padding-bottom", value, unit);
    }

    public static SafeStyles forPaddingLeft(double value, Style.Unit unit) {
        return SafeStylesUtils.fromTrustedNameAndValue("padding-left", value, unit);
    }

    public static SafeStyles forPaddingRight(double value, Style.Unit unit) {
        return SafeStylesUtils.fromTrustedNameAndValue("padding-right", value, unit);
    }

    public static SafeStyles forPaddingTop(double value, Style.Unit unit) {
        return SafeStylesUtils.fromTrustedNameAndValue("padding-top", value, unit);
    }

    public static SafeStyles forPosition(Style.Position value) {
        return SafeStylesUtils.fromTrustedNameAndValue("position", value.getCssName());
    }

    public static SafeStyles forRight(double value, Style.Unit unit) {
        return SafeStylesUtils.fromTrustedNameAndValue("right", value, unit);
    }

    public static SafeStyles forTableLayout(Style.TableLayout value) {
        return SafeStylesUtils.fromTrustedNameAndValue("table-layout", value.getCssName());
    }

    public static SafeStyles forTextAlign(Style.TextAlign value) {
        return SafeStylesUtils.fromTrustedNameAndValue("text-align", value.getCssName());
    }

    public static SafeStyles forTextDecoration(Style.TextDecoration value) {
        return SafeStylesUtils.fromTrustedNameAndValue("text-decoration", value.getCssName());
    }

    public static SafeStyles forTextIndent(double value, Style.Unit unit) {
        return SafeStylesUtils.fromTrustedNameAndValue("text-indent", value + unit.getType());
    }

    public static SafeStyles forTextJustify(Style.TextJustify value) {
        return SafeStylesUtils.fromTrustedNameAndValue("text-justify", value.getCssName());
    }

    public static SafeStyles forTextOverflow(Style.TextOverflow value) {
        return SafeStylesUtils.fromTrustedNameAndValue("text-overflow", value.getCssName());
    }

    public static SafeStyles forTextTransform(Style.TextTransform value) {
        return SafeStylesUtils.fromTrustedNameAndValue("text-transform", value.getCssName());
    }

    public static SafeStyles forTop(double value, Style.Unit unit) {
        return SafeStylesUtils.fromTrustedNameAndValue("top", value, unit);
    }

    public static SafeStyles forTrustedBackgroundColor(String value) {
        return SafeStylesUtils.fromTrustedNameAndValue("background-color", value);
    }

    public static SafeStyles forTrustedBackgroundImage(String value) {
        return SafeStylesUtils.fromTrustedNameAndValue("background-image", value);
    }

    public static SafeStyles forTrustedBorderColor(String value) {
        return SafeStylesUtils.fromTrustedNameAndValue("border-color", value);
    }

    public static SafeStyles forTrustedColor(String value) {
        return SafeStylesUtils.fromTrustedNameAndValue("color", value);
    }

    public static SafeStyles forTrustedOutlineColor(String value) {
        return SafeStylesUtils.fromTrustedNameAndValue("outline-color", value);
    }

    public static SafeStyles forVerticalAlign(double value, Style.Unit unit) {
        return SafeStylesUtils.fromTrustedNameAndValue("vertical-align", value, unit);
    }

    public static SafeStyles forVerticalAlign(Style.VerticalAlign value) {
        return SafeStylesUtils.fromTrustedNameAndValue("vertical-align", value.getCssName());
    }

    public static SafeStyles forVisibility(Style.Visibility value) {
        return SafeStylesUtils.fromTrustedNameAndValue("visibility", value.getCssName());
    }

    public static SafeStyles forWhiteSpace(Style.WhiteSpace value) {
        return SafeStylesUtils.fromTrustedNameAndValue("white-space", value.getCssName());
    }

    public static SafeStyles forWidth(double value, Style.Unit unit) {
        return SafeStylesUtils.fromTrustedNameAndValue("width", value, unit);
    }

    public static SafeStyles forZIndex(int value) {
        return new SafeStylesString("z-index: " + value + ";");
    }

    public static SafeStyles fromTrustedNameAndValue(String name, double value, Style.Unit unit) {
        SafeStylesHostedModeUtils.maybeCheckValidStyleName(name);
        return new SafeStylesString(name + ":" + value + unit.getType() + ";");
    }

    public static SafeStyles fromTrustedNameAndValue(String name, String value) {
        SafeStylesHostedModeUtils.maybeCheckValidStyleName(name);
        SafeStylesHostedModeUtils.maybeCheckValidStyleValue(value);
        return SafeStylesUtils.fromTrustedString(name + ":" + value + ";");
    }

    public static SafeStyles fromTrustedString(String s) {
        return new SafeStylesString(s);
    }

    static void verifySafeStylesConstraints(String styles) {
        if (styles == null) {
            throw new NullPointerException("css is null");
        }
        assert (styles.trim().length() == 0 || styles.endsWith(";")) : "Invalid CSS Property: '" + styles + "'. CSS properties must be an empty string or end with a semi-colon (;).";
        assert (!styles.contains("<") && !styles.contains(">")) : "Invalid CSS Property: '" + styles + "'. CSS should not contain brackets (< or >).";
    }

    private static Impl impl() {
        if (impl == null) {
            impl = GWT.isClient() ? (Impl)GWT.create(Impl.class) : new Impl();
        }
        return impl;
    }

    private SafeStylesUtils() {
    }

    @Deprecated
    static class Impl {
        Impl() {
        }

        public SafeStyles forOpacity(double value) {
            return new SafeStylesString("opacity: " + value + ";");
        }
    }
}

