/*
 * Decompiled with CFR 0.152.
 */
package org.cpsolver.instructor.model;

import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.cpsolver.coursett.Constants;
import org.cpsolver.coursett.model.TimeLocation;
import org.cpsolver.ifs.assignment.Assignment;
import org.cpsolver.ifs.assignment.context.ConstraintWithContext;
import org.cpsolver.ifs.criteria.Criterion;
import org.cpsolver.ifs.model.Constraint;
import org.cpsolver.ifs.model.Model;
import org.cpsolver.ifs.util.DataProperties;
import org.cpsolver.ifs.util.ToolBox;
import org.cpsolver.instructor.constraints.GroupConstraint;
import org.cpsolver.instructor.constraints.InstructorConstraint;
import org.cpsolver.instructor.constraints.SameInstructorConstraint;
import org.cpsolver.instructor.constraints.SameLinkConstraint;
import org.cpsolver.instructor.criteria.AttributePreferences;
import org.cpsolver.instructor.criteria.BackToBack;
import org.cpsolver.instructor.criteria.CoursePreferences;
import org.cpsolver.instructor.criteria.DifferentLecture;
import org.cpsolver.instructor.criteria.Distributions;
import org.cpsolver.instructor.criteria.InstructorPreferences;
import org.cpsolver.instructor.criteria.OriginalInstructor;
import org.cpsolver.instructor.criteria.SameCommon;
import org.cpsolver.instructor.criteria.SameCourse;
import org.cpsolver.instructor.criteria.SameDays;
import org.cpsolver.instructor.criteria.SameInstructor;
import org.cpsolver.instructor.criteria.SameLink;
import org.cpsolver.instructor.criteria.SameRoom;
import org.cpsolver.instructor.criteria.TeachingPreferences;
import org.cpsolver.instructor.criteria.TimeOverlaps;
import org.cpsolver.instructor.criteria.TimePreferences;
import org.cpsolver.instructor.criteria.UnusedInstructorLoad;
import org.cpsolver.instructor.model.Attribute;
import org.cpsolver.instructor.model.Course;
import org.cpsolver.instructor.model.EnrolledClass;
import org.cpsolver.instructor.model.Instructor;
import org.cpsolver.instructor.model.Preference;
import org.cpsolver.instructor.model.Section;
import org.cpsolver.instructor.model.TeachingAssignment;
import org.cpsolver.instructor.model.TeachingRequest;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;

public class InstructorSchedulingModel
extends Model<TeachingRequest.Variable, TeachingAssignment> {
    private static Logger sLog = LogManager.getLogger(InstructorSchedulingModel.class);
    private DataProperties iProperties;
    private Set<Attribute.Type> iTypes = new HashSet<Attribute.Type>();
    private List<Instructor> iInstructors = new ArrayList<Instructor>();
    private List<TeachingRequest> iRequests = new ArrayList<TeachingRequest>();
    private List<BitSet> iWeeks = null;

    public InstructorSchedulingModel(DataProperties properties) {
        this.iProperties = properties;
        this.addCriterion(new AttributePreferences());
        this.addCriterion(new InstructorPreferences());
        this.addCriterion(new TeachingPreferences());
        this.addCriterion(new TimePreferences());
        this.addCriterion(new CoursePreferences());
        this.addCriterion(new BackToBack());
        this.addCriterion(new SameInstructor());
        this.addCriterion(new TimeOverlaps());
        this.addCriterion(new DifferentLecture());
        this.addCriterion(new SameLink());
        this.addCriterion(new OriginalInstructor());
        this.addCriterion(new UnusedInstructorLoad());
        this.addCriterion(new SameCourse());
        this.addCriterion(new SameCommon());
        this.addCriterion(new SameDays());
        this.addCriterion(new SameRoom());
        this.addCriterion(new Distributions());
        this.addGlobalConstraint(new InstructorConstraint());
        this.addGlobalConstraint(new GroupConstraint());
    }

    public DataProperties getProperties() {
        return this.iProperties;
    }

    public void addInstructor(Instructor instructor) {
        instructor.setModel(this);
        this.iInstructors.add(instructor);
        for (Attribute attribute : instructor.getAttributes()) {
            this.addAttributeType(attribute.getType());
        }
    }

    public List<Instructor> getInstructors() {
        return this.iInstructors;
    }

    public void addRequest(TeachingRequest request) {
        this.iRequests.add(request);
        for (TeachingRequest.Variable variable : request.getVariables()) {
            this.addVariable(variable);
        }
    }

    public List<TeachingRequest> getRequests() {
        return this.iRequests;
    }

    public Set<Attribute.Type> getAttributeTypes() {
        return this.iTypes;
    }

    public void addAttributeType(Attribute.Type type) {
        this.iTypes.add(type);
    }

    @Override
    public Map<String, String> getInfo(Assignment<TeachingRequest.Variable, TeachingAssignment> assignment) {
        Map<String, String> info = super.getInfo(assignment);
        double totalLoad = 0.0;
        double assignedLoad = 0.0;
        for (TeachingRequest.Variable clazz : this.variables()) {
            totalLoad += (double)clazz.getRequest().getLoad();
            if (assignment.getValue(clazz) == null) continue;
            assignedLoad += (double)clazz.getRequest().getLoad();
        }
        info.put("Assigned Load", this.getPerc(assignedLoad, totalLoad, 0.0) + "% (" + sDoubleFormat.format(assignedLoad) + " / " + sDoubleFormat.format(totalLoad) + ")");
        return info;
    }

    @Override
    public double getTotalValue(Assignment<TeachingRequest.Variable, TeachingAssignment> assignment) {
        double ret = 0.0;
        for (Criterion<TeachingRequest.Variable, TeachingAssignment> criterion : this.getCriteria()) {
            ret += criterion.getWeightedValue(assignment);
        }
        return ret;
    }

    @Override
    public double getTotalValue(Assignment<TeachingRequest.Variable, TeachingAssignment> assignment, Collection<TeachingRequest.Variable> variables) {
        double ret = 0.0;
        for (Criterion<TeachingRequest.Variable, TeachingAssignment> criterion : this.getCriteria()) {
            ret += criterion.getWeightedValue(assignment, variables);
        }
        return ret;
    }

    public Document save(Assignment<TeachingRequest.Variable, TeachingAssignment> assignment) {
        DecimalFormat sDF7 = new DecimalFormat("0000000");
        boolean saveInitial = this.getProperties().getPropertyBoolean("Xml.SaveInitial", false);
        boolean saveBest = this.getProperties().getPropertyBoolean("Xml.SaveBest", false);
        boolean saveSolution = this.getProperties().getPropertyBoolean("Xml.SaveSolution", true);
        Document document = DocumentHelper.createDocument();
        if (assignment != null && assignment.nrAssignedVariables() > 0) {
            StringBuffer comments = new StringBuffer("Solution Info:\n");
            Map<String, String> solutionInfo = this.getProperties().getPropertyBoolean("Xml.ExtendedInfo", true) ? this.getExtendedInfo(assignment) : this.getInfo(assignment);
            for (String string : new TreeSet<String>(solutionInfo.keySet())) {
                String string2 = solutionInfo.get(string);
                comments.append("    " + string + ": " + string2 + "\n");
            }
            document.addComment(comments.toString());
        }
        Element root = document.addElement("instructor-schedule");
        root.addAttribute("version", "1.0");
        root.addAttribute("created", String.valueOf(new Date()));
        Element typesEl = root.addElement("attributes");
        for (Attribute.Type type : this.getAttributeTypes()) {
            Element element = typesEl.addElement("type");
            if (type.getTypeId() != null) {
                element.addAttribute("id", String.valueOf(type.getTypeId()));
            }
            element.addAttribute("name", type.getTypeName());
            element.addAttribute("conjunctive", type.isConjunctive() ? "true" : "false");
            element.addAttribute("required", type.isRequired() ? "true" : "false");
            HashSet<Attribute> attributes = new HashSet<Attribute>();
            for (TeachingRequest request : this.getRequests()) {
                for (Preference<Attribute> preference : request.getAttributePreferences()) {
                    Attribute attribute = preference.getTarget();
                    if (!type.equals(attribute.getType()) || !attributes.add(attribute)) continue;
                    Element element2 = element.addElement("attribute");
                    if (attribute.getAttributeId() != null) {
                        element2.addAttribute("id", String.valueOf(attribute.getAttributeId()));
                    }
                    element2.addAttribute("name", attribute.getAttributeName());
                    if (attribute.getParentAttribute() == null || attribute.getParentAttribute().getAttributeId() == null) continue;
                    element2.addAttribute("parent", String.valueOf(attribute.getParentAttribute().getAttributeId()));
                }
                for (Instructor instructor : this.getInstructors()) {
                    for (Attribute attribute : instructor.getAttributes()) {
                        if (!type.equals(attribute.getType()) || !attributes.add(attribute)) continue;
                        Element attributeEl = element.addElement("attribute");
                        if (attribute.getAttributeId() != null) {
                            attributeEl.addAttribute("id", String.valueOf(attribute.getAttributeId()));
                        }
                        attributeEl.addAttribute("name", attribute.getAttributeName());
                        if (attribute.getParentAttribute() == null || attribute.getParentAttribute().getAttributeId() == null) continue;
                        attributeEl.addAttribute("parent", String.valueOf(attribute.getParentAttribute().getAttributeId()));
                    }
                }
            }
        }
        Element requestsEl = root.addElement("teaching-requests");
        for (TeachingRequest teachingRequest : this.getRequests()) {
            Element instructorEl;
            Instructor instructor;
            Element requestEl = requestsEl.addElement("request");
            requestEl.addAttribute("id", String.valueOf(teachingRequest.getRequestId()));
            if (teachingRequest.getNrInstructors() != 1) {
                requestEl.addAttribute("nrInstructors", String.valueOf(teachingRequest.getNrInstructors()));
            }
            Course course = teachingRequest.getCourse();
            Element courseEl = requestEl.addElement("course");
            if (course.getCourseId() != null) {
                courseEl.addAttribute("id", String.valueOf(course.getCourseId()));
            }
            if (course.getCourseName() != null) {
                courseEl.addAttribute("name", String.valueOf(course.getCourseName()));
            }
            for (Section section : teachingRequest.getSections()) {
                Element sectionEl = requestEl.addElement("section");
                sectionEl.addAttribute("id", String.valueOf(section.getSectionId()));
                if (section.getExternalId() != null && !section.getExternalId().isEmpty()) {
                    sectionEl.addAttribute("externalId", section.getExternalId());
                }
                if (section.getSectionType() != null && !section.getSectionType().isEmpty()) {
                    sectionEl.addAttribute("type", section.getSectionType());
                }
                if (section.getSectionName() != null && !section.getSectionName().isEmpty()) {
                    sectionEl.addAttribute("name", section.getSectionName());
                }
                if (section.hasTime()) {
                    TimeLocation timeLocation = section.getTime();
                    Element timeEl = sectionEl.addElement("time");
                    timeEl.addAttribute("days", sDF7.format(Long.parseLong(Integer.toBinaryString(timeLocation.getDayCode()))));
                    timeEl.addAttribute("start", String.valueOf(timeLocation.getStartSlot()));
                    timeEl.addAttribute("length", String.valueOf(timeLocation.getLength()));
                    if (timeLocation.getBreakTime() != 0) {
                        timeEl.addAttribute("breakTime", String.valueOf(timeLocation.getBreakTime()));
                    }
                    if (timeLocation.getTimePatternId() != null) {
                        timeEl.addAttribute("pattern", timeLocation.getTimePatternId().toString());
                    }
                    if (timeLocation.getDatePatternId() != null) {
                        timeEl.addAttribute("datePattern", timeLocation.getDatePatternId().toString());
                    }
                    if (timeLocation.getDatePatternName() != null && !timeLocation.getDatePatternName().isEmpty()) {
                        timeEl.addAttribute("datePatternName", timeLocation.getDatePatternName());
                    }
                    if (timeLocation.getWeekCode() != null) {
                        timeEl.addAttribute("dates", InstructorSchedulingModel.bitset2string(timeLocation.getWeekCode()));
                    }
                    timeEl.setText(timeLocation.getLongName(false));
                }
                if (section.hasRoom()) {
                    sectionEl.addAttribute("room", section.getRoom());
                }
                if (section.isAllowOverlap()) {
                    sectionEl.addAttribute("canOverlap", "true");
                }
                if (!section.isCommon()) continue;
                sectionEl.addAttribute("common", "true");
            }
            requestEl.addAttribute("load", sDoubleFormat.format(teachingRequest.getLoad()));
            requestEl.addAttribute("sameCourse", Constants.preferenceLevel2preference(teachingRequest.getSameCoursePreference()));
            requestEl.addAttribute("sameCommon", Constants.preferenceLevel2preference(teachingRequest.getSameCommonPreference()));
            for (Preference<Attribute> preference : teachingRequest.getAttributePreferences()) {
                Element attributeEl = requestEl.addElement("attribute");
                if (preference.getTarget().getAttributeId() != null) {
                    attributeEl.addAttribute("id", String.valueOf(preference.getTarget().getAttributeId()));
                }
                attributeEl.addAttribute("name", preference.getTarget().getAttributeName());
                attributeEl.addAttribute("type", preference.getTarget().getType().getTypeName());
                attributeEl.addAttribute("preference", preference.isRequired() ? "R" : (preference.isProhibited() ? "P" : String.valueOf(preference.getPreference())));
                if (preference.getTarget().getParentAttribute() == null || preference.getTarget().getParentAttribute().getAttributeId() == null) continue;
                attributeEl.addAttribute("parent", String.valueOf(preference.getTarget().getParentAttribute().getAttributeId()));
            }
            for (Preference<Instructor> preference : teachingRequest.getInstructorPreferences()) {
                Element instructorEl2 = requestEl.addElement("instructor");
                instructorEl2.addAttribute("id", String.valueOf(preference.getTarget().getInstructorId()));
                if (preference.getTarget().hasExternalId()) {
                    instructorEl2.addAttribute("externalId", preference.getTarget().getExternalId());
                }
                if (preference.getTarget().hasName()) {
                    instructorEl2.addAttribute("name", preference.getTarget().getName());
                }
                instructorEl2.addAttribute("preference", preference.isRequired() ? "R" : (preference.isProhibited() ? "P" : String.valueOf(preference.getPreference())));
            }
            if (saveBest) {
                for (TeachingRequest.Variable variable : teachingRequest.getVariables()) {
                    if (variable.getBestAssignment() == null) continue;
                    instructor = ((TeachingAssignment)variable.getBestAssignment()).getInstructor();
                    instructorEl = requestEl.addElement("best-instructor");
                    instructorEl.addAttribute("id", String.valueOf(instructor.getInstructorId()));
                    if (teachingRequest.getNrInstructors() != 1) {
                        instructorEl.addAttribute("index", String.valueOf(variable.getInstructorIndex()));
                    }
                    if (instructor.hasExternalId()) {
                        instructorEl.addAttribute("externalId", instructor.getExternalId());
                    }
                    if (!instructor.hasName()) continue;
                    instructorEl.addAttribute("name", instructor.getName());
                }
            }
            if (saveInitial) {
                for (TeachingRequest.Variable variable : teachingRequest.getVariables()) {
                    if (variable.getInitialAssignment() == null) continue;
                    instructor = ((TeachingAssignment)variable.getInitialAssignment()).getInstructor();
                    instructorEl = requestEl.addElement("initial-instructor");
                    instructorEl.addAttribute("id", String.valueOf(instructor.getInstructorId()));
                    if (teachingRequest.getNrInstructors() != 1) {
                        instructorEl.addAttribute("index", String.valueOf(variable.getInstructorIndex()));
                    }
                    if (instructor.hasExternalId()) {
                        instructorEl.addAttribute("externalId", instructor.getExternalId());
                    }
                    if (!instructor.hasName()) continue;
                    instructorEl.addAttribute("name", instructor.getName());
                }
            }
            if (!saveSolution) continue;
            for (TeachingRequest.Variable variable : teachingRequest.getVariables()) {
                TeachingAssignment ta = assignment.getValue(variable);
                if (ta == null) continue;
                Instructor instructor2 = ta.getInstructor();
                Element instructorEl3 = requestEl.addElement("assigned-instructor");
                instructorEl3.addAttribute("id", String.valueOf(instructor2.getInstructorId()));
                if (teachingRequest.getNrInstructors() != 1) {
                    instructorEl3.addAttribute("index", String.valueOf(variable.getInstructorIndex()));
                }
                if (instructor2.hasExternalId()) {
                    instructorEl3.addAttribute("externalId", instructor2.getExternalId());
                }
                if (!instructor2.hasName()) continue;
                instructorEl3.addAttribute("name", instructor2.getName());
            }
        }
        Element element = root.addElement("instructors");
        for (Instructor instructor : this.getInstructors()) {
            Element instructorEl = element.addElement("instructor");
            instructorEl.addAttribute("id", String.valueOf(instructor.getInstructorId()));
            if (instructor.hasExternalId()) {
                instructorEl.addAttribute("externalId", instructor.getExternalId());
            }
            if (instructor.hasName()) {
                instructorEl.addAttribute("name", instructor.getName());
            }
            if (instructor.getPreference() != 0) {
                instructorEl.addAttribute("preference", String.valueOf(instructor.getPreference()));
            }
            if (instructor.getBackToBackPreference() != 0) {
                instructorEl.addAttribute("btb", String.valueOf(instructor.getBackToBackPreference()));
            }
            if (instructor.getSameDaysPreference() != 0) {
                instructorEl.addAttribute("same-days", String.valueOf(instructor.getSameDaysPreference()));
            }
            if (instructor.getSameRoomPreference() != 0) {
                instructorEl.addAttribute("same-room", String.valueOf(instructor.getSameRoomPreference()));
            }
            for (Attribute attribute : instructor.getAttributes()) {
                Element element3 = instructorEl.addElement("attribute");
                if (attribute.getAttributeId() != null) {
                    element3.addAttribute("id", String.valueOf(attribute.getAttributeId()));
                }
                element3.addAttribute("name", attribute.getAttributeName());
                element3.addAttribute("type", attribute.getType().getTypeName());
                if (attribute.getParentAttribute() == null || attribute.getParentAttribute().getAttributeId() == null) continue;
                element3.addAttribute("parent", String.valueOf(attribute.getParentAttribute().getAttributeId()));
            }
            instructorEl.addAttribute("maxLoad", sDoubleFormat.format(instructor.getMaxLoad()));
            for (GroupConstraint.Distribution distribution : instructor.getDistributions()) {
                Element element4 = instructorEl.addElement("distribution");
                element4.addAttribute("type", distribution.getType().reference());
                element4.addAttribute("preference", distribution.getPreference());
                element4.addAttribute("name", distribution.getType().getName());
            }
            for (Preference preference : instructor.getTimePreferences()) {
                Element element5 = instructorEl.addElement("time");
                TimeLocation tl = (TimeLocation)preference.getTarget();
                element5.addAttribute("days", sDF7.format(Long.parseLong(Integer.toBinaryString(tl.getDayCode()))));
                element5.addAttribute("start", String.valueOf(tl.getStartSlot()));
                element5.addAttribute("length", String.valueOf(tl.getLength()));
                if (tl.getBreakTime() != 0) {
                    element5.addAttribute("breakTime", String.valueOf(tl.getBreakTime()));
                }
                if (tl.getTimePatternId() != null) {
                    element5.addAttribute("pattern", tl.getTimePatternId().toString());
                }
                if (tl.getDatePatternId() != null) {
                    element5.addAttribute("datePattern", tl.getDatePatternId().toString());
                }
                if (tl.getDatePatternName() != null && !tl.getDatePatternName().isEmpty()) {
                    element5.addAttribute("datePatternName", tl.getDatePatternName());
                }
                if (tl.getWeekCode() != null) {
                    element5.addAttribute("dates", InstructorSchedulingModel.bitset2string(tl.getWeekCode()));
                }
                element5.addAttribute("preference", preference.isProhibited() ? "P" : (preference.isRequired() ? "R" : String.valueOf(preference.getPreference())));
                if (preference.getTarget() instanceof EnrolledClass) {
                    Element element6 = element5.addElement("section");
                    Element courseEl = null;
                    EnrolledClass ec = (EnrolledClass)preference.getTarget();
                    if (ec.getCourseId() != null || ec.getCourse() != null) {
                        courseEl = element5.addElement("course");
                        if (ec.getCourseId() != null) {
                            courseEl.addAttribute("id", String.valueOf(ec.getCourseId()));
                        }
                        if (ec.getCourse() != null) {
                            courseEl.addAttribute("name", ec.getCourse());
                        }
                    }
                    if (ec.getClassId() != null) {
                        element6.addAttribute("id", String.valueOf(ec.getClassId()));
                    }
                    if (ec.getType() != null) {
                        element6.addAttribute("type", ec.getType());
                    }
                    if (ec.getSection() != null) {
                        element6.addAttribute("name", ec.getSection());
                    }
                    if (ec.getExternalId() != null) {
                        element6.addAttribute("externalId", ec.getExternalId());
                    }
                    if (ec.getRoom() != null) {
                        element6.addAttribute("room", ec.getRoom());
                    }
                    element6.addAttribute("role", ec.isInstructor() ? "instructor" : "student");
                    continue;
                }
                element5.setText(tl.getLongName(false));
            }
            for (Preference preference : instructor.getCoursePreferences()) {
                Element element7 = instructorEl.addElement("course");
                Course course = (Course)preference.getTarget();
                if (course.getCourseId() != null) {
                    element7.addAttribute("id", String.valueOf(course.getCourseId()));
                }
                if (course.getCourseName() != null) {
                    element7.addAttribute("name", String.valueOf(course.getCourseName()));
                }
                element7.addAttribute("preference", preference.isProhibited() ? "P" : (preference.isRequired() ? "R" : String.valueOf(preference.getPreference())));
            }
        }
        Element element8 = root.addElement("constraints");
        for (Constraint c : this.constraints()) {
            ConstraintWithContext si;
            if (c instanceof SameInstructorConstraint) {
                si = (SameInstructorConstraint)c;
                Element element9 = element8.addElement("same-instructor");
                if (((SameInstructorConstraint)si).getConstraintId() != null) {
                    element9.addAttribute("id", String.valueOf(((SameInstructorConstraint)si).getConstraintId()));
                }
                if (((SameInstructorConstraint)si).getName() != null) {
                    element9.addAttribute("name", ((SameInstructorConstraint)si).getName());
                }
                element9.addAttribute("preference", Constants.preferenceLevel2preference(((SameInstructorConstraint)si).getPreference()));
                for (TeachingRequest.Variable request : c.variables()) {
                    Element element10 = element9.addElement("request");
                    element10.addAttribute("id", String.valueOf(request.getRequest().getRequestId()));
                    if (request.getRequest().getNrInstructors() == 1) continue;
                    element10.addAttribute("index", String.valueOf(request.getInstructorIndex()));
                }
                continue;
            }
            if (!(c instanceof SameLinkConstraint)) continue;
            si = (SameLinkConstraint)c;
            Element element11 = element8.addElement("same-link");
            if (((SameLinkConstraint)si).getConstraintId() != null) {
                element11.addAttribute("id", String.valueOf(((SameLinkConstraint)si).getConstraintId()));
            }
            if (((SameLinkConstraint)si).getName() != null) {
                element11.addAttribute("name", ((SameLinkConstraint)si).getName());
            }
            element11.addAttribute("preference", Constants.preferenceLevel2preference(((SameLinkConstraint)si).getPreference()));
            for (TeachingRequest.Variable request : c.variables()) {
                Element element12 = element11.addElement("request");
                element12.addAttribute("id", String.valueOf(request.getRequest().getRequestId()));
                if (request.getRequest().getNrInstructors() == 1) continue;
                element12.addAttribute("index", String.valueOf(request.getInstructorIndex()));
            }
        }
        return document;
    }

    public boolean load(Document document, Assignment<TeachingRequest.Variable, TeachingAssignment> assignment) {
        TeachingRequest.Variable variable;
        TeachingRequest request;
        Element courseEl;
        boolean loadInitial = this.getProperties().getPropertyBoolean("Xml.LoadInitial", true);
        boolean loadBest = this.getProperties().getPropertyBoolean("Xml.LoadBest", true);
        boolean loadSolution = this.getProperties().getPropertyBoolean("Xml.LoadSolution", true);
        String defaultBtb = this.getProperties().getProperty("Defaults.BackToBack", "0");
        String defaultSameDays = this.getProperties().getProperty("Defaults.SameDays", "0");
        String defaultSameRoom = this.getProperties().getProperty("Defaults.SameRoom", "0");
        String defaultConjunctive = this.getProperties().getProperty("Defaults.Conjunctive", "false");
        String defaultRequired = this.getProperties().getProperty("Defaults.Required", "false");
        String defaultSameCourse = this.getProperties().getProperty("Defaults.SameCourse", "R");
        String defaultSameCommon = this.getProperties().getProperty("Defaults.SameCommon", "R");
        Element root = document.getRootElement();
        if (!"instructor-schedule".equals(root.getName())) {
            return false;
        }
        HashMap<String, Attribute.Type> types = new HashMap<String, Attribute.Type>();
        HashMap<Long, Attribute> attributes = new HashMap<Long, Attribute>();
        HashMap<Long, Long> parents = new HashMap<Long, Long>();
        if (root.element("attributes") != null) {
            Iterator i = root.element("attributes").elementIterator("type");
            while (i.hasNext()) {
                Element typeEl = (Element)i.next();
                Attribute.Type type = new Attribute.Type(Long.parseLong(typeEl.attributeValue("id")), typeEl.attributeValue("name"), "true".equalsIgnoreCase(typeEl.attributeValue("conjunctive", defaultConjunctive)), "true".equalsIgnoreCase(typeEl.attributeValue("required", defaultRequired)));
                this.addAttributeType(type);
                if (type.getTypeName() != null) {
                    types.put(type.getTypeName(), type);
                }
                Iterator j = typeEl.elementIterator("attribute");
                while (j.hasNext()) {
                    Element attributeEl = (Element)j.next();
                    Attribute attribute = new Attribute(Long.parseLong(attributeEl.attributeValue("id")), attributeEl.attributeValue("name"), type);
                    attributes.put(attribute.getAttributeId(), attribute);
                    if (attributeEl.attributeValue("parent") == null) continue;
                    parents.put(attribute.getAttributeId(), Long.parseLong(attributeEl.attributeValue("parent")));
                }
            }
        }
        HashMap<Long, Course> courses = new HashMap<Long, Course>();
        if (root.element("courses") != null) {
            Iterator i = root.element("courses").elementIterator("course");
            while (i.hasNext()) {
                Element courseEl2 = (Element)i.next();
                Course course = new Course(Long.parseLong(courseEl2.attributeValue("id")), courseEl2.attributeValue("name"));
                courses.put(course.getCourseId(), course);
            }
        }
        HashMap<Long, Instructor> instructors = new HashMap<Long, Instructor>();
        Iterator i = root.element("instructors").elementIterator("instructor");
        while (i.hasNext()) {
            Element f;
            Element instructorEl = (Element)i.next();
            Instructor instructor = new Instructor(Long.parseLong(instructorEl.attributeValue("id")), instructorEl.attributeValue("externalId"), instructorEl.attributeValue("name"), InstructorSchedulingModel.string2preference(instructorEl.attributeValue("preference")), Float.parseFloat(instructorEl.attributeValue("maxLoad", "0")));
            instructor.setBackToBackPreference(Integer.valueOf(instructorEl.attributeValue("btb", defaultBtb)));
            instructor.setSameDaysPreference(Integer.valueOf(instructorEl.attributeValue("same-days", defaultSameDays)));
            instructor.setSameRoomPreference(Integer.valueOf(instructorEl.attributeValue("same-room", defaultSameRoom)));
            Iterator j = instructorEl.elementIterator("attribute");
            while (j.hasNext()) {
                f = (Element)j.next();
                Long attributeId = Long.valueOf(f.attributeValue("id"));
                Attribute attribute = (Attribute)attributes.get(attributeId);
                if (attribute == null) {
                    Attribute.Type type = (Attribute.Type)types.get(f.attributeValue("type"));
                    if (type == null) {
                        type = new Attribute.Type(types.size(), f.attributeValue("type"), "true".equalsIgnoreCase(f.attributeValue("conjunctive", defaultConjunctive)), "true".equalsIgnoreCase(f.attributeValue("required", defaultRequired)));
                        types.put(type.getTypeName(), type);
                    }
                    attribute = new Attribute(attributeId, f.attributeValue("name"), type);
                    attributes.put(attributeId, attribute);
                    if (f.attributeValue("parent") != null) {
                        parents.put(attribute.getAttributeId(), Long.parseLong(f.attributeValue("parent")));
                    }
                }
                instructor.addAttribute(attribute);
            }
            j = instructorEl.elementIterator("distribution");
            while (j.hasNext()) {
                Element dEl = (Element)j.next();
                instructor.addDistribution(dEl.attributeValue("type"), dEl.attributeValue("preference", "0"), dEl.attributeValue("name"));
            }
            j = instructorEl.elementIterator("time");
            while (j.hasNext()) {
                f = (Element)j.next();
                Element classEl = f.element("section");
                courseEl = f.element("course");
                TimeLocation time = null;
                time = classEl != null ? new EnrolledClass(courseEl == null || courseEl.attributeValue("id") == null ? null : Long.valueOf(courseEl.attributeValue("id")), classEl.attributeValue("id") == null ? null : Long.valueOf(classEl.attributeValue("id")), courseEl == null ? null : courseEl.attributeValue("name"), classEl.attributeValue("type"), classEl.attributeValue("name"), classEl.attributeValue("externalId"), Integer.parseInt(f.attributeValue("days"), 2), Integer.parseInt(f.attributeValue("start")), Integer.parseInt(f.attributeValue("length")), f.attributeValue("datePattern") == null ? null : Long.valueOf(f.attributeValue("datePattern")), f.attributeValue("datePatternName", ""), InstructorSchedulingModel.createBitSet(f.attributeValue("dates")), Integer.parseInt(f.attributeValue("breakTime", "0")), classEl.attributeValue("room"), "instructor".equalsIgnoreCase(classEl.attributeValue("role", "instructor"))) : new TimeLocation(Integer.parseInt(f.attributeValue("days"), 2), Integer.parseInt(f.attributeValue("start")), Integer.parseInt(f.attributeValue("length")), 0, 0.0, f.attributeValue("datePattern") == null ? null : Long.valueOf(f.attributeValue("datePattern")), f.attributeValue("datePatternName", ""), InstructorSchedulingModel.createBitSet(f.attributeValue("dates")), Integer.parseInt(f.attributeValue("breakTime", "0")));
                if (f.attributeValue("pattern") != null) {
                    time.setTimePatternId(Long.valueOf(f.attributeValue("pattern")));
                }
                instructor.addTimePreference(new Preference<TimeLocation>(time, InstructorSchedulingModel.string2preference(f.attributeValue("preference"))));
            }
            j = instructorEl.elementIterator("course");
            while (j.hasNext()) {
                f = (Element)j.next();
                instructor.addCoursePreference(new Preference<Course>(new Course(Long.parseLong(f.attributeValue("id")), f.attributeValue("name")), InstructorSchedulingModel.string2preference(f.attributeValue("preference"))));
            }
            this.addInstructor(instructor);
            instructors.put(instructor.getInstructorId(), instructor);
        }
        HashMap<Long, TeachingRequest> requests = new HashMap<Long, TeachingRequest>();
        HashMap current = new HashMap();
        HashMap best = new HashMap();
        HashMap initial = new HashMap();
        Iterator i2 = root.element("teaching-requests").elementIterator("request");
        while (i2.hasNext()) {
            Instructor instructor;
            Map<Integer, Instructor> idx2inst;
            Element f;
            Element requestEl = (Element)i2.next();
            courseEl = requestEl.element("course");
            Course course = null;
            if (courseEl != null) {
                Long courseId = Long.valueOf(courseEl.attributeValue("id"));
                course = (Course)courses.get(courseId);
                if (course == null) {
                    course = new Course(courseId, courseEl.attributeValue("name"));
                }
            } else {
                course = (Course)courses.get(Long.valueOf(requestEl.attributeValue("course")));
            }
            ArrayList<Section> sections = new ArrayList<Section>();
            Iterator j = requestEl.elementIterator("section");
            while (j.hasNext()) {
                Element f2 = (Element)j.next();
                TimeLocation time = null;
                Element timeEl = f2.element("time");
                if (timeEl != null) {
                    time = new TimeLocation(Integer.parseInt(timeEl.attributeValue("days"), 2), Integer.parseInt(timeEl.attributeValue("start")), Integer.parseInt(timeEl.attributeValue("length")), 0, 0.0, timeEl.attributeValue("datePattern") == null ? null : Long.valueOf(timeEl.attributeValue("datePattern")), timeEl.attributeValue("datePatternName", ""), InstructorSchedulingModel.createBitSet(timeEl.attributeValue("dates")), Integer.parseInt(timeEl.attributeValue("breakTime", "0")));
                    if (timeEl.attributeValue("pattern") != null) {
                        time.setTimePatternId(Long.valueOf(timeEl.attributeValue("pattern")));
                    }
                }
                Section section = new Section(Long.valueOf(f2.attributeValue("id")), f2.attributeValue("externalId"), f2.attributeValue("type"), f2.attributeValue("name"), time, f2.attributeValue("room"), "true".equalsIgnoreCase(f2.attributeValue("canOverlap", "false")), "true".equalsIgnoreCase(f2.attributeValue("common", "false")));
                sections.add(section);
            }
            request = new TeachingRequest(Long.parseLong(requestEl.attributeValue("id")), Integer.parseInt(requestEl.attributeValue("nrInstructors", "1")), course, Float.valueOf(requestEl.attributeValue("load", "0")).floatValue(), sections, Constants.preference2preferenceLevel(requestEl.attributeValue("sameCourse", defaultSameCourse)), Constants.preference2preferenceLevel(requestEl.attributeValue("sameCommon", defaultSameCommon)));
            requests.put(request.getRequestId(), request);
            Iterator j2 = requestEl.elementIterator("attribute");
            while (j2.hasNext()) {
                f = (Element)j2.next();
                Long attributeId = Long.valueOf(f.attributeValue("id"));
                Attribute attribute = (Attribute)attributes.get(attributeId);
                if (attribute == null) {
                    Attribute.Type type = (Attribute.Type)types.get(f.attributeValue("type"));
                    if (type == null) {
                        type = new Attribute.Type(types.size(), f.attributeValue("type"), "true".equalsIgnoreCase(f.attributeValue("conjunctive", defaultConjunctive)), "true".equalsIgnoreCase(f.attributeValue("required", defaultRequired)));
                        types.put(type.getTypeName(), type);
                    }
                    attribute = new Attribute(attributeId, f.attributeValue("name"), type);
                    attributes.put(attributeId, attribute);
                    if (f.attributeValue("parent") != null) {
                        parents.put(attribute.getAttributeId(), Long.parseLong(f.attributeValue("parent")));
                    }
                }
                request.addAttributePreference(new Preference<Attribute>(attribute, InstructorSchedulingModel.string2preference(f.attributeValue("preference"))));
            }
            j2 = requestEl.elementIterator("instructor");
            while (j2.hasNext()) {
                f = (Element)j2.next();
                Long instructorId = Long.valueOf(f.attributeValue("id"));
                Instructor instructor2 = (Instructor)instructors.get(instructorId);
                if (instructor2 == null) continue;
                request.addInstructorPreference(new Preference<Instructor>(instructor2, InstructorSchedulingModel.string2preference(f.attributeValue("preference"))));
            }
            if (loadBest) {
                j2 = requestEl.elementIterator("best-instructor");
                while (j2.hasNext()) {
                    f = (Element)j2.next();
                    idx2inst = (HashMap<Integer, Instructor>)best.get(request);
                    if (idx2inst == null) {
                        idx2inst = new HashMap<Integer, Instructor>();
                        best.put(request, idx2inst);
                    }
                    int index = 1 + Integer.parseInt(f.attributeValue("index", String.valueOf(idx2inst.size())));
                    instructor = (Instructor)instructors.get(Long.valueOf(f.attributeValue("id")));
                    if (instructor == null) continue;
                    idx2inst.put(index, instructor);
                }
            }
            if (loadInitial) {
                j2 = requestEl.elementIterator("initial-instructor");
                while (j2.hasNext()) {
                    f = (Element)j2.next();
                    idx2inst = (Map)initial.get(request);
                    if (idx2inst == null) {
                        idx2inst = new HashMap();
                        initial.put(request, idx2inst);
                    }
                    int index = 1 + Integer.parseInt(f.attributeValue("index", String.valueOf(idx2inst.size())));
                    instructor = (Instructor)instructors.get(Long.valueOf(f.attributeValue("id")));
                    if (instructor == null) continue;
                    idx2inst.put(index, instructor);
                }
            }
            if (loadSolution) {
                j2 = requestEl.elementIterator("assigned-instructor");
                while (j2.hasNext()) {
                    f = (Element)j2.next();
                    idx2inst = (Map)current.get(request);
                    if (idx2inst == null) {
                        idx2inst = new HashMap();
                        current.put(request, idx2inst);
                    }
                    int index = Integer.parseInt(f.attributeValue("index", String.valueOf(idx2inst.size())));
                    instructor = (Instructor)instructors.get(Long.valueOf(f.attributeValue("id")));
                    if (instructor == null) continue;
                    idx2inst.put(index, instructor);
                }
            }
            this.addRequest(request);
        }
        if (root.element("constraints") != null) {
            i2 = root.element("constraints").elementIterator();
            while (i2.hasNext()) {
                Element constraintEl = (Element)i2.next();
                ConstraintWithContext constraint = null;
                if ("same-link".equals(constraintEl.getName())) {
                    constraint = new SameLinkConstraint(constraintEl.attributeValue("id") == null ? null : Long.valueOf(constraintEl.attributeValue("id")), constraintEl.attributeValue("name"), constraintEl.attributeValue("preference"));
                } else if ("same-instructor".equals(constraintEl.getName())) {
                    constraint = new SameInstructorConstraint(constraintEl.attributeValue("id") == null ? null : Long.valueOf(constraintEl.attributeValue("id")), constraintEl.attributeValue("name"), constraintEl.attributeValue("preference"));
                }
                if (constraint == null) continue;
                Iterator j = constraintEl.elementIterator("request");
                while (j.hasNext()) {
                    int index;
                    Element f = (Element)j.next();
                    request = (TeachingRequest)requests.get(Long.valueOf(f.attributeValue("id")));
                    if (request == null || (index = Integer.valueOf(f.attributeValue("index", "0")).intValue()) < 0 || index >= request.getNrInstructors()) continue;
                    constraint.addVariable(request.getVariables()[index]);
                }
                this.addConstraint(constraint);
            }
        }
        for (Map.Entry e : parents.entrySet()) {
            ((Attribute)attributes.get(e.getKey())).setParentAttribute((Attribute)attributes.get(e.getValue()));
        }
        for (Map.Entry e1 : best.entrySet()) {
            for (Map.Entry e2 : ((Map)e1.getValue()).entrySet()) {
                if ((Integer)e2.getKey() < 0 || (Integer)e2.getKey() >= ((TeachingRequest)e1.getKey()).getNrInstructors()) continue;
                variable = ((TeachingRequest)e1.getKey()).getVariables()[(Integer)e2.getKey()];
                variable.setBestAssignment(new TeachingAssignment(variable, (Instructor)e2.getValue()), 0L);
            }
        }
        for (Map.Entry e1 : initial.entrySet()) {
            for (Map.Entry e2 : ((Map)e1.getValue()).entrySet()) {
                if ((Integer)e2.getKey() < 0 || (Integer)e2.getKey() >= ((TeachingRequest)e1.getKey()).getNrInstructors()) continue;
                variable = ((TeachingRequest)e1.getKey()).getVariables()[(Integer)e2.getKey()];
                variable.setInitialAssignment(new TeachingAssignment(variable, (Instructor)e2.getValue()));
            }
        }
        if (!current.isEmpty()) {
            for (Map.Entry e1 : current.entrySet()) {
                for (Map.Entry e2 : ((Map)e1.getValue()).entrySet()) {
                    if ((Integer)e2.getKey() < 0 || (Integer)e2.getKey() >= ((TeachingRequest)e1.getKey()).getNrInstructors()) continue;
                    variable = ((TeachingRequest)e1.getKey()).getVariables()[(Integer)e2.getKey()];
                    TeachingAssignment ta = new TeachingAssignment(variable, (Instructor)e2.getValue());
                    Set<TeachingAssignment> conf = this.conflictValues(assignment, ta);
                    if (conf.isEmpty()) {
                        assignment.assign(0L, ta);
                        continue;
                    }
                    sLog.error("Unable to assign " + ta.getName() + " to " + variable.getName());
                    sLog.error("Conflicts:" + ToolBox.dict2string(this.conflictConstraints(assignment, ta), 2));
                }
            }
        }
        return true;
    }

    protected static String bitset2string(BitSet b) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < b.length(); ++i) {
            sb.append(b.get(i) ? "1" : "0");
        }
        return sb.toString();
    }

    protected static BitSet createBitSet(String bitString) {
        if (bitString == null) {
            return null;
        }
        BitSet ret = new BitSet(bitString.length());
        for (int i = 0; i < bitString.length(); ++i) {
            if (bitString.charAt(i) != '1') continue;
            ret.set(i);
        }
        return ret;
    }

    protected static int string2preference(String pref) {
        if (pref == null || pref.isEmpty()) {
            return 0;
        }
        if ("R".equals(pref)) {
            return Constants.sPreferenceLevelRequired;
        }
        if ("P".equals(pref)) {
            return Constants.sPreferenceLevelProhibited;
        }
        return Integer.valueOf(pref);
    }

    public List<BitSet> getWeeks() {
        block15: {
            if (this.iWeeks != null) break block15;
            String defaultDatePattern = this.getProperties().getProperty("DatePattern.CustomDatePattern", null);
            if (defaultDatePattern == null) {
                defaultDatePattern = this.getProperties().getProperty("DatePattern.Default");
            }
            BitSet fullTerm = null;
            if (defaultDatePattern == null) {
                HashMap<Long, Integer> counter = new HashMap<Long, Integer>();
                int max = 0;
                String name = null;
                Long id = null;
                for (TeachingRequest.Variable tr : this.variables()) {
                    for (Section section : tr.getSections()) {
                        TimeLocation time = section.getTime();
                        if (time.getWeekCode() == null || time.getDatePatternId() == null) continue;
                        int count = 1;
                        if (counter.containsKey(time.getDatePatternId())) {
                            count += ((Integer)counter.get(time.getDatePatternId())).intValue();
                        }
                        counter.put(time.getDatePatternId(), count);
                        if (count <= max) continue;
                        max = count;
                        fullTerm = time.getWeekCode();
                        name = time.getDatePatternName();
                        id = time.getDatePatternId();
                    }
                }
                sLog.info("Using date pattern " + name + " (id " + id + ") as the default.");
            } else {
                fullTerm = new BitSet(defaultDatePattern.length());
                for (int i = 0; i < defaultDatePattern.length(); ++i) {
                    if (defaultDatePattern.charAt(i) != '1') continue;
                    fullTerm.set(i);
                }
            }
            if (fullTerm == null) {
                return null;
            }
            this.iWeeks = new ArrayList<BitSet>();
            if (this.getProperties().getPropertyBoolean("DatePattern.ShiftWeeks", false)) {
                int i = fullTerm.nextSetBit(0);
                while (i < fullTerm.length()) {
                    if (!fullTerm.get(i)) {
                        ++i;
                        continue;
                    }
                    BitSet w = new BitSet(i + 7);
                    for (int j = 0; j < 7; ++j) {
                        if (!fullTerm.get(i + j)) continue;
                        w.set(i + j);
                    }
                    this.iWeeks.add(w);
                    i += 7;
                }
            } else {
                for (int i = fullTerm.nextSetBit(0); i < fullTerm.length(); i += 7) {
                    BitSet w = new BitSet(i + 7);
                    for (int j = 0; j < 7; ++j) {
                        if (!fullTerm.get(i + j)) continue;
                        w.set(i + j);
                    }
                    this.iWeeks.add(w);
                }
            }
        }
        return this.iWeeks;
    }
}

