/*
 * Decompiled with CFR 0.152.
 */
package org.cpsolver.instructor.constraints;

import java.util.HashSet;
import java.util.Set;
import org.cpsolver.coursett.Constants;
import org.cpsolver.ifs.assignment.Assignment;
import org.cpsolver.ifs.assignment.context.AssignmentConstraintContext;
import org.cpsolver.ifs.assignment.context.ConstraintWithContext;
import org.cpsolver.instructor.criteria.SameLink;
import org.cpsolver.instructor.model.Instructor;
import org.cpsolver.instructor.model.TeachingAssignment;
import org.cpsolver.instructor.model.TeachingRequest;

public class SameLinkConstraint
extends ConstraintWithContext<TeachingRequest.Variable, TeachingAssignment, Context> {
    private Long iId;
    private String iName;
    private int iPreference = 0;
    private boolean iRequired = false;
    private boolean iProhibited = false;

    public SameLinkConstraint(Long id, String name, String preference) {
        this.iId = id;
        this.iName = name;
        this.iPreference = Constants.preference2preferenceLevel(preference);
        if ("R".equals(preference)) {
            this.iRequired = true;
        } else if ("P".equals(preference)) {
            this.iProhibited = true;
        }
    }

    public Long getConstraintId() {
        return this.iId;
    }

    @Override
    public String getName() {
        return this.iName;
    }

    public String toString() {
        return "Same Link " + this.getName();
    }

    public boolean isRequired() {
        return this.iRequired;
    }

    public boolean isProhibited() {
        return this.iProhibited;
    }

    public int getPreference() {
        return this.iPreference;
    }

    @Override
    public boolean isHard() {
        return this.isRequired() || this.isProhibited();
    }

    @Override
    public void computeConflicts(Assignment<TeachingRequest.Variable, TeachingAssignment> assignment, TeachingAssignment value, Set<TeachingAssignment> conflicts) {
        if (this.isHard()) {
            Instructor.Context context = (Instructor.Context)value.getInstructor().getContext(assignment);
            for (TeachingAssignment ta : context.getAssignments()) {
                if (((TeachingRequest.Variable)ta.variable()).equals(value.variable()) || conflicts.contains(ta)) continue;
                if (this.isRequired() && !this.variables().contains(ta.variable())) {
                    conflicts.add(ta);
                }
                if (!this.isProhibited() || !this.variables().contains(ta.variable())) continue;
                conflicts.add(ta);
            }
        }
    }

    public int getCurrentPreference(Assignment<TeachingRequest.Variable, TeachingAssignment> assignment, TeachingAssignment value) {
        int ret;
        block9: {
            TeachingAssignment current;
            block8: {
                if (this.isHard()) {
                    return 0;
                }
                current = assignment.getValue((TeachingRequest.Variable)value.variable());
                if (current != null && current.getInstructor().equals(value.getInstructor())) {
                    return 0;
                }
                ret = 0;
                if (this.getPreference() >= 0) break block8;
                for (TeachingAssignment other : ((Instructor.Context)value.getInstructor().getContext(assignment)).getAssignments()) {
                    if (this.variables().equals(value.variable()) || this.variables().contains(other.variable())) continue;
                    ++ret;
                }
                if (current == null) break block9;
                for (TeachingAssignment other : ((Instructor.Context)current.getInstructor().getContext(assignment)).getAssignments()) {
                    if (this.variables().equals(value.variable()) || this.variables().contains(other.variable())) continue;
                    --ret;
                }
                break block9;
            }
            if (this.getPreference() > 0) {
                for (TeachingAssignment other : ((Instructor.Context)value.getInstructor().getContext(assignment)).getAssignments()) {
                    if (this.variables().equals(value.variable()) || !this.variables().contains(other.variable())) continue;
                    ++ret;
                }
                if (current != null) {
                    for (TeachingAssignment other : ((Instructor.Context)current.getInstructor().getContext(assignment)).getAssignments()) {
                        if (this.variables().equals(value.variable()) || !this.variables().contains(other.variable())) continue;
                        --ret;
                    }
                }
            }
        }
        return ret;
    }

    public int getCurrentPreference(Assignment<TeachingRequest.Variable, TeachingAssignment> assignment) {
        if (this.isHard()) {
            return 0;
        }
        if (this.getPreference() < 0) {
            int ret = 0;
            HashSet<Instructor> checked = new HashSet<Instructor>();
            for (TeachingRequest.Variable tr : this.variables()) {
                TeachingAssignment ta = assignment.getValue(tr);
                if (ta == null || !checked.add(ta.getInstructor())) continue;
                Instructor.Context context = (Instructor.Context)ta.getInstructor().getContext(assignment);
                for (TeachingAssignment other : context.getAssignments()) {
                    if (this.variables().contains(other.variable())) continue;
                    ++ret;
                }
            }
            return ret;
        }
        if (this.getPreference() > 0) {
            int ret = 0;
            HashSet<Instructor> checked = new HashSet<Instructor>();
            for (TeachingRequest.Variable tr : this.variables()) {
                TeachingAssignment ta = assignment.getValue(tr);
                if (ta == null || !checked.add(ta.getInstructor())) continue;
                Instructor.Context context = (Instructor.Context)ta.getInstructor().getContext(assignment);
                for (TeachingAssignment other : context.getAssignments()) {
                    if (this.variables().equals(tr) || !this.variables().contains(other.variable())) continue;
                    ++ret;
                }
            }
            return ret;
        }
        return 0;
    }

    @Override
    public Context createAssignmentContext(Assignment<TeachingRequest.Variable, TeachingAssignment> assignment) {
        return new Context(assignment);
    }

    public class Context
    implements AssignmentConstraintContext<TeachingRequest.Variable, TeachingAssignment> {
        private int iLastPreference = 0;

        public Context(Assignment<TeachingRequest.Variable, TeachingAssignment> assignment) {
            this.updateCriterion(assignment);
        }

        @Override
        public void assigned(Assignment<TeachingRequest.Variable, TeachingAssignment> assignment, TeachingAssignment value) {
            this.updateCriterion(assignment);
        }

        @Override
        public void unassigned(Assignment<TeachingRequest.Variable, TeachingAssignment> assignment, TeachingAssignment value) {
            this.updateCriterion(assignment);
        }

        private void updateCriterion(Assignment<TeachingRequest.Variable, TeachingAssignment> assignment) {
            if (!SameLinkConstraint.this.isHard()) {
                SameLinkConstraint.this.getModel().getCriterion(SameLink.class).inc(assignment, -this.iLastPreference);
                this.iLastPreference = SameLinkConstraint.this.getCurrentPreference(assignment);
                SameLinkConstraint.this.getModel().getCriterion(SameLink.class).inc(assignment, this.iLastPreference);
            }
        }

        public int getPreference() {
            return this.iLastPreference;
        }
    }
}

