/*
 * Decompiled with CFR 0.152.
 */
package org.cpsolver.ifs.extension;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.cpsolver.ifs.assignment.Assignment;
import org.cpsolver.ifs.extension.AssignedValue;
import org.cpsolver.ifs.extension.Extension;
import org.cpsolver.ifs.model.Constraint;
import org.cpsolver.ifs.model.ConstraintListener;
import org.cpsolver.ifs.model.Model;
import org.cpsolver.ifs.model.Value;
import org.cpsolver.ifs.model.Variable;
import org.cpsolver.ifs.solver.Solver;
import org.cpsolver.ifs.util.DataProperties;

public class ConflictStatistics<V extends Variable<V, T>, T extends Value<V, T>>
extends Extension<V, T>
implements ConstraintListener<V, T> {
    private static final String PARAM_AGEING = "ConflictStatistics.Ageing";
    private static final String PARAM_HALF_AGE = "ConflictStatistics.AgeingHalfTime";
    private static final String PARAM_PRINT = "ConflictStatistics.Print";
    private double iAgeing = 1.0;
    private boolean iPrint = false;
    private Map<AssignedValue<T>, List<AssignedValue<T>>> iAssignments = new HashMap<AssignedValue<T>, List<AssignedValue<T>>>();
    private Map<V, List<AssignedValue<T>>> iUnassignedVariables = new HashMap<V, List<AssignedValue<T>>>();
    private Map<AssignedValue<T>, List<AssignedValue<T>>> iNoGoods = new HashMap<AssignedValue<T>, List<AssignedValue<T>>>();
    private final ReentrantReadWriteLock iLock = new ReentrantReadWriteLock();

    public ConflictStatistics(Solver<V, T> solver, DataProperties properties) {
        super(solver, properties);
        this.iAgeing = properties.getPropertyDouble(PARAM_AGEING, this.iAgeing);
        int halfAge = properties.getPropertyInt(PARAM_HALF_AGE, 0);
        if (halfAge > 0) {
            this.iAgeing = Math.exp(Math.log(0.5) / (double)halfAge);
        }
        this.iPrint = properties.getPropertyBoolean(PARAM_PRINT, this.iPrint);
    }

    @Override
    public void register(Model<V, T> model) {
        super.register(model);
    }

    @Override
    public void unregister(Model<V, T> model) {
        super.unregister(model);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void variableUnassigned(long iteration, T unassignedValue, AssignedValue<T> noGood) {
        if (iteration <= 0L) {
            return;
        }
        this.iLock.writeLock().lock();
        try {
            AssignedValue<T> unass = new AssignedValue<T>(iteration, unassignedValue, this.iAgeing);
            List<AssignedValue<T>> noGoodsForUnassignment = this.iNoGoods.get(unass);
            if (noGoodsForUnassignment != null) {
                if (noGoodsForUnassignment.contains(noGood)) {
                    noGoodsForUnassignment.get(noGoodsForUnassignment.indexOf(noGood)).incCounter(iteration);
                } else {
                    noGoodsForUnassignment.add(noGood);
                }
            } else {
                noGoodsForUnassignment = new ArrayList<AssignedValue<T>>();
                noGoodsForUnassignment.add(noGood);
                this.iNoGoods.put(unass, noGoodsForUnassignment);
            }
        }
        finally {
            this.iLock.writeLock().unlock();
        }
    }

    public void reset() {
        this.iLock.writeLock().lock();
        try {
            this.iUnassignedVariables.clear();
            this.iAssignments.clear();
        }
        finally {
            this.iLock.writeLock().unlock();
        }
    }

    public Map<AssignedValue<T>, List<AssignedValue<T>>> getNoGoods() {
        return this.iNoGoods;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void variableUnassigned(long iteration, T unassignedValue, T assignedValue) {
        if (iteration <= 0L) {
            return;
        }
        AssignedValue<T> ass = new AssignedValue<T>(iteration, assignedValue, this.iAgeing);
        AssignedValue<T> unass = new AssignedValue<T>(iteration, unassignedValue, this.iAgeing);
        this.iLock.writeLock().lock();
        try {
            List<Object> asss;
            if (this.iAssignments.containsKey(unass)) {
                asss = this.iAssignments.get(unass);
                if (asss.contains(ass)) {
                    ((AssignedValue)asss.get(asss.indexOf(ass))).incCounter(iteration);
                } else {
                    asss.add(ass);
                }
            } else {
                asss = new ArrayList<AssignedValue<T>>();
                asss.add(ass);
                this.iAssignments.put(unass, asss);
            }
            if (this.iUnassignedVariables.containsKey(((Value)unassignedValue).variable())) {
                asss = this.iUnassignedVariables.get(((Value)unassignedValue).variable());
                if (asss.contains(ass)) {
                    ((AssignedValue)asss.get(asss.indexOf(ass))).incCounter(iteration);
                } else {
                    asss.add(ass);
                }
            } else {
                asss = new ArrayList();
                asss.add(ass);
                this.iUnassignedVariables.put((List<Object>)((Value)unassignedValue).variable(), (List<AssignedValue<T>>)asss);
            }
        }
        finally {
            this.iLock.writeLock().unlock();
        }
    }

    public double countRemovals(long iteration, Collection<T> conflictValues, T value) {
        long ret = 0L;
        for (Value conflictValue : conflictValues) {
            ret = (long)((double)ret + this.countRemovals(iteration, conflictValue, value));
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double countRemovals(long iteration, T conflictValue, T value) {
        this.iLock.readLock().lock();
        try {
            List<AssignedValue<T>> asss = this.iUnassignedVariables.get(((Value)conflictValue).variable());
            if (asss == null) {
                double d = 0.0;
                return d;
            }
            AssignedValue<T> ass = new AssignedValue<T>(iteration, value, this.iAgeing);
            int idx = asss.indexOf(ass);
            if (idx < 0) {
                double d = 0.0;
                return d;
            }
            double d = asss.get(idx).getCounter(iteration);
            return d;
        }
        finally {
            this.iLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long countPotentialConflicts(Assignment<V, T> assignment, long iteration, T value, int limit) {
        this.iLock.readLock().lock();
        try {
            List<AssignedValue<T>> asss = this.iAssignments.get(new AssignedValue<T>(iteration, value, this.iAgeing));
            if (asss == null) {
                long l = 0L;
                return l;
            }
            long count = 0L;
            for (AssignedValue<T> ass : asss) {
                if (((Variable)((Value)ass.getValue()).variable()).getAssignment(assignment) != null) continue;
                if (limit >= 0) {
                    count = (long)((double)count + ass.getCounter(iteration) * (double)Math.max(0, 1 + limit - ((Variable)((Value)value).variable()).getModel().conflictValues(assignment, ass.getValue()).size()));
                    continue;
                }
                count = (long)((double)count + ass.getCounter(iteration));
            }
            long l = count;
            return l;
        }
        finally {
            this.iLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long countAssignments(V variable) {
        this.iLock.readLock().lock();
        try {
            List<AssignedValue<T>> assignments = this.iUnassignedVariables.get(variable);
            if (assignments == null || assignments.isEmpty()) {
                long l = 0L;
                return l;
            }
            double ret = 0.0;
            for (AssignedValue<T> assignment : assignments) {
                ret += assignment.getCounter(0L);
            }
            long l = Math.round(ret);
            return l;
        }
        finally {
            this.iLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        this.iLock.readLock().lock();
        try {
            if (this.iPrint) {
                StringBuffer sb = new StringBuffer("Statistics{");
                TreeSet<AssignedValue<T>> sortedUnassignments = new TreeSet<AssignedValue<T>>(new Comparator<AssignedValue<T>>(){

                    @Override
                    public int compare(AssignedValue<T> x1, AssignedValue<T> x2) {
                        int c1 = 0;
                        int c2 = 0;
                        for (AssignedValue y : (List)ConflictStatistics.this.iNoGoods.get(x1)) {
                            c1 = (int)((double)c1 + y.getCounter(0L));
                        }
                        for (AssignedValue y : (List)ConflictStatistics.this.iNoGoods.get(x2)) {
                            c2 = (int)((double)c2 + y.getCounter(0L));
                        }
                        int cmp = Double.compare(c1, c2);
                        if (cmp != 0) {
                            return -cmp;
                        }
                        return x1.compareTo(0L, x2);
                    }
                });
                sortedUnassignments.addAll(this.iNoGoods.keySet());
                int printedUnassignments = 0;
                for (AssignedValue assignedValue : sortedUnassignments) {
                    int c = 0;
                    for (AssignedValue<T> y : this.iNoGoods.get(assignedValue)) {
                        c = (int)((double)c + y.getCounter(0L));
                    }
                    sb.append("\n    ").append(c + "x ").append(assignedValue.toString(0L, false)).append(" <= {");
                    TreeSet sortedAssignments = new TreeSet(new Comparator<AssignedValue<T>>(){

                        @Override
                        public int compare(AssignedValue<T> x1, AssignedValue<T> x2) {
                            int cmp = Double.compare(x1.getCounter(0L), x2.getCounter(0L));
                            if (cmp != 0) {
                                return -cmp;
                            }
                            return x1.compareTo(0L, x2);
                        }
                    });
                    sortedAssignments.addAll(this.iNoGoods.get(assignedValue));
                    int printedAssignments = 0;
                    for (AssignedValue y : sortedAssignments) {
                        sb.append("\n        ").append(y.toString(0L, true));
                        if (++printedAssignments != 20) continue;
                        sb.append("\n        ...");
                        break;
                    }
                    sb.append("\n      }");
                    if (++printedUnassignments != 100) continue;
                    sb.append("\n     ...");
                    break;
                }
                sb.append("\n    }");
                String string = sb.toString();
                return string;
            }
            StringBuffer sb = new StringBuffer("Statistics{");
            TreeSet<V> sortedUnassignedVariables = new TreeSet<V>(new Comparator<V>(){

                @Override
                public int compare(V v1, V v2) {
                    int cmp = Double.compare(ConflictStatistics.this.countAssignments(v1), ConflictStatistics.this.countAssignments(v2));
                    if (cmp != 0) {
                        return -cmp;
                    }
                    return ((Variable)v1).compareTo(v2);
                }
            });
            sortedUnassignedVariables.addAll(this.iUnassignedVariables.keySet());
            int printedVariables = 0;
            for (Variable variable : sortedUnassignedVariables) {
                sb.append("\n      ").append(this.countAssignments(variable) + "x ").append(variable.getName()).append(" <= {");
                TreeSet sortedAssignments = new TreeSet(new Comparator<AssignedValue<T>>(){

                    @Override
                    public int compare(AssignedValue<T> x1, AssignedValue<T> x2) {
                        int cmp = Double.compare(x1.getCounter(0L), x2.getCounter(0L));
                        if (cmp != 0) {
                            return -cmp;
                        }
                        return x1.compareTo(0L, x2);
                    }
                });
                sortedAssignments.addAll(this.iUnassignedVariables.get(variable));
                int printedAssignments = 0;
                for (AssignedValue x : sortedAssignments) {
                    sb.append("\n        ").append(x.toString(0L, true));
                    if (++printedAssignments != 20) continue;
                    sb.append("\n        ...");
                    break;
                }
                sb.append("\n      }");
                if (++printedVariables != 100) continue;
                sb.append("\n      ...");
                break;
            }
            sb.append("\n    }");
            String string = sb.toString();
            return string;
        }
        finally {
            this.iLock.readLock().unlock();
        }
    }

    @Override
    public void constraintBeforeAssigned(Assignment<V, T> assignment, long iteration, Constraint<V, T> constraint, T assigned, Set<T> unassigned) {
    }

    @Override
    public void constraintAfterAssigned(Assignment<V, T> assignment, long iteration, Constraint<V, T> constraint, T assigned, Set<T> unassigned) {
        if (iteration <= 0L) {
            return;
        }
        if (unassigned == null || unassigned.isEmpty()) {
            return;
        }
        if (this.iPrint) {
            AssignedValue<T> noGood = new AssignedValue<T>(iteration, assigned, this.iAgeing);
            noGood.setConstraint(constraint);
            for (Value unassignedValue : unassigned) {
                this.variableUnassigned(iteration, (T)unassignedValue, (T)noGood);
                this.variableUnassigned(iteration, unassignedValue, assigned);
            }
        } else {
            for (Value unassignedValue : unassigned) {
                this.variableUnassigned(iteration, unassignedValue, assigned);
            }
        }
    }

    @Override
    public void constraintAdded(Constraint<V, T> constraint) {
        constraint.addConstraintListener(this);
    }

    @Override
    public void constraintRemoved(Constraint<V, T> constraint) {
        constraint.removeConstraintListener(this);
    }
}

