/*
 * Decompiled with CFR 0.152.
 */
package org.cpsolver.ifs.example.jobshop;

import java.util.Set;
import org.cpsolver.ifs.assignment.Assignment;
import org.cpsolver.ifs.example.jobshop.Location;
import org.cpsolver.ifs.example.jobshop.Operation;
import org.cpsolver.ifs.model.Constraint;

public class Machine
extends Constraint<Operation, Location> {
    private int iMachineNumber = -1;

    public Machine(int machineNumber) {
        this.iMachineNumber = machineNumber;
    }

    public int getMachineNumber() {
        return this.iMachineNumber;
    }

    @Override
    public void computeConflicts(Assignment<Operation, Location> assignment, Location location, Set<Location> conflicts) {
        for (Operation o : this.assignedVariables(assignment)) {
            Location conf;
            if (o.getOperationNumber() == ((Operation)location.variable()).getOperationNumber() && o.getJobNumber() == ((Operation)location.variable()).getJobNumber() || !(conf = assignment.getValue(o)).overlap(location)) continue;
            conflicts.add(conf);
        }
    }

    @Override
    public boolean inConflict(Assignment<Operation, Location> assignment, Location location) {
        for (Operation o : this.assignedVariables(assignment)) {
            if (o.getOperationNumber() == ((Operation)location.variable()).getOperationNumber() && o.getJobNumber() == ((Operation)location.variable()).getJobNumber() || !assignment.getValue(o).overlap(location)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isConsistent(Location value1, Location value2) {
        return !value1.overlap(value2);
    }

    public String toString() {
        return this.getName();
    }

    @Override
    public String getName() {
        return "M" + this.iMachineNumber;
    }
}

