/*
 * Decompiled with CFR 0.152.
 */
package org.cpsolver.ifs.assignment.context;

import org.cpsolver.ifs.assignment.Assignment;
import org.cpsolver.ifs.assignment.context.AssignmentConstraintContext;
import org.cpsolver.ifs.assignment.context.AssignmentContext;
import org.cpsolver.ifs.assignment.context.AssignmentContextHelper;
import org.cpsolver.ifs.assignment.context.AssignmentContextReference;
import org.cpsolver.ifs.assignment.context.CanHoldContext;
import org.cpsolver.ifs.assignment.context.HasAssignmentContext;
import org.cpsolver.ifs.model.Model;
import org.cpsolver.ifs.model.Value;
import org.cpsolver.ifs.model.Variable;

public abstract class ModelWithContext<V extends Variable<V, T>, T extends Value<V, T>, C extends AssignmentConstraintContext<V, T>>
extends Model<V, T>
implements HasAssignmentContext<V, T, C>,
CanHoldContext {
    private AssignmentContextReference<V, T, C> iContextReference = null;
    private AssignmentContext[] iContext = new AssignmentContext[17];
    private ContextUpdateType iContextUpdateType = ContextUpdateType.BeforeUnassignedAfterAssigned;

    public ModelWithContext() {
        this.iContextReference = this.createReference(this);
    }

    @Override
    public C getContext(Assignment<V, T> assignment) {
        return (C)((AssignmentConstraintContext)AssignmentContextHelper.getContext(this, assignment));
    }

    @Override
    public AssignmentContextReference<V, T, C> getAssignmentContextReference() {
        return this.iContextReference;
    }

    @Override
    public void setAssignmentContextReference(AssignmentContextReference<V, T, C> reference) {
        this.iContextReference = reference;
    }

    @Override
    public AssignmentContext[] getContext() {
        return this.iContext;
    }

    @Override
    public void beforeUnassigned(Assignment<V, T> assignment, long iteration, T value) {
        super.beforeUnassigned(assignment, iteration, value);
        switch (this.getContextUpdateType()) {
            case BeforeUnassignedAfterAssigned: 
            case BeforeUnassignedBeforeAssigned: {
                this.getContext((Assignment)assignment).unassigned(assignment, value);
            }
        }
    }

    @Override
    public void afterUnassigned(Assignment<V, T> assignment, long iteration, T value) {
        super.afterUnassigned(assignment, iteration, value);
        switch (this.getContextUpdateType()) {
            case AfterUnassignedAfterAssigned: 
            case AfterUnassignedBeforeAssigned: {
                this.getContext((Assignment)assignment).unassigned(assignment, value);
            }
        }
    }

    @Override
    public void afterAssigned(Assignment<V, T> assignment, long iteration, T value) {
        super.afterAssigned(assignment, iteration, value);
        switch (this.getContextUpdateType()) {
            case BeforeUnassignedAfterAssigned: 
            case AfterUnassignedAfterAssigned: {
                this.getContext((Assignment)assignment).assigned(assignment, value);
            }
        }
    }

    @Override
    public void beforeAssigned(Assignment<V, T> assignment, long iteration, T value) {
        super.beforeAssigned(assignment, iteration, value);
        switch (this.getContextUpdateType()) {
            case BeforeUnassignedBeforeAssigned: 
            case AfterUnassignedBeforeAssigned: {
                this.getContext((Assignment)assignment).assigned(assignment, value);
            }
        }
    }

    public ContextUpdateType getContextUpdateType() {
        return this.iContextUpdateType;
    }

    public void setContextUpdateType(ContextUpdateType iContextUpdateType) {
        this.iContextUpdateType = iContextUpdateType;
    }

    protected static enum ContextUpdateType {
        BeforeUnassignedBeforeAssigned,
        AfterUnassignedBeforeAssigned,
        BeforeUnassignedAfterAssigned,
        AfterUnassignedAfterAssigned,
        NoUpdate;

    }
}

