/*
 * Decompiled with CFR 0.152.
 */
package org.cpsolver.ifs.assignment.context;

import org.cpsolver.ifs.assignment.Assignment;
import org.cpsolver.ifs.assignment.context.AssignmentContext;
import org.cpsolver.ifs.assignment.context.AssignmentContextHolderMap;
import org.cpsolver.ifs.assignment.context.AssignmentContextReference;
import org.cpsolver.ifs.assignment.context.CanHoldContext;
import org.cpsolver.ifs.model.Value;
import org.cpsolver.ifs.model.Variable;

public class DefaultParallelAssignmentContextHolder<V extends Variable<V, T>, T extends Value<V, T>>
extends AssignmentContextHolderMap<V, T> {
    protected int iIndex = -1;

    public DefaultParallelAssignmentContextHolder(int threadIndex) {
        this.iIndex = threadIndex;
    }

    @Override
    public <U extends AssignmentContext> U getAssignmentContext(Assignment<V, T> assignment, AssignmentContextReference<V, T, U> reference) {
        if (this.iIndex >= 0 && this.iIndex < 17 && reference.getParent() instanceof CanHoldContext) {
            AssignmentContext[] contexts = ((CanHoldContext)((Object)reference.getParent())).getContext();
            AssignmentContext context = contexts[this.iIndex];
            if (context == null) {
                contexts[this.iIndex] = context = reference.getParent().createAssignmentContext(assignment);
            }
            return (U)context;
        }
        return super.getAssignmentContext(assignment, reference);
    }

    @Override
    public <C extends AssignmentContext> void clearContext(AssignmentContextReference<V, T, C> reference) {
        if (this.iIndex >= 0 && this.iIndex < 17 && reference.getParent() instanceof CanHoldContext) {
            AssignmentContext[] contexts = ((CanHoldContext)((Object)reference.getParent())).getContext();
            contexts[this.iIndex] = null;
        } else {
            super.clearContext(reference);
        }
    }
}

