/*
 * Decompiled with CFR 0.152.
 */
package org.cpsolver.exam.criteria;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.cpsolver.exam.criteria.ExamCriterion;
import org.cpsolver.exam.criteria.additional.DistributionViolation;
import org.cpsolver.exam.model.Exam;
import org.cpsolver.exam.model.ExamDistributionConstraint;
import org.cpsolver.exam.model.ExamModel;
import org.cpsolver.exam.model.ExamPlacement;
import org.cpsolver.ifs.assignment.Assignment;
import org.cpsolver.ifs.criteria.AbstractCriterion;
import org.cpsolver.ifs.model.Model;
import org.cpsolver.ifs.util.DataProperties;

public class DistributionPenalty
extends ExamCriterion {
    protected Integer iSoftDistributions = null;

    public DistributionPenalty() {
        this.setValueUpdateType(AbstractCriterion.ValueUpdateType.NoUpdate);
    }

    @Override
    public void setModel(Model<Exam, ExamPlacement> model) {
        super.setModel(model);
        this.iSoftDistributions = ((ExamModel)model).getProperties().getPropertyInteger("Exam.SoftDistributions", null);
        if (this.iSoftDistributions != null && model.getCriterion(DistributionViolation.class) == null) {
            DistributionViolation dv = new DistributionViolation();
            model.addCriterion(dv);
        }
    }

    @Override
    public String getWeightName() {
        return "Exams.DistributionWeight";
    }

    @Override
    public String getXmlWeightName() {
        return "distributionWeight";
    }

    @Override
    public double getWeightDefault(DataProperties config) {
        return 1.0;
    }

    @Override
    public double getValue(Assignment<Exam, ExamPlacement> assignment, ExamPlacement value, Set<ExamPlacement> conflicts) {
        int penalty = 0;
        ExamPlacement original = assignment.getValue((Exam)value.variable());
        for (ExamDistributionConstraint dc : ((Exam)value.variable()).getDistributionConstraints()) {
            if (dc.isHard() || this.iSoftDistributions != null && this.iSoftDistributions.intValue() == dc.getWeight()) continue;
            penalty += dc.countViolations(assignment, value) * dc.getWeight();
            if (original == null) continue;
            penalty -= dc.countViolations(assignment, original) * dc.getWeight();
        }
        return penalty;
    }

    @Override
    public boolean isRoomCriterion() {
        return true;
    }

    @Override
    public double getRoomValue(Assignment<Exam, ExamPlacement> assignment, ExamPlacement value) {
        int penalty = 0;
        ExamPlacement original = assignment.getValue((Exam)value.variable());
        for (ExamDistributionConstraint dc : ((Exam)value.variable()).getDistributionConstraints()) {
            if (dc.isHard() || this.iSoftDistributions != null && this.iSoftDistributions.intValue() == dc.getWeight() || !dc.isRoomRelated()) continue;
            penalty += dc.countViolations(assignment, value) * dc.getWeight();
            if (original == null) continue;
            penalty -= dc.countViolations(assignment, original) * dc.getWeight();
        }
        return penalty;
    }

    @Override
    public double getValue(Assignment<Exam, ExamPlacement> assignment, Collection<Exam> variables) {
        int penalty = 0;
        HashSet<ExamDistributionConstraint> added = new HashSet<ExamDistributionConstraint>();
        for (Exam exam : variables) {
            for (ExamDistributionConstraint dc : exam.getDistributionConstraints()) {
                if (!added.add(dc) || dc.isHard() || this.iSoftDistributions != null && this.iSoftDistributions.intValue() == dc.getWeight()) continue;
                penalty += dc.countViolations(assignment) * dc.getWeight();
            }
        }
        return penalty;
    }

    @Override
    public boolean isPeriodCriterion() {
        return true;
    }

    public void inc(Assignment<Exam, ExamPlacement> assignment, double value, ExamDistributionConstraint dc) {
        if (this.iSoftDistributions != null && this.iSoftDistributions.intValue() == dc.getWeight()) {
            this.getModel().getCriterion(DistributionViolation.class).inc(assignment, value / (double)dc.getWeight());
        } else {
            super.inc(assignment, value);
        }
    }

    @Override
    public double getPeriodValue(Assignment<Exam, ExamPlacement> assignment, ExamPlacement value) {
        int penalty = 0;
        ExamPlacement original = assignment.getValue((Exam)value.variable());
        for (ExamDistributionConstraint dc : ((Exam)value.variable()).getDistributionConstraints()) {
            if (dc.isHard() || this.iSoftDistributions != null && this.iSoftDistributions.intValue() == dc.getWeight() || !dc.isPeriodRelated()) continue;
            penalty += dc.countViolations(assignment, value) * dc.getWeight();
            if (original == null) continue;
            penalty -= dc.countViolations(assignment, original) * dc.getWeight();
        }
        return penalty;
    }

    @Override
    protected double[] computeBounds(Assignment<Exam, ExamPlacement> assignment) {
        double[] bounds = new double[]{0.0, 0.0};
        for (ExamDistributionConstraint dc : ((ExamModel)this.getModel()).getDistributionConstraints()) {
            if (dc.isHard() || this.iSoftDistributions != null && this.iSoftDistributions.intValue() == dc.getWeight()) continue;
            bounds[1] = bounds[1] + (double)(dc.getWeight() * dc.variables().size() * (dc.variables().size() - 1) / 2);
        }
        return bounds;
    }

    @Override
    public String toString(Assignment<Exam, ExamPlacement> assignment) {
        return this.getValue(assignment) <= 0.0 ? "" : "DP:" + sDoubleFormat.format(this.getValue(assignment));
    }
}

